/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.rdoc.RDocHighlighter;
import org.jetbrains.plugins.ruby.rdoc.yard.references.YARDReferenceProvider;
import org.jetbrains.plugins.ruby.ruby.lang.annotator.RubyAnnotatorUtil;
import org.jetbrains.plugins.ruby.ruby.lang.highlighter.RubyHighlighter;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.UnknownRubyCallType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public final class RubyHighlightingAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            RubyHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RubyHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)new MyVisitor(holder));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ruby/ruby/lang/annotator/RubyHighlightingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyVisitor
    extends RubyElementVisitor {
        private static final ProcessingContext YARD_PROCESSING_CONTEXT = new ProcessingContext();
        private final AnnotationHolder myHolder;

        private MyVisitor(@NotNull AnnotationHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (comment == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            for (PsiReference reference : YARDReferenceProvider.getInstance().getReferencesByElement((PsiElement)comment, YARD_PROCESSING_CONTEXT)) {
                TextRange range = reference.getRangeInElement().shiftRight(comment.getTextRange().getStartOffset());
                this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(RDocHighlighter.IDENTIFIER).create();
            }
        }

        public void visitRAssocKey(@NotNull RAssocKey assocKey) {
            if (assocKey == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            this.highlight((PsiElement)assocKey, RubyHighlighter.HASH_KEY);
        }

        public void visitRAssoc(@NotNull RAssoc assoc) {
            RPsiElement rPsiElement;
            if (assoc == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((rPsiElement = assoc.getKey()) instanceof RSymbol) {
                RSymbol key = (RSymbol)rPsiElement;
                this.highlight((PsiElement)key, RubyHighlighter.HASH_KEY);
            }
        }

        public void visitRCall(@NotNull RCall call) {
            PsiElement command;
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (!((command = RubyAnnotatorUtil.getHighlightElementForCall((RPossibleCall)call)).getParent() instanceof RReference)) {
                this.highlightCallType(command, call.getCallType());
            }
        }

        public void visitRConstant(@NotNull RConstant constant) {
            PsiElement element;
            if (constant == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)(element = (PsiElement)ObjectUtils.coalesce((Object)RReferenceNavigator.getRRefenceOrTopReference((PsiElement)constant), (Object)constant))) != null) {
                this.highlight((PsiElement)constant, RubyHighlighter.CONSTANT_DECLARATION);
            } else if (RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart((PsiElement)element) != null) {
                this.highlight((PsiElement)constant, RubyHighlighter.CONSTANT_DECLARATION);
            }
        }

        public void visitRFName(@NotNull RFName name) {
            if (name == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (RSymbolNavigator.getSymbolByObject((PsiElement)name) == null) {
                this.highlight((PsiElement)name, RubyHighlighter.METHOD_NAME);
            }
        }

        public void visitRGlobalVariable(@NotNull RGlobalVariable globalVariable) {
            if (globalVariable == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (globalVariable.isBackReference() || globalVariable.isNthReference()) {
                this.highlight((PsiElement)globalVariable, RubyHighlighter.GROUP_REF);
            }
        }

        public void visitRIdentifier(@NotNull RIdentifier identifier) {
            if (identifier == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if (identifier.isParameter()) {
                this.highlight((PsiElement)identifier, RubyHighlighter.PARAMETER);
            } else if (identifier.isLocalVariable()) {
                this.highlight((PsiElement)identifier, RubyHighlighter.LOCAL_VARIABLE);
            } else if (RCompoundStatementNavigator.isStatement((PsiElement)identifier) || RBlockCallNavigator.getByCall((RPsiElement)identifier) != null) {
                this.highlightCallType((PsiElement)identifier, identifier.getCallType());
            }
        }

        public void visitRName(@NotNull RName name) {
            RContainer container;
            if (name == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
            if ((container = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)name, RContainer.class)) instanceof RClass || container instanceof RModule) {
                this.highlight(PsiTreeUtil.getDeepestLast((PsiElement)name), RubyHighlighter.CONSTANT_DECLARATION);
            }
        }

        public void visitRReference(@NotNull RReference reference) {
            RPsiElement value;
            if (reference == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            if ((value = reference.getValue()) != null) {
                this.highlightCallType((PsiElement)value, reference.getCallType());
            }
        }

        public void visitRDStringLiteral(@NotNull RStringLiteral literal) {
            PsiElement ending;
            PsiElement beginning;
            if (literal == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if ((beginning = literal.getStringBeginning()) != null) {
                this.highlight(beginning, RubyHighlighter.INTERPOLATED_STRING);
            }
            if ((ending = literal.getStringEnding()) != null) {
                this.highlight(ending, RubyHighlighter.INTERPOLATED_STRING);
            }
            for (PsiElement content : literal.getPsiContent()) {
                if (!TokenBNF.tSTRING_LIKE_CONTENTS.contains(PsiUtilCore.getElementType((PsiElement)content))) continue;
                this.highlight(content, RubyHighlighter.INTERPOLATED_STRING);
            }
        }

        private void highlight(@NotNull PsiElement element, @NotNull TextAttributesKey key) {
            if (element == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if (key == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.myHolder.newAnnotation(HighlightSeverity.INFORMATION, key.getExternalName()).range(element).textAttributes(key).create();
            } else {
                this.myHolder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(key).create();
            }
        }

        private void highlightCallType(@NotNull PsiElement call, @NotNull RubyCallType<?> callType) {
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            if (callType == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            if (callType != UnknownRubyCallType.INSTANCE) {
                this.highlight(call, RubyHighlighter.RUBY_SPECIFIC_CALL);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assocKey";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assoc";
                    break;
                }
                case 4: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "globalVariable";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/annotator/RubyHighlightingAnnotator$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRAssocKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRAssoc";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRCall";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRConstant";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRFName";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRGlobalVariable";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIdentifier";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRName";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRReference";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRDStringLiteral";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlight";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "highlightCallType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

