/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.annotator;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.annotator.RubyAnnotatorUtil;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.ruby19.Ruby19TokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.Ruby19ElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.RubyElementTypes;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.LexicalBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.bnf.TokenBNF;
import org.jetbrains.plugins.ruby.ruby.lang.parser.parsingUtils.ErrorMsg;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyCommonPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RFloatConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RIntegerConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RNumericConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.heredocs.RHeredocId;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCaseStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhenCase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentDestructing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArrayArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RHashArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RNamedArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RRescueModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RArrayPattern;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RArrayPatternBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RHashPattern;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RInMatch;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RPatternExprRef;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.patternMatching.RPatternVarRef;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RRangeExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.names.RNameNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.patternMatching.RInMatchNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RGroupedExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RSelfAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArgumentToBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RForwardArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RHashToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RBlockLocalVariables;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.impl.controlStructures.RLambdaNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.quickfix.RemoveElementQuickFix;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

public class RubyAnnotatorVisitor
extends RubyElementVisitor {
    private static final Logger LOG = Logger.getInstance(RubyAnnotatorVisitor.class);
    private final AnnotationHolder myHolder;
    private static final TokenSet ASSOC_LIST_ALLOWED_TYPES = TokenSet.create((IElementType[])new IElementType[]{RubyElementTypes.ASSOC, RubyElementTypes.HEREDOC_VALUE, Ruby19ElementTypes.HASH_TO_ARGS});

    public RubyAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitRAliasStatement(@NotNull RAliasStatement statement) {
        RGlobalVariable globalVariable;
        RPsiElement rPsiElement;
        if (statement == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if ((rPsiElement = statement.getPsiNewName()) instanceof RGlobalVariable && (globalVariable = (RGlobalVariable)rPsiElement).isNthReference()) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.cannot.make.alias.for.nth.variable")).create();
        }
    }

    public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignment) {
        RGlobalVariable variable;
        if (assignment == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if ((variable = (RGlobalVariable)ObjectUtils.tryCast((Object)assignment.getObject(), RGlobalVariable.class)) == null || !variable.isNthReference()) {
            return;
        }
        LanguageLevel languageLevel = (LanguageLevel)ObjectUtils.coalesce((Object)assignment.getLanguageLevel(), (Object)LanguageLevel.latest());
        VirtualFile root = VirtualFileManager.getInstance().findFileByNioPath(RubySdkUtil.getStubsDir(languageLevel));
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)assignment);
        if (root != null && file != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) {
            return;
        }
        this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.cannot.assign.nth.reference.variable")).range(variable.getTextRange().shiftRight(1).grown(-1)).create();
    }

    private static boolean isClassName(@NotNull RPsiElement rIdentifier) {
        RName rName;
        if (rIdentifier == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        if ((rName = RNameNavigator.getRName((PsiElement)rIdentifier)) == null) {
            return false;
        }
        if (rName.getNode().getElementType() == RubyElementTypes.SUPER_CLASS) {
            return rIdentifier.getParent().equals(rName);
        }
        return true;
    }

    public void visitRForwardArguments(@NotNull RForwardArguments forwardArguments) {
        ArgumentInfo.Type argumentType;
        if (forwardArguments == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY27.isGreaterThan(forwardArguments.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.forward.arguments")).create();
        }
        if ((argumentType = (ArgumentInfo.Type)Optional.ofNullable(RubyPsiUtil.getContainingRMethod((PsiElement)forwardArguments)).map(RMethod::getArgumentInfos).map(ContainerUtil::getLastItem).map(ArgumentInfo::getType).orElse(null)) != ArgumentInfo.Type.CAPTURE) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unexpected.forward.arguments")).create();
        }
    }

    public void visitRIdentifier(final @NotNull RIdentifier rIdentifier) {
        String name;
        Scope scope;
        ScopeHolder scopeHolder;
        if (rIdentifier == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        if (RubyAnnotatorVisitor.isClassName((RPsiElement)rIdentifier)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.class.module.name.must.be.constant")).create();
        }
        if (rIdentifier.isNumberedParameter() && !rIdentifier.isNumberedParameterAlias()) {
            scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)rIdentifier);
            if (scopeHolder != null) {
                if (RubyPsiUtil.hasBlockOrLambdaArguments(scopeHolder)) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.numbered.parameter.ordinary.defined")).create();
                }
                final Ref precedingNumberedParameter = new Ref((Object)false);
                scopeHolder.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ProgressManager.checkCanceled();
                        if (!((Boolean)precedingNumberedParameter.get()).booleanValue() && RubyPsiUtilCore.isBefore((PsiElement)element, (PsiElement)rIdentifier)) {
                            element.acceptChildren((PsiElementVisitor)this);
                        }
                    }

                    public void visitRIdentifier(@NotNull RIdentifier identifier) {
                        RCodeBlock codeBlock;
                        if (identifier == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (identifier != rIdentifier && identifier.isNumberedParameter() && !identifier.isNumberedParameterAlias() && identifier.getParentContainer() == rIdentifier.getParentContainer() && (codeBlock = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)identifier, RCodeBlock.class)) != null && PsiTreeUtil.isAncestor((PsiElement)scopeHolder, (PsiElement)codeBlock, (boolean)true)) {
                            precedingNumberedParameter.set((Object)true);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "identifier";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/annotator/RubyAnnotatorVisitor$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitElement";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "visitRIdentifier";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
                if (((Boolean)precedingNumberedParameter.get()).booleanValue()) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.numbered.parameter.already.used.in.inner.block")).create();
                }
                ScopeHolder outerScopeHolder = scopeHolder;
                while ((outerScopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)outerScopeHolder)) != null && !(outerScopeHolder instanceof RMethodHolder) && !(outerScopeHolder instanceof RMethod)) {
                    List outerNumberedParameters = outerScopeHolder.getScope().getNumberedParameters((PsiElement)outerScopeHolder);
                    if (!ContainerUtil.or((Iterable)outerNumberedParameters, it -> RubyPsiUtilCore.isBefore((PsiElement)it, (PsiElement)rIdentifier) && !it.isNumberedParameterAlias())) continue;
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.numbered.parameter.already.used.in.outer.block")).create();
                    break;
                }
            }
            if (RubyPsiUtilCore.isDeclaration((PsiElement)rIdentifier)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.numbered.parameter.cant.assign")).create();
            }
        }
        if (rIdentifier.isNumberedParameterAlias() && (scopeHolder = ScopeUtilCore.findScopeHolder((PsiElement)rIdentifier)) != null && RubyPsiUtil.hasBlockOrLambdaArguments(scopeHolder)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.numbered.parameter.ordinary.defined")).create();
        }
        if ((scope = ScopeUtilCore.getScope((RPsiElement)rIdentifier)) != null && rIdentifier.isNumberedParameter()) {
            List numberedParameters = scope.getNumberedParameters((PsiElement)ScopeUtilCore.getScopeElement((PsiElement)rIdentifier));
            if (rIdentifier.isNumberedParameterAlias()) {
                if (ContainerUtil.exists((Iterable)numberedParameters, it -> !it.isNumberedParameterAlias() && RubyPsiUtilCore.isBefore((PsiElement)it, (PsiElement)rIdentifier))) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.numbered.parameter.already.used")).create();
                }
            } else if (ContainerUtil.exists((Iterable)numberedParameters, it -> it.isNumberedParameterAlias() && RubyPsiUtilCore.isBefore((PsiElement)it, (PsiElement)rIdentifier))) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.numbered.parameter.alias.already.used", (Object[])new Object[]{rIdentifier.getText()})).create();
            }
        }
        if (RIdentifier.isNumberedParameterName((CharSequence)(name = rIdentifier.getName())) && RubyPsiUtilCore.getLanguageLevel((PsiElement)rIdentifier).isGreaterThan(LanguageLevel.RUBY26)) {
            if (name.equals("it")) {
                return;
            }
            if (RubyPsiUtilCore.isDeclaration((PsiElement)rIdentifier) || RubyUsageAnalyzerCore.isParameter((RPsiElement)rIdentifier)) {
                this.myHolder.newAnnotation(HighlightSeverity.WARNING, RBundle.message((String)"annotation.warning.numbered.parameter.assignment", (Object[])new Object[]{name})).create();
            }
        }
    }

    public void visitRConstant(@NotNull RConstant rConstant) {
        String text;
        if (rConstant == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY26.isGreaterThan(rConstant.getLanguageLevel()) && !(text = rConstant.getText()).isEmpty() && text.codePointAt(0) > 90 && RubyAnnotatorVisitor.isClassName((RPsiElement)rConstant)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.class.module.name.must.be.constant.unicode")).create();
        }
    }

    public void visitRCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        ProgressManager.checkCanceled();
        boolean assocSeen = false;
        for (RPsiElement arg : rCall.getArguments()) {
            IElementType type = arg.getNode().getElementType();
            if (type == RubyElementTypes.ASSOC) {
                assocSeen = true;
                continue;
            }
            if (!assocSeen || type == RubyElementTypes.DO_BLOCK_CALL || LexicalBNF.COMMANDS.contains(type) || type == RubyElementTypes.ARG_TO_BLOCK || type == Ruby19ElementTypes.HASH_TO_ARGS) continue;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.expected((IElementType)RubyTokenTypes.tASSOC)).range((PsiElement)arg).create();
        }
    }

    public void visitRClass(@NotNull RClass rClass) {
        if (rClass == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(8);
        }
        ProgressManager.checkCanceled();
        if (rClass.getParentContainer() instanceof RMethod) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.class.in.method")).range(rClass.getFirstChild()).create();
        }
    }

    public void visitRMethod(@NotNull RMethod method) {
        if (method == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(9);
        }
        ProgressManager.checkCanceled();
        if (method.isEndless()) {
            if (LanguageLevel.RUBY30.isGreaterThan(method.getLanguageLevel())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.endless.method.definition")).range(method.getFirstChild()).create();
            }
            if (TextUtil.isAID((String)method.getName())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.endless.method.definition.setter")).range(method.getFirstChild()).create();
            }
        }
    }

    public void visitRSingletonMethod(@NotNull RSingletonMethod method) {
        if (method == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(10);
        }
        ProgressManager.checkCanceled();
        if (method.isEndless()) {
            if (LanguageLevel.RUBY30.isGreaterThan(method.getLanguageLevel())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.endless.method.definition")).range(method.getFirstChild()).create();
            }
            if (TextUtil.isAID((String)method.getName())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.endless.method.definition.setter")).range(method.getFirstChild()).create();
            }
        }
        PsiElement receiver = (PsiElement)ObjectUtils.doIfNotNull((Object)method.getClassObject(), RClassObject::getExpression);
        while (receiver != null) {
            if (receiver instanceof RGroupedExpression) {
                RGroupedExpression groupedExpression = (RGroupedExpression)receiver;
                receiver = groupedExpression.getExpression();
                continue;
            }
            if (!(receiver instanceof RCompoundStatement)) break;
            RCompoundStatement compoundStatement = (RCompoundStatement)receiver;
            receiver = (PsiElement)ContainerUtil.getLastItem((List)compoundStatement.getStatements());
        }
        if (receiver instanceof RLiteral || receiver instanceof RSymbol) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.literal.singleton.method.definition")).range(receiver).create();
        }
    }

    public void visitRModule(@NotNull RModule rModule) {
        if (rModule == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(11);
        }
        ProgressManager.checkCanceled();
        if (rModule.getParentContainer() instanceof RMethod) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.module.in.method")).range(rModule.getFirstChild()).create();
        }
    }

    public void visitRArgument(@NotNull RArgument rParameter) {
        if (rParameter == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(12);
        }
        ProgressManager.checkCanceled();
        PsiElement firstChild = rParameter.getFirstChild();
        if (firstChild instanceof RConstant) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.formal.arg.cannot.be.constant")).create();
        }
        if (firstChild instanceof RInstanceVariable) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.formal.arg.cannot.be.inst.var")).create();
        }
        if (firstChild instanceof RGlobalVariable) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.formal.arg.cannot.be.global.var")).create();
        }
        if (firstChild instanceof RClassVariable) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.formal.arg.cannot.be.class.var")).create();
        }
        switch (rParameter.getType()) {
            case CAPTURE: {
                RMethod method;
                if (LanguageLevel.RUBY27.isGreaterThan(rParameter.getLanguageLevel())) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.forward.arguments")).create();
                }
                if ((method = RubyPsiUtil.getContainingRMethod((PsiElement)rParameter)) == null || method.getArguments().size() <= 1 || LanguageLevel.RUBY27 != rParameter.getLanguageLevel()) break;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.forward.arguments.with.leading")).create();
                break;
            }
            case HASH: {
                if (!LanguageLevel.RUBY20.isGreaterThan(rParameter.getLanguageLevel())) break;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.named.arg")).create();
                break;
            }
            case BLOCK: 
            case BLOCK_REQUIRED: {
                if (!rParameter.getName().isEmpty() || !LanguageLevel.RUBY31.isGreaterThan(rParameter.getLanguageLevel())) break;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unexpected.anonymous.block")).create();
            }
        }
    }

    public void visitRAssoc(@NotNull RAssoc rAssoc) {
        if (rAssoc == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(13);
        }
        RPsiElement key = rAssoc.getKey();
        if (!(rAssoc.getParent() instanceof RHashPattern) && key instanceof RAssocKey && rAssoc.getValue() == null && LanguageLevel.RUBY31.isGreaterThan(rAssoc.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.valueless.hash")).create();
        }
        super.visitRAssoc(rAssoc);
    }

    public void visitRNamedArgument(@NotNull RNamedArgument namedArgument) {
        LanguageLevel level;
        if (namedArgument == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(14);
        }
        ProgressManager.checkCanceled();
        PsiElement comma = namedArgument.getFirstChild().getNextSibling();
        if (comma instanceof PsiWhiteSpace) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unexpected.named.arg")).range(comma).create();
        }
        if (LanguageLevel.RUBY20.isGreaterThan(level = namedArgument.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.named.arg")).create();
        } else if (LanguageLevel.RUBY21.isGreaterThan(level) && namedArgument.getValue() == null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.EXPRESSION_EXPECTED_MESSAGE).range(PsiTreeUtil.getDeepestLast((PsiElement)namedArgument)).create();
        }
    }

    public void visitRSymbols(@NotNull RWords rSymbols) {
        if (rSymbols == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(15);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY20.isGreaterThan(rSymbols.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.i")).create();
        }
    }

    public void visitRDSymbols(@NotNull RWords rdSymbols) {
        if (rdSymbols == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(16);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY20.isGreaterThan(rdSymbols.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.i_u")).create();
        }
    }

    public void visitRLambdaCall(@NotNull RLambdaCall rLambdaCall) {
        if (rLambdaCall == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(17);
        }
        ProgressManager.checkCanceled();
        if (rLambdaCall.getLanguageLevel() == LanguageLevel.RUBY18) {
            PsiElement paren = RubyPsiUtilCore.getChildByFilter((PsiElement)rLambdaCall, (IElementType)RubyTokenTypes.tLPAREN, (int)0);
            assert (paren != null);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.expected((String)RBundle.message((String)"parsing.operation"))).range(paren).create();
        }
        super.visitRLambdaCall(rLambdaCall);
    }

    public void visitBlockLocalVariable(@NotNull RBlockLocalVariables rBlockLocalVariables) {
        if (rBlockLocalVariables == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(18);
        }
        ProgressManager.checkCanceled();
        if (rBlockLocalVariables.getLanguageLevel() == LanguageLevel.RUBY18) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.block.local.vars")).create();
        }
        super.visitBlockLocalVariable(rBlockLocalVariables);
    }

    public void visitRAssocList(@NotNull RAssocList rAssocList) {
        RTopLevelContainer container;
        if (rAssocList == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(19);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY18.isLessThan(rAssocList.getLanguageLevel()) && ((container = (RTopLevelContainer)PsiTreeUtil.getParentOfType((PsiElement)rAssocList, RTopLevelContainer.class)) == null || container.checkHashes())) {
            for (RPsiElement element : rAssocList.getElements()) {
                IElementType type = element.getNode().getElementType();
                if (ASSOC_LIST_ALLOWED_TYPES.contains(type)) continue;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.expected((IElementType)RubyTokenTypes.tASSOC)).range((PsiElement)element).create();
            }
        }
        super.visitRAssocList(rAssocList);
    }

    public void visitRHashToArguments(@NotNull RHashToArguments hashToArguments) {
        if (hashToArguments == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(20);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY20.isGreaterThan(hashToArguments.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.hash.to.arguments")).create();
        } else if (hashToArguments.getHash() == null && RCallNavigator.getByRArgument((PsiElement)hashToArguments) != null) {
            RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)hashToArguments, RMethod.class);
            RCodeBlock codeBlock = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)hashToArguments, RCodeBlock.class, (boolean)true, (Class[])new Class[]{RMethod.class});
            if (LanguageLevel.RUBY32.isGreaterThan(hashToArguments.getLanguageLevel())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.forward.anonymous.keyword.rest.arg")).create();
            } else if (method == null || !ContainerUtil.exists((Iterable)method.getArguments(), arg -> arg instanceof RHashArgument && arg.getName().isEmpty())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.missing.anonymous.keyword.rest.parameter")).create();
            } else if (codeBlock != null) {
                RArgumentList argumentList;
                RLambda lambda = RLambdaNavigator.getByCodeBlock((RCodeBlock)codeBlock);
                Object object = argumentList = lambda != null ? lambda.getArgumentList() : codeBlock.getBlockArguments();
                if (argumentList != null && ContainerUtil.exists((Iterable)argumentList.getArguments(), it -> it.getArgumentInfo().isAnonymousKeywordRest())) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.anonymous.keyword.rest.parameter.within.block")).create();
                }
            }
        }
    }

    public void visitRListOfExpressions(@NotNull RListOfExpressions rListOfExpressions) {
        PsiElement parent;
        if (rListOfExpressions == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(21);
        }
        ProgressManager.checkCanceled();
        if (rListOfExpressions.getLanguageLevel() == LanguageLevel.RUBY18 && ((parent = rListOfExpressions.getParent()) instanceof RArray || parent instanceof RArrayIndexing)) {
            boolean splatSeen = false;
            boolean splatProblemReported = false;
            for (PsiElement element : rListOfExpressions.getChildren()) {
                if (!splatProblemReported && element instanceof RArrayToArguments) {
                    if (splatSeen) {
                        splatProblemReported = true;
                        this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.expected((IElementType)RubyTokenTypes.tRBRACK)).range(element).create();
                    }
                    splatSeen = true;
                    continue;
                }
                if (!(element instanceof RArgumentToBlock)) continue;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.expected((IElementType)RubyTokenTypes.tRBRACK)).range(element).create();
            }
        }
        super.visitRListOfExpressions(rListOfExpressions);
    }

    public void visitRArgumentDestructing(@NotNull RArgumentDestructing rArgumentDestructing) {
        if (rArgumentDestructing == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(22);
        }
        ProgressManager.checkCanceled();
        if (rArgumentDestructing.getLanguageLevel() == LanguageLevel.RUBY18) {
            PsiElement lParen = rArgumentDestructing.getFirstChild();
            assert (lParen.getNode().getElementType() == RubyTokenTypes.tLPAREN);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.unexpected((IElementType)RubyTokenTypes.tLPAREN)).range(lParen).create();
        }
        super.visitRArgumentDestructing(rArgumentDestructing);
    }

    public void visitRIntegerConstant(@NotNull RIntegerConstant rIntegerConstant) {
        if (rIntegerConstant == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(23);
        }
        this.visitRNumericConstant((RNumericConstant)rIntegerConstant);
    }

    public void visitRFloatConstant(@NotNull RFloatConstant rFloatConstant) {
        if (rFloatConstant == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(24);
        }
        this.visitRNumericConstant((RNumericConstant)rFloatConstant);
    }

    public void visitRArrayToArguments(@NotNull RArrayToArguments arrayToArguments) {
        if (arrayToArguments == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(25);
        }
        ProgressManager.checkCanceled();
        if (arrayToArguments.getArray() == null && RCallNavigator.getByRArgument((PsiElement)arrayToArguments) != null) {
            RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)arrayToArguments, RMethod.class);
            RCodeBlock codeBlock = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)arrayToArguments, RCodeBlock.class, (boolean)true, (Class[])new Class[]{RMethod.class});
            if (LanguageLevel.RUBY32.isGreaterThan(arrayToArguments.getLanguageLevel())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.forward.anonymous.rest.arg")).create();
            } else if (method == null || !ContainerUtil.exists((Iterable)method.getArguments(), arg -> arg instanceof RArrayArgument && arg.getName().isEmpty())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.missing.anonymous.rest.parameter")).create();
            } else if (codeBlock != null) {
                RArgumentList argumentList;
                RLambda lambda = RLambdaNavigator.getByCodeBlock((RCodeBlock)codeBlock);
                Object object = argumentList = lambda != null ? lambda.getArgumentList() : codeBlock.getBlockArguments();
                if (argumentList != null && ContainerUtil.exists((Iterable)argumentList.getArguments(), it -> it.getArgumentInfo().isAnonymousRest())) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.anonymous.rest.parameter.within.block")).create();
                }
            }
            return;
        }
        PsiElement parent = arrayToArguments.getParent();
        if (!(parent instanceof RArrayPattern)) {
            return;
        }
        List arguments = ((RArrayPattern)parent).getPatternElements();
        List allArrayToArguments = ContainerUtil.filterIsInstance((Collection)arguments, RArrayToArguments.class);
        RArrayToArguments firstArrayToArguments = (RArrayToArguments)allArrayToArguments.get(0);
        if (arrayToArguments.equals(firstArrayToArguments)) {
            return;
        }
        if (LanguageLevel.RUBY30.isGreaterThan(arrayToArguments.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.only.one.rest.arg.allowed")).create();
        } else if (arguments.size() == 2 || !firstArrayToArguments.equals(arguments.get(0)) || !arrayToArguments.equals(ContainerUtil.getLastItem((List)arguments))) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unexpected.rest.arg")).create();
        }
    }

    private void visitRNumericConstant(@NotNull RNumericConstant rNumericConstant) {
        PsiElement modifier;
        if (rNumericConstant == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(26);
        }
        ProgressManager.checkCanceled();
        if (LanguageLevel.RUBY21.isGreaterThan(rNumericConstant.getLanguageLevel()) && (modifier = rNumericConstant.getModifier()) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.numeric.modifiers")).range(modifier).create();
        }
    }

    public void visitRBlockCall(@NotNull RBlockCall blockCall) {
        if (blockCall == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(27);
        }
        ProgressIndicatorProvider.checkCanceled();
        List arguments = blockCall.getArguments();
        if (ContainerUtil.exists((Iterable)arguments, argument -> argument instanceof RArgumentToBlock || argument instanceof RForwardArguments)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.both.block.arg.and.block.given")).range(RubyAnnotatorUtil.getHighlightElementForCall(blockCall.getCall())).create();
        }
    }

    public void visitRBraceBlockCall(@NotNull RBraceBlockCall rBraceBlockCall) {
        PsiElement deepestLast;
        IElementType deepestLastType;
        RPossibleCall call;
        if (rBraceBlockCall == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(28);
        }
        if ((call = rBraceBlockCall.getCall()) instanceof RCall && !TokenBNF.tRBRACES.contains(deepestLastType = (deepestLast = PsiTreeUtil.getDeepestLast((PsiElement)call.getNode().getPsi())).getNode().getElementType())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.unexpected((IElementType)RubyTokenTypes.tLBRACE)).range(rBraceBlockCall.getBlock().getFirstChild()).create();
        }
        super.visitRBraceBlockCall(rBraceBlockCall);
    }

    public void visitRPatternVarRef(@NotNull RPatternVarRef rPatternVarRef) {
        if (rPatternVarRef == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(29);
        }
        RExpression variable = rPatternVarRef.getVariable();
        if (LanguageLevel.RUBY31.isGreaterThan(rPatternVarRef.getLanguageLevel())) {
            if (variable instanceof RInstanceVariable) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.pattern.matching.pin.instance.var")).create();
            } else if (variable instanceof RClassVariable) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.pattern.matching.pin.class.var")).create();
            } else if (variable instanceof RGlobalVariable) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.pattern.matching.pin.global.var")).create();
            }
        }
        super.visitRPatternVarRef(rPatternVarRef);
    }

    public void visitRPatternExprRef(@NotNull RPatternExprRef rPatternExprRef) {
        if (rPatternExprRef == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(30);
        }
        if (LanguageLevel.RUBY31.isGreaterThan(rPatternExprRef.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.pattern.matching.pin.expression")).create();
        } else {
            RGroupedExpression groupedExpression = rPatternExprRef.getGroupedExpression();
            RCompoundStatement pinnedExpression = (RCompoundStatement)ObjectUtils.tryCast((Object)groupedExpression.getExpression(), RCompoundStatement.class);
            LOG.assertTrue(pinnedExpression != null, (Object)"Pinned RGroupedExpression is expected to hold RCompoundStatement");
            if (pinnedExpression.getStatements().isEmpty()) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, ErrorMsg.EXPRESSION_EXPECTED_MESSAGE).range(groupedExpression.getLastChild()).create();
            }
        }
        super.visitRPatternExprRef(rPatternExprRef);
    }

    public void visitRDotReference(@NotNull RDotReference rDotReference) {
        if (rDotReference == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(31);
        }
        if (rDotReference.isSafeNavigation() && LanguageLevel.RUBY23.isGreaterThan(rDotReference.getLanguageLevel())) {
            ASTNode delimiter = rDotReference.getNode().findChildByType(Ruby19TokenTypes.tDOTQ);
            if (delimiter == null) {
                LOG.warn("Safe navigation without tDOTQ");
            } else {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.safe.navigation")).range(delimiter).create();
            }
        }
        super.visitRDotReference(rDotReference);
    }

    public void visitRHeredocId(@NotNull RHeredocId heredocId) {
        if (heredocId == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(32);
        }
        if ("<<~".equals(heredocId.getIdPrefix()) && LanguageLevel.RUBY23.isGreaterThan(heredocId.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.squiggly.heredoc")).create();
        }
        super.visitRHeredocId(heredocId);
    }

    public void visitRDoCodeBlock(@NotNull RDoCodeBlock rDoCodeBlock) {
        List violators;
        RBodyStatement bodyStatement;
        if (rDoCodeBlock == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(33);
        }
        if ((bodyStatement = rDoCodeBlock.getBodyStatement()) != null && !(violators = RubyPsiUtilCore.getChildrenByFilter((PsiElement)bodyStatement, (TokenSet)RubyCommonPsiUtil.RESCUE_CONTAINERS)).isEmpty() && LanguageLevel.RUBY25.isGreaterThan(bodyStatement.getLanguageLevel())) {
            for (PsiElement violator : violators) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.rescue.in.do.block")).range(violator).create();
            }
        }
        super.visitRDoCodeBlock(rDoCodeBlock);
    }

    public void visitRRangeExpression(@NotNull RRangeExpression rRangeExpression) {
        if (rRangeExpression == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(34);
        }
        if (rRangeExpression.getRightOperand() == null && LanguageLevel.RUBY26.isGreaterThan(rRangeExpression.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.endless.range")).create();
        }
        if (rRangeExpression.getLeftOperand() == null && LanguageLevel.RUBY27.isGreaterThan(rRangeExpression.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.beginless.range")).create();
        }
        if (ObjectUtils.doIfNotNull((Object)rRangeExpression.getParent(), RGroupedExpressionNavigator::getByExpression) == null) {
            PsiElement leaf = PsiTreeUtil.nextLeaf((PsiElement)rRangeExpression.getOperation());
            while (leaf instanceof PsiWhiteSpace || leaf instanceof PsiComment) {
                if (leaf instanceof PsiWhiteSpace && leaf.getText().contains("\n")) {
                    this.myHolder.newAnnotation(HighlightSeverity.WARNING, RBundle.message((String)"annotation.error.ambiguous.range")).range(rRangeExpression.getOperation()).create();
                    break;
                }
                leaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
            }
        }
        super.visitRRangeExpression(rRangeExpression);
    }

    public void visitRArgumentToBlock(@NotNull RArgumentToBlock argumentToBlock) {
        PsiElement parent;
        if (argumentToBlock == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(35);
        }
        if ((parent = argumentToBlock.getParent()) instanceof RListOfExpressions && parent.getParent() instanceof RYieldStatement) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.block.given.to.yield")).create();
        }
        if (argumentToBlock.getArgument() == null) {
            RMethod method = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)argumentToBlock, RMethod.class);
            RCodeBlock codeBlock = (RCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)argumentToBlock, RCodeBlock.class, (boolean)true, (Class[])new Class[]{RMethod.class});
            if (LanguageLevel.RUBY31.isGreaterThan(argumentToBlock.getLanguageLevel())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unexpected.anonymous.block")).create();
            } else if (method == null || !ContainerUtil.exists((Iterable)method.getArguments(), it -> it instanceof RBlockArgument && it.getName().isEmpty())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.missing.anonymous.block.parameter")).create();
            } else if (codeBlock != null) {
                RArgumentList argumentList;
                RLambda lambda = RLambdaNavigator.getByCodeBlock((RCodeBlock)codeBlock);
                Object object = argumentList = lambda != null ? lambda.getArgumentList() : codeBlock.getBlockArguments();
                if (argumentList != null && ContainerUtil.exists((Iterable)argumentList.getArguments(), it -> it.getArgumentInfo().isAnonymousBlock())) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.anonymous.block.parameter.within.block")).create();
                }
            }
        }
    }

    public void visitRArgumentList(@NotNull RArgumentList list) {
        if (list == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(36);
        }
        if (!(list.getParent() instanceof RCodeBlock)) {
            this.checkArguments(list.getArguments(), Collections.emptyList());
        }
        super.visitRArgumentList(list);
    }

    public void visitRCodeBlock(@NotNull RCodeBlock codeBlock) {
        if (codeBlock == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(37);
        }
        RBlockArgumentList blockVariables = codeBlock.getBlockArguments();
        RBlockLocalVariables localVariables = codeBlock.getBlockLocalVariables();
        this.checkArguments(blockVariables != null ? blockVariables.getArguments() : Collections.emptyList(), localVariables != null ? localVariables.getVariables() : Collections.emptyList());
        super.visitRCodeBlock(codeBlock);
    }

    public void visitRBodyStatement(@NotNull RBodyStatement rBodyStatement) {
        if (rBodyStatement == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(38);
        }
        ProgressManager.checkCanceled();
        RElseBlock elseBlock = rBodyStatement.getElseBlock();
        if (elseBlock != null && rBodyStatement.getRescueBlocks().isEmpty()) {
            HighlightSeverity severity = LanguageLevel.RUBY26.isGreaterThan(rBodyStatement.getLanguageLevel()) ? HighlightSeverity.WARNING : HighlightSeverity.ERROR;
            this.myHolder.newAnnotation(severity, RBundle.message((String)"annotation.error.else.without.rescue.is.useless")).range((PsiElement)elseBlock).create();
        }
        super.visitRBodyStatement(rBodyStatement);
    }

    public void visitRCaseStatement(@NotNull RCaseStatement rCaseStatement) {
        boolean isPatternMatchingWhen;
        RWhenCase firstCase;
        if (rCaseStatement == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(39);
        }
        if ((firstCase = (RWhenCase)ContainerUtil.getFirstItem((List)rCaseStatement.getCases())) != null && (isPatternMatchingWhen = firstCase.isPatternMatching()) && LanguageLevel.RUBY27.isGreaterThan(rCaseStatement.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.pattern.matching")).create();
        }
        super.visitRCaseStatement(rCaseStatement);
    }

    public void visitRHashPattern(@NotNull RHashPattern rHashPattern) {
        if (rHashPattern == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(40);
        }
        if (RubyAnnotatorVisitor.hasOmittedParenthesesInMatchBeforeRuby31((RArrayPatternBase)rHashPattern, RubyTokenTypes.tLBRACE)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.pattern.matching.missing.braces")).create();
        } else {
            rHashPattern.getPatternElements().stream().filter(element -> element instanceof RAssoc).map(element -> ((RAssoc)element).getKey()).filter(element -> element instanceof RAssocKey).map(PsiElement::getFirstChild).filter(element -> element instanceof RStringLiteral && !((RStringLiteral)element).getExpressionSubstitutions().isEmpty()).forEach(element -> this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.pattern.matching.symbol.literal.with.interpolation.is.not.allowed")).range(element).create());
        }
    }

    public void visitRArrayPattern(@NotNull RArrayPattern rArrayPattern) {
        if (rArrayPattern == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(41);
        }
        if (RubyAnnotatorVisitor.hasOmittedParenthesesInMatchBeforeRuby31((RArrayPatternBase)rArrayPattern, RubyTokenTypes.tLBRACK)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.pattern.matching.missing.brackets")).create();
        }
    }

    public void visitRInMatch(@NotNull RInMatch inMatch) {
        RGroupedExpression groupedExpression;
        RPsiElement expression;
        LanguageLevel languageLevel;
        if (inMatch == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(42);
        }
        if (LanguageLevel.RUBY27.isGreaterThan(languageLevel = inMatch.getLanguageLevel())) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.pattern.matching")).create();
        } else if (LanguageLevel.RUBY30.isGreaterThan(languageLevel)) {
            if (PsiUtilCore.getElementType((PsiElement)inMatch.getOperator()) == RubyTokenTypes.tASSOC) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.unsupported.in.match.rocket.operator")).create();
            }
        } else if (!(PsiUtilCore.getElementType((PsiElement)inMatch.getOperator()) != RubyTokenTypes.tASSOC || RCompoundStatementNavigator.isStatement((PsiElement)(expression = (RPsiElement)ObjectUtils.coalesce((Object)(groupedExpression = (RGroupedExpression)ObjectUtils.doIfNotNull((Object)RCompoundStatementNavigator.getByPsiElement((PsiElement)inMatch), RGroupedExpressionNavigator::getByExpression)), (Object)inMatch))) || expression.getParent() instanceof RModifierStatement || expression.getParent() instanceof RRescueModStatement)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.void.value.expression")).create();
        }
    }

    @NotNull
    private ProblemDescriptor createProblemDescriptor(@NotNull PsiElement element, @NotNull LocalQuickFix fix) {
        if (element == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(43);
        }
        if (fix == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(44);
        }
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)element.getProject()).createProblemDescriptor(element, fix.getName(), fix, ProblemHighlightType.ERROR, true);
        if (problemDescriptor == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(45);
        }
        return problemDescriptor;
    }

    public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
        LanguageLevel languageLevel;
        if (arrayIndexing == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(46);
        }
        if (LanguageLevel.RUBY34.isGreaterThan(languageLevel = arrayIndexing.getLanguageLevel()) || RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)arrayIndexing) == null && RSelfAssignmentExpressionNavigator.getSelfAssignmentByLeftPart((PsiElement)arrayIndexing) == null) {
            return;
        }
        for (RPsiElement element : arrayIndexing.getIndexes()) {
            ProblemDescriptor descriptor;
            RemoveElementQuickFix fix;
            if (element instanceof RAssoc || element instanceof RHashToArguments) {
                fix = new RemoveElementQuickFix(RBundle.message((String)"keyword.argument"));
                descriptor = this.createProblemDescriptor((PsiElement)element, fix);
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.index.assignment.keyword")).range((PsiElement)element).newLocalQuickFix((LocalQuickFix)fix, descriptor).registerFix().create();
                continue;
            }
            if (!(element instanceof RArgumentToBlock)) continue;
            fix = new RemoveElementQuickFix(RBundle.message((String)"block.argument"));
            descriptor = this.createProblemDescriptor((PsiElement)element, fix);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.index.assignment.block")).range((PsiElement)element).newLocalQuickFix((LocalQuickFix)fix, descriptor).registerFix().create();
        }
    }

    private void checkArguments(List<RArgument> arguments, List<RIdentifier> variables) {
        HashSet<String> knownArgs = new HashSet<String>(arguments.size());
        for (RArgument arg : arguments) {
            String argumentName = arg.getName();
            if (argumentName.isEmpty() || "_".equals(argumentName) || knownArgs.add(argumentName)) continue;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.duplicated.arg.name")).range((PsiElement)arg).create();
        }
        for (RIdentifier var : variables) {
            if (knownArgs.add(var.getName())) continue;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RBundle.message((String)"annotation.error.duplicated.arg.name")).range((PsiElement)var).create();
        }
    }

    private static boolean hasOmittedParenthesesInMatchBeforeRuby31(@NotNull RArrayPatternBase pattern, @NotNull IElementType parentheses) {
        if (pattern == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(47);
        }
        if (parentheses == null) {
            RubyAnnotatorVisitor.$$$reportNull$$$0(48);
        }
        return RInMatchNavigator.getByPattern((RArrayPatternBase)pattern) != null && parentheses != PsiUtilCore.getElementType((PsiElement)pattern.getFirstChild()) && LanguageLevel.RUBY31.isGreaterThan(pattern.getLanguageLevel());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardArguments";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rConstant";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rModule";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rParameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAssoc";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedArgument";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rSymbols";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rdSymbols";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rLambdaCall";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBlockLocalVariables";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rAssocList";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashToArguments";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rListOfExpressions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArgumentDestructing";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIntegerConstant";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFloatConstant";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayToArguments";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rNumericConstant";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBraceBlockCall";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPatternVarRef";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rPatternExprRef";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDotReference";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heredocId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDoCodeBlock";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rRangeExpression";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentToBlock";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBodyStatement";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCaseStatement";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rHashPattern";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArrayPattern";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inMatch";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/annotator/RubyAnnotatorVisitor";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayIndexing";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentheses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/annotator/RubyAnnotatorVisitor";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitRAliasStatement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssignmentExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isClassName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitRForwardArguments";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitRIdentifier";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitRConstant";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitRCall";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitRClass";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitRMethod";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitRSingletonMethod";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitRModule";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitRArgument";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssoc";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitRNamedArgument";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitRSymbols";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visitRDSymbols";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visitRLambdaCall";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitBlockLocalVariable";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "visitRAssocList";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitRHashToArguments";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitRListOfExpressions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitRArgumentDestructing";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitRIntegerConstant";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visitRFloatConstant";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "visitRArrayToArguments";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "visitRNumericConstant";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "visitRBlockCall";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "visitRBraceBlockCall";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "visitRPatternVarRef";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "visitRPatternExprRef";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitRDotReference";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitRHeredocId";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitRDoCodeBlock";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "visitRRangeExpression";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "visitRArgumentToBlock";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "visitRArgumentList";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitRCodeBlock";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitRBodyStatement";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "visitRCaseStatement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitRHashPattern";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitRArrayPattern";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitRInMatch";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptor";
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitRArrayIndexing";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "hasOmittedParenthesesInMatchBeforeRuby31";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 45 -> new IllegalStateException(string);
        };
    }
}

