/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.interpret;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDefReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RCallArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyRecursiveElementVisitor;

public class RubyPsiInterpreter {
    private static final Logger LOG = Logger.getInstance(RubyPsiInterpreter.class);
    private final Map<RIdentifier, PsiCallable> myScope;
    private final Map<String, PsiCallable> myCallables;
    private final Collection<PsiElement> myCallStack;
    private final boolean myLightMode;

    public RubyPsiInterpreter() {
        this(false);
    }

    public RubyPsiInterpreter(boolean lightMode) {
        this(new HashSet<PsiElement>(), lightMode);
    }

    RubyPsiInterpreter(@NotNull Collection<PsiElement> callStack, boolean lightMode) {
        if (callStack == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(0);
        }
        this.myScope = new HashMap<RIdentifier, PsiCallable>();
        this.myCallables = new HashMap<String, PsiCallable>();
        this.myCallStack = callStack;
        this.myLightMode = lightMode;
    }

    public boolean isInLightMode() {
        return this.myLightMode;
    }

    public void interpret(@NotNull PsiElement element, final PsiCallable self) {
        if (element == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(1);
        }
        if (this.myCallStack.contains(element)) {
            return;
        }
        this.myCallStack.add(element);
        element.accept((PsiElementVisitor)new RubyRecursiveElementVisitor(){

            public void visitRBlockCall(@NotNull RBlockCall blockCall) {
                if (blockCall == null) {
                    1.$$$reportNull$$$0(0);
                }
                RubyPsiInterpreter.this.visitRBlockCall(blockCall, self);
            }

            public void visitRCall(@NotNull RCall rCall) {
                if (rCall == null) {
                    1.$$$reportNull$$$0(1);
                }
                RubyPsiInterpreter.this.visitRCall(rCall, self);
            }

            public void visitRDotReference(@NotNull RDotReference rDotReference) {
                if (rDotReference == null) {
                    1.$$$reportNull$$$0(2);
                }
                RubyPsiInterpreter.this.visitRDotReference(rDotReference, self);
            }

            public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
                if (rIdentifier == null) {
                    1.$$$reportNull$$$0(3);
                }
                RubyPsiInterpreter.this.visitRIdentifier(rIdentifier, self);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "blockCall";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rCall";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rDotReference";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rIdentifier";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRBlockCall";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRCall";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRDotReference";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIdentifier";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void interpretCallsTreePath(PsiElement element, final @Nullable PsiCallable self) {
        if (this.myCallStack.contains(element)) {
            return;
        }
        this.myCallStack.add(element);
        element.accept((PsiElementVisitor)new RubyElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                PsiElement parent;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((parent = element.getParent()) != null) {
                    parent.accept((PsiElementVisitor)this);
                }
            }

            public void visitRCall(@NotNull RCall rCall) {
                if (rCall == null) {
                    2.$$$reportNull$$$0(1);
                }
                RubyPsiInterpreter.this.visitRCall(rCall, self);
                this.processParent((PsiElement)rCall);
            }

            public void visitRBlockCall(@NotNull RBlockCall blockCall) {
                if (blockCall == null) {
                    2.$$$reportNull$$$0(2);
                }
                RubyPsiInterpreter.this.visitRBlockCall(blockCall, self);
                this.processParent((PsiElement)blockCall);
            }

            public void visitRDotReference(@NotNull RDotReference rDotReference) {
                if (rDotReference == null) {
                    2.$$$reportNull$$$0(3);
                }
                RubyPsiInterpreter.this.visitRDotReference(rDotReference, self);
                this.processParent((PsiElement)rDotReference);
            }

            public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
                if (rIdentifier == null) {
                    2.$$$reportNull$$$0(4);
                }
                RubyPsiInterpreter.this.visitRIdentifier(rIdentifier, self);
                this.processParent((PsiElement)rIdentifier);
            }

            private void processParent(PsiElement psiElement) {
                PsiElement parent;
                if (psiElement != null && (parent = psiElement.getParent()) != null) {
                    this.visitElement(parent);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rCall";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "blockCall";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rDotReference";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rIdentifier";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRCall";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRBlockCall";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRDotReference";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitRIdentifier";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void interpretBlock(RCodeBlock block, PsiCallable self, PsiCallable ... args) {
        RBlockArgumentList blockParameters = block.getBlockArguments();
        if (blockParameters != null) {
            List vars = blockParameters.getArguments();
            for (int i = 0; i < vars.size() && i < args.length; ++i) {
                this.myScope.put(((RArgument)vars.get(i)).getIdentifier(), args[i]);
            }
        }
        this.interpret((PsiElement)block, self);
    }

    public void registerCallable(PsiCallable psiCallable, String ... names) {
        for (String name : names) {
            this.myCallables.put(name, psiCallable);
        }
    }

    public void visitRCall(RCall rCall, PsiCallable self) {
        this.processCall(rCall.getPsiCommand(), rCall, null, self);
    }

    public void visitRBlockCall(RBlockCall blockCall, PsiCallable self) {
        RPossibleCall callElement = blockCall.getCall();
        if (callElement instanceof RCall) {
            this.processCall(((RCall)callElement).getPsiCommand(), (RCall)callElement, blockCall.getBlock(), self);
        } else {
            this.processCall((PsiElement)callElement, null, blockCall.getBlock(), self);
        }
    }

    public void visitRDotReference(RDotReference rDotReference, PsiCallable self) {
        this.processCall((PsiElement)rDotReference, null, null, self);
    }

    public void visitRIdentifier(RIdentifier rIdentifier, PsiCallable self) {
        this.processCall((PsiElement)rIdentifier, null, null, self);
    }

    private void processCall(PsiElement psiCommand, @Nullable RCall rCall, @Nullable RCodeBlock block, PsiCallable self) {
        ProgressManager.checkCanceled();
        RefObject ref = RubyPsiInterpreter.createRefObject(psiCommand);
        if (!ref.isValid()) {
            return;
        }
        PsiCallable callable = this.findCallable(ref);
        if (callable == null) {
            callable = self;
        }
        if (callable != null) {
            callable.processCall(new RCallArguments(this, self, psiCommand, ref.getCommand(), rCall == null ? Collections.emptyList() : rCall.getArguments(), block));
        }
    }

    @Nullable
    private PsiCallable findCallable(@NotNull RefObject ref) {
        PsiElement refObject;
        if (ref == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(2);
        }
        if ((refObject = ref.getRefObject()) instanceof RIdentifier) {
            RIdentifier rIdentifier = (RIdentifier)refObject;
            if (!this.isInLightMode()) {
                if (RBlockCallNavigator.getByCall((RPsiElement)rIdentifier) != null) {
                    return null;
                }
                ScopeVariable scopeVar = rIdentifier.getScopeVariable();
                if (scopeVar != null) {
                    for (PsiElement e : scopeVar.getDeclarations()) {
                        PsiCallable callable = this.myScope.get(e);
                        if (callable == null) continue;
                        return callable;
                    }
                    return null;
                }
            } else {
                String name = rIdentifier.getName();
                if (name != null) {
                    for (Map.Entry<RIdentifier, PsiCallable> entry : this.myScope.entrySet()) {
                        if (!StringUtil.equals((CharSequence)name, (CharSequence)entry.getKey().getName())) continue;
                        return entry.getValue();
                    }
                }
            }
        }
        if (!this.myCallables.isEmpty()) {
            PsiCallable callableForSymbolRef;
            RPsiPolyVariantReference reference = ref.getReference();
            if (reference == null) {
                return null;
            }
            if (!this.isInLightMode() && (callableForSymbolRef = this.getCallableForSymbolRef(reference)) != null) {
                return callableForSymbolRef;
            }
            return this.myCallables.get(RNameUtilCore.getPath((PsiElement)reference.getElement()).getFullPath());
        }
        return null;
    }

    @Nullable
    private PsiCallable getCallableForSymbolRef(RPsiPolyVariantReference qualifiedReference) {
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching((PsiReference)qualifiedReference);
        if (symbol != null) {
            FQN fqn = symbol.getFQNWithNesting();
            PsiCallable callable = this.myCallables.get(fqn.getFullPath());
            if (callable == null && symbol.getType() == Type.ALIAS) {
                Symbol alias = SymbolUtil.getMethodSymbolByAlias(symbol);
                fqn = alias != null ? alias.getFQNWithNesting() : FQN.INVALID;
                callable = this.myCallables.get(fqn.getFullPath());
            }
            return callable;
        }
        return null;
    }

    public RubyPsiInterpreter child() {
        return new RubyPsiInterpreter(this.myCallStack, this.myLightMode);
    }

    public static boolean isInResolvableCallScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallFQNs, @Nullable Set<String> forbiddenCallFQNs) {
        if (psiElement == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(3);
        }
        if (acceptableCallFQNs == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(4);
        }
        return RubyPsiInterpreter.getResolvableCallScope(psiElement, acceptableCallFQNs, forbiddenCallFQNs) != null;
    }

    public static boolean isInCallScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallNames, @Nullable Set<String> forbiddenCallNames) {
        if (psiElement == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(5);
        }
        if (acceptableCallNames == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(6);
        }
        return RubyPsiInterpreter.getCallScope(psiElement, acceptableCallNames, forbiddenCallNames) != null;
    }

    @Nullable
    public static RPossibleCall getResolvableCallScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallFQNs, @Nullable Set<String> forbiddenCallFQNs) {
        RPsiElement rPsiElement;
        if (psiElement == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(7);
        }
        if (acceptableCallFQNs == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(8);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)psiElement)) == null) {
            return null;
        }
        return RubyPsiInterpreter.getCallScope((PsiElement)rPsiElement, true, acceptableCallFQNs, forbiddenCallFQNs);
    }

    @Nullable
    public static RPossibleCall getCallScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallNames, @Nullable Set<String> forbiddenCallNames) {
        RPsiElement rPsiElement;
        if (psiElement == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(9);
        }
        if (acceptableCallNames == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(10);
        }
        if ((rPsiElement = RubyPsiUtilCore.getCoveringRPsiElement((PsiElement)psiElement)) == null) {
            return null;
        }
        return RubyPsiInterpreter.getCallScope((PsiElement)rPsiElement, false, acceptableCallNames, forbiddenCallNames);
    }

    @Nullable
    private static RPossibleCall getCallScope(@NotNull PsiElement psiElement, boolean doRealResolve, @NotNull Set<String> acceptableCallNamesOrFQNs, @Nullable Set<String> forbiddenCallNamesOrFQNs) {
        RBlockCall parentBlock;
        RPossibleCall possibleCall;
        if (psiElement == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(11);
        }
        if (acceptableCallNamesOrFQNs == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(12);
        }
        RPossibleCall rPossibleCall = possibleCall = psiElement instanceof RPossibleCall ? (RPossibleCall)psiElement : (RPossibleCall)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPossibleCall.class);
        if (possibleCall == null) {
            return null;
        }
        String commandName = possibleCall.getCommand();
        if (commandName != null && possibleCall.isCall()) {
            if (doRealResolve) {
                PsiElement psiCommand = possibleCall.getPsiCommand();
                if (psiCommand != null) {
                    PsiReference reference = RubyPsiInterpreter.getReferenceFromPsiElement(psiCommand);
                    if (reference == null) {
                        return null;
                    }
                    if (reference instanceof RPsiPolyVariantReference) {
                        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(reference);
                        if (symbol != null) {
                            String fqn = symbol.getFQNWithNesting().getFullPath().replace("::$$SINGLETON$$", "");
                            if (acceptableCallNamesOrFQNs.contains(fqn)) {
                                return possibleCall;
                            }
                            if (forbiddenCallNamesOrFQNs != null && forbiddenCallNamesOrFQNs.contains(fqn)) {
                                return null;
                            }
                        }
                        LOG.info("unresolved reference in isResolvableCallScope(): " + psiCommand.getText());
                    }
                }
            } else {
                if (acceptableCallNamesOrFQNs.contains(commandName)) {
                    return possibleCall;
                }
                if (forbiddenCallNamesOrFQNs != null && forbiddenCallNamesOrFQNs.contains(commandName)) {
                    return null;
                }
            }
        }
        return (parentBlock = (RBlockCall)PsiTreeUtil.getParentOfType((PsiElement)possibleCall, RBlockCall.class)) != null ? RubyPsiInterpreter.getCallScope((PsiElement)parentBlock, doRealResolve, acceptableCallNamesOrFQNs, forbiddenCallNamesOrFQNs) : null;
    }

    @Nullable
    public static RBlockCall getSimpleCoveringCodeBlockScope(@NotNull PsiElement psiElement, @NotNull Set<String> acceptableCallNames, @Nullable Set<String> forbiddenCallNames) {
        RCodeBlock codeBlock;
        RBlockCall blockCall;
        if (psiElement == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(13);
        }
        if (acceptableCallNames == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(14);
        }
        RBlockCall rBlockCall = blockCall = (codeBlock = (RCodeBlock)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)psiElement, RCodeBlock.class)) != null ? codeBlock.getBlockCall() : null;
        if (blockCall == null) {
            return null;
        }
        String commandName = blockCall.getCommand();
        if (commandName != null) {
            if (acceptableCallNames.contains(commandName)) {
                return blockCall;
            }
            if (forbiddenCallNames != null && forbiddenCallNames.contains(commandName)) {
                return null;
            }
        }
        return RubyPsiInterpreter.getSimpleCoveringCodeBlockScope((PsiElement)blockCall, acceptableCallNames, forbiddenCallNames);
    }

    @NotNull
    private static RefObject createRefObject(@NotNull PsiElement psiCommand) {
        if (psiCommand == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(15);
        }
        if (psiCommand instanceof RIdentifier) {
            return new RIdentRef((RIdentifier)psiCommand);
        }
        return new QualifiedRefObject(psiCommand);
    }

    @Nullable
    private static PsiReference getReferenceFromPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            RubyPsiInterpreter.$$$reportNull$$$0(16);
        }
        return ParamDefReference.unwrapReference(element.getReference());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStack";
                break;
            }
            case 1: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableCallFQNs";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableCallNames";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableCallNamesOrFQNs";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiCommand";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "interpret";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findCallable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isInResolvableCallScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInCallScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getResolvableCallScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getCallScope";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getSimpleCoveringCodeBlockScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "createRefObject";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferenceFromPsiElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface RefObject {
        public boolean isValid();

        @Nullable
        public PsiElement getRefObject();

        @Nullable
        public RPsiPolyVariantReference getReference();

        @NotNull
        public String getCommand();
    }

    private static final class RIdentRef
    implements RefObject {
        private final RIdentifier myIdent;

        RIdentRef(@NotNull RIdentifier ident) {
            if (ident == null) {
                RIdentRef.$$$reportNull$$$0(0);
            }
            this.myIdent = ident;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NotNull
        public PsiElement getRefObject() {
            RIdentifier rIdentifier = this.myIdent;
            if (rIdentifier == null) {
                RIdentRef.$$$reportNull$$$0(1);
            }
            return rIdentifier;
        }

        @Override
        @Nullable
        public RPsiPolyVariantReference getReference() {
            PsiReference reference = this.myIdent.getReference();
            return reference instanceof RPsiPolyVariantReference ? (RPsiPolyVariantReference)reference : null;
        }

        @Override
        @NotNull
        public String getCommand() {
            String string = this.myIdent.getText();
            if (string == null) {
                RIdentRef.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ident";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$RIdentRef";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$RIdentRef";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRefObject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class QualifiedRefObject
    implements RefObject {
        private final PsiElement myRefObject;
        private final RQualifiedReference myReference;

        QualifiedRefObject(@NotNull PsiElement psiCommand) {
            if (psiCommand == null) {
                QualifiedRefObject.$$$reportNull$$$0(0);
            }
            PsiReference ref = RubyPsiInterpreter.getReferenceFromPsiElement(psiCommand);
            if (ref instanceof RQualifiedReference) {
                this.myReference = (RQualifiedReference)ref;
                this.myRefObject = ((RQualifiedReference)ref).getRefObject();
            } else {
                this.myRefObject = null;
                this.myReference = null;
            }
        }

        @Override
        public boolean isValid() {
            return this.myReference != null;
        }

        @Override
        @Nullable
        public PsiElement getRefObject() {
            return this.myRefObject;
        }

        @Override
        @Nullable
        public RQualifiedReference getReference() {
            return this.myReference;
        }

        @Override
        @NotNull
        public String getCommand() {
            if (!this.isValid()) {
                throw new IllegalStateException("Should not invoke getCommand on invalid ref");
            }
            String string = this.myReference.getRefValue().getText();
            if (string == null) {
                QualifiedRefObject.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiCommand";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$QualifiedRefObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyPsiInterpreter$QualifiedRefObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

