/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.interpret;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.ConstantStringInferenceResultImpl;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValue;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueArray;
import org.jetbrains.plugins.ruby.ruby.codeInsight.values.StringValueHash;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;

public final class RubyInterpretUtil {
    private RubyInterpretUtil() {
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static String evaluateOptionValue(@NotNull RPossibleCall possibleCall, @Nullable String key) {
        if (possibleCall == null) {
            RubyInterpretUtil.$$$reportNull$$$0(0);
        }
        RPsiElement element = RubyInterpretUtil.getOptionValueElement(possibleCall.getArguments(), key);
        return ConstantStringInferenceResultImpl.getStringRepresentation((PsiElement)element).getOnlyString();
    }

    @Contract(value="_, _, !null -> !null; _, null, null -> null")
    @Nullable
    public static String evaluateOptionValue(@NotNull RPossibleCall possibleCall, @Nullable String key, @Nullable String defaultValue) {
        if (possibleCall == null) {
            RubyInterpretUtil.$$$reportNull$$$0(1);
        }
        return (String)ObjectUtils.coalesce((Object)RubyInterpretUtil.evaluateOptionValue(possibleCall, key), (Object)defaultValue);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static List<String> evaluateOptionValues(@NotNull RPossibleCall call, @Nullable String key) {
        if (call == null) {
            RubyInterpretUtil.$$$reportNull$$$0(2);
        }
        return RubyInterpretUtil.evaluateOptionValues(call.getArguments(), key);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static List<String> evaluateOptionValues(@NotNull List<? extends PsiElement> arguments, @Nullable String key) {
        RPsiElement element;
        if (arguments == null) {
            RubyInterpretUtil.$$$reportNull$$$0(3);
        }
        if ((element = RubyInterpretUtil.getOptionValueElement(arguments, key)) == null) {
            return null;
        }
        StringValue value = ConstantStringInferenceResultImpl.getStringRepresentation((PsiElement)element);
        if (value instanceof StringValueArray) {
            return ContainerUtil.mapNotNull((Collection)((StringValueArray)value).getStringValueList(), StringValue::getOnlyString);
        }
        return ContainerUtil.createMaybeSingletonList((Object)value.getOnlyString());
    }

    @Nullable
    public static Map<String, StringValue> evaluateHashElement(@NotNull PsiElement element) {
        StringValueHash hash;
        if (element == null) {
            RubyInterpretUtil.$$$reportNull$$$0(4);
        }
        if ((hash = (StringValueHash)ObjectUtils.tryCast((Object)ConstantStringInferenceResultImpl.getStringRepresentation(element), StringValueHash.class)) == null) {
            return null;
        }
        HashMap<String, StringValue> result = new HashMap<String, StringValue>();
        for (Map.Entry entry : hash.getStringValueMap().entrySet()) {
            String key = ((StringValue)entry.getKey()).getOnlyString();
            if (key == null) continue;
            result.put(key, (StringValue)entry.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    @Contract(value="null -> null")
    @Nullable
    public static String evaluateStringOrSymbolElement(@Nullable PsiElement element) {
        if (!(element instanceof RStringLiteral) && !(element instanceof RSymbol)) {
            return null;
        }
        return ConstantStringInferenceResultImpl.getStringRepresentation(element).getOnlyString();
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static RAssoc getOptionAssocElement(@NotNull RPossibleCall possibleCall, @Nullable String key) {
        if (possibleCall == null) {
            RubyInterpretUtil.$$$reportNull$$$0(5);
        }
        return RubyInterpretUtil.getOptionAssocElement(possibleCall.getArguments(), key);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static RAssoc getOptionAssocElement(@NotNull List<? extends PsiElement> arguments, @Nullable String key) {
        if (arguments == null) {
            RubyInterpretUtil.$$$reportNull$$$0(6);
        }
        return arguments.stream().map(argument -> (RAssoc)ObjectUtils.tryCast((Object)argument, RAssoc.class)).filter(Objects::nonNull).filter(assoc -> assoc.getKeyText().equals(key)).findFirst().orElse(null);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static RPsiElement getOptionValueElement(@NotNull List<? extends PsiElement> arguments, @Nullable String key) {
        if (arguments == null) {
            RubyInterpretUtil.$$$reportNull$$$0(7);
        }
        return (RPsiElement)ObjectUtils.doIfNotNull((Object)RubyInterpretUtil.getOptionAssocElement(arguments, key), RAssoc::getValue);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static List<? extends RPsiElement> getOptionValueElements(@NotNull RPossibleCall possibleCall, @Nullable String key) {
        RPsiElement value;
        if (possibleCall == null) {
            RubyInterpretUtil.$$$reportNull$$$0(8);
        }
        if ((value = RubyInterpretUtil.getOptionValueElement(possibleCall.getArguments(), key)) instanceof RArray) {
            return ((RArray)value).getElements();
        }
        return (List)ObjectUtils.doIfNotNull((Object)value, Collections::singletonList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RubyInterpretUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateOptionValue";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateOptionValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateHashElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionAssocElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionValueElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionValueElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

