/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.interpret;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.interpret.PsiCallable;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyInterpretUtil;
import org.jetbrains.plugins.ruby.ruby.interpret.RubyPsiInterpreter;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;

public class RCallArguments {
    private final RubyPsiInterpreter myOwner;
    private final PsiCallable mySelf;
    private final PsiElement myCallElement;
    private final String myCommand;
    private final List<RPsiElement> myArguments;
    private final RCodeBlock myBlock;

    public RCallArguments(@NotNull RubyPsiInterpreter owner, @Nullable PsiCallable self, @NotNull PsiElement callElement, @NotNull String command, @NotNull List<RPsiElement> arguments, @Nullable RCodeBlock block) {
        if (owner == null) {
            RCallArguments.$$$reportNull$$$0(0);
        }
        if (callElement == null) {
            RCallArguments.$$$reportNull$$$0(1);
        }
        if (command == null) {
            RCallArguments.$$$reportNull$$$0(2);
        }
        if (arguments == null) {
            RCallArguments.$$$reportNull$$$0(3);
        }
        this.myOwner = owner;
        this.mySelf = self;
        this.myCommand = command;
        this.myCallElement = callElement;
        this.myArguments = arguments;
        this.myBlock = block;
    }

    @NotNull
    public PsiElement getCallElement() {
        PsiElement psiElement = this.myCallElement;
        if (psiElement == null) {
            RCallArguments.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement getRCallElement() {
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)this.myCallElement, RCall.class);
        if (call != null) {
            RCall rCall = call;
            if (rCall == null) {
                RCallArguments.$$$reportNull$$$0(5);
            }
            return rCall;
        }
        PsiElement psiElement = this.myCallElement;
        if (psiElement == null) {
            RCallArguments.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    public PsiElement getRBlockCallElement() {
        PsiElement psiElement = Optional.ofNullable(this.myBlock).map(RCodeBlock::getBlockCall).orElse(this.getRCallElement());
        if (psiElement == null) {
            RCallArguments.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    @NonNls
    @NotNull
    public String getCommand() {
        String string = this.myCommand;
        if (string == null) {
            RCallArguments.$$$reportNull$$$0(8);
        }
        return string;
    }

    public List<RPsiElement> getArguments() {
        return this.myArguments;
    }

    @Nullable
    public String evaluateArgument(int index) {
        if (index >= this.myArguments.size()) {
            return null;
        }
        return RubyPsiUtilCore.getElementText((PsiElement)((PsiElement)this.myArguments.get(index)));
    }

    public void interpretBlock(PsiCallable ... args) {
        if (this.hasBlock()) {
            this.childInterpreter().interpretBlock(this.myBlock, this.mySelf, args);
        }
    }

    public boolean hasBlock() {
        return this.myBlock != null;
    }

    public void interpretBlockWithGivenSelf(PsiCallable self, PsiCallable ... args) {
        if (this.hasBlock()) {
            this.childInterpreter().interpretBlock(this.myBlock, self, args);
        }
    }

    @Nullable
    public String getOptionValue(String key) {
        return this.getOptionValue(key, null);
    }

    @Nullable
    public String getOptionValue(@NonNls String key, String defaultValue) {
        RPsiElement value = this.getOptionValueElement(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof RPseudoConstant && value.getText().equals("nil")) {
            return null;
        }
        return RubyPsiUtilCore.getElementText((PsiElement)value);
    }

    @Nullable
    public List<String> getOptionValues(@NonNls String key) {
        return RubyInterpretUtil.evaluateOptionValues(this.myArguments, key);
    }

    @Nullable
    public RPsiElement getOptionValueElement(@Nullable String key) {
        return RubyInterpretUtil.getOptionValueElement(this.myArguments, key);
    }

    public List<String> getOptionHashKeys(String key) {
        RPsiElement element = this.getOptionValueElement(key);
        if (element instanceof RAssocList) {
            ArrayList<String> result = new ArrayList<String>();
            for (RAssoc assoc : ((RAssocList)element).getAssocElements()) {
                RPsiElement keyElement = assoc.getKey();
                if (keyElement == null) continue;
                ContainerUtil.addIfNotNull(result, (Object)RubyPsiUtilCore.getElementText((PsiElement)keyElement));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public boolean hasOptionKey(@NotNull String key) {
        if (key == null) {
            RCallArguments.$$$reportNull$$$0(9);
        }
        return this.getOptionValueElement(key) != null;
    }

    public RubyPsiInterpreter childInterpreter() {
        return this.myOwner.child();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RCallArguments:[");
        sb.append("self=").append(this.mySelf).append(";");
        sb.append("command=").append(this.myCommand).append(";");
        sb.append("call_el=").append(this.myCallElement.getTextRange().getStartOffset()).append(";");
        sb.append("arguments=(");
        for (RPsiElement arg : this.myArguments) {
            sb.append(arg.getTextRange().getStartOffset()).append(",");
        }
        sb.append(");");
        if (this.myBlock != null) {
            sb.append("block=").append(this.myBlock.getTextRange().getStartOffset());
        }
        sb.append("]");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/interpret/RCallArguments";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/interpret/RCallArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRCallElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRBlockCallElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasOptionKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

