/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.thenmultilineconditional;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;

public final class RubyThenInMultilineConditionalInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyThenInMultilineConditionalInspection.$$$reportNull$$$0(0);
        }
        return new RubyThenInMultilineConditionalVisitor(holder);
    }

    private static boolean isThenTokenType(PsiElement element) {
        return element != null && element.getNode() != null && element.getNode().getElementType() == RubyTokenTypes.kTHEN;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/thenmultilineconditional/RubyThenInMultilineConditionalInspection", "buildVisitor"));
    }

    private static class RubyThenInMultilineConditionalVisitor
    extends RubyInspectionVisitor {
        RubyThenInMultilineConditionalVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRIfStatement(@NotNull RIfStatement ifStatement) {
            if (ifStatement == null) {
                RubyThenInMultilineConditionalVisitor.$$$reportNull$$$0(0);
            }
            this.checkConditionalStatement((RConditionalStatement)ifStatement);
        }

        public void visitRUnlessStatement(@NotNull RUnlessStatement rUnlessStatement) {
            if (rUnlessStatement == null) {
                RubyThenInMultilineConditionalVisitor.$$$reportNull$$$0(1);
            }
            this.checkConditionalStatement((RConditionalStatement)rUnlessStatement);
        }

        private void checkConditionalStatement(@NotNull RConditionalStatement conditionalStatement) {
            RCondition condition;
            if (conditionalStatement == null) {
                RubyThenInMultilineConditionalVisitor.$$$reportNull$$$0(2);
            }
            if ((condition = conditionalStatement.getCondition()) == null || condition.getNextSibling() == null) {
                return;
            }
            PsiElement element = condition.getNextSibling().getNextSibling();
            if (!RubyThenInMultilineConditionalInspection.isThenTokenType(element)) {
                return;
            }
            int firstChildOffset = conditionalStatement.getFirstChild().getTextRange().getStartOffset();
            int lastChildOffset = conditionalStatement.getLastChild().getTextRange().getStartOffset();
            PsiFile file = conditionalStatement.getContainingFile();
            if (file == null) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            if (document == null) {
                return;
            }
            if (document.getLineNumber(firstChildOffset) != document.getLineNumber(lastChildOffset)) {
                this.registerProblem(element, RBundle.message((String)"inspection.then.in.multiline.conditional"), new ThenInMultiLineConditionalFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rUnlessStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conditionalStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/thenmultilineconditional/RubyThenInMultilineConditionalInspection$RubyThenInMultilineConditionalVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIfStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRUnlessStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkConditionalStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ThenInMultiLineConditionalFix
    extends RubyFix {
        private ThenInMultiLineConditionalFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                ThenInMultiLineConditionalFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ThenInMultiLineConditionalFix.$$$reportNull$$$0(1);
            }
            if (!RubyThenInMultilineConditionalInspection.isThenTokenType(element = descriptor.getPsiElement())) {
                return;
            }
            element.delete();
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.then.in.multiline.conditional.msg");
            if (string == null) {
                ThenInMultiLineConditionalFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/thenmultilineconditional/RubyThenInMultilineConditionalInspection$ThenInMultiLineConditionalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/thenmultilineconditional/RubyThenInMultilineConditionalInspection$ThenInMultiLineConditionalFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

