/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.ternaryoperator;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;

public final class RubyNestedTernaryOperatorsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyNestedTernaryOperatorsInspection.$$$reportNull$$$0(0);
        }
        return new NestedTernaryOperatorsVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/ternaryoperator/RubyNestedTernaryOperatorsInspection", "buildVisitor"));
    }

    private static class NestedTernaryOperatorsVisitor
    extends RubyInspectionVisitor {
        NestedTernaryOperatorsVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRTernaryExpression(@NotNull RTernaryExpression ternaryExpression) {
            PsiElement parentTernaryExpression;
            if (ternaryExpression == null) {
                NestedTernaryOperatorsVisitor.$$$reportNull$$$0(0);
            }
            if ((parentTernaryExpression = PsiTreeUtil.getParentOfType((PsiElement)ternaryExpression, (Class[])new Class[]{RTernaryExpression.class, RPossibleCall.class})) instanceof RTernaryExpression) {
                this.registerProblem(parentTernaryExpression, RBundle.message((String)"inspection.nested.ternary.operators"), new NestedTernaryOperatorsFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ternaryExpression", "org/jetbrains/plugins/ruby/ruby/inspections/ternaryoperator/RubyNestedTernaryOperatorsInspection$NestedTernaryOperatorsVisitor", "visitRTernaryExpression"));
        }
    }

    private static class NestedTernaryOperatorsFix
    extends RubyFix {
        private NestedTernaryOperatorsFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            RTernaryExpression ternaryOperator;
            if (project == null) {
                NestedTernaryOperatorsFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                NestedTernaryOperatorsFix.$$$reportNull$$$0(1);
            }
            if ((ternaryOperator = (RTernaryExpression)descriptor.getPsiElement()) == null) {
                return;
            }
            RPsiElement trueCommand = NestedTernaryOperatorsFix.getExpression(ternaryOperator.getTrueCommand());
            RPsiElement falseCommand = NestedTernaryOperatorsFix.getExpression(ternaryOperator.getFalseCommand());
            RCondition condition = ternaryOperator.getCondition();
            if (condition != null && trueCommand != null && falseCommand != null) {
                RIfStatement generated = (RIfStatement)RubyElementFactoryCore.createElementFromText((PsiElement)ternaryOperator, (String)("if " + condition.getText() + "\n  " + trueCommand.getText() + "\nelse\n  " + falseCommand.getText() + "\nend"));
                ternaryOperator.replace((PsiElement)generated);
            }
        }

        @Nullable
        private static RPsiElement getExpression(RPsiElement element) {
            while (element != null) {
                if (element instanceof RGroupedExpression) {
                    element = ((RGroupedExpression)element).getExpression();
                    continue;
                }
                if (element instanceof RCompoundStatement && ((RCompoundStatement)element).getStatements().size() == 1 && ((RCompoundStatement)element).getStatements().get(0) instanceof RGroupedExpression) {
                    element = (RPsiElement)((RCompoundStatement)element).getStatements().get(0);
                    continue;
                }
                return element;
            }
            return null;
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.nested.ternary.operators.fix");
            if (string == null) {
                NestedTernaryOperatorsFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/ternaryoperator/RubyNestedTernaryOperatorsInspection$NestedTernaryOperatorsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/ternaryoperator/RubyNestedTernaryOperatorsInspection$NestedTernaryOperatorsFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

