/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RClassAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RModuleAccess;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressAllForClassCommentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressAllForModuleCommentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressForClassCommentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressForMethodCommentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressForModuleCommentFix;
import org.jetbrains.plugins.ruby.ruby.inspections.suppress.RubySuppressForStatementCommentFix;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubySuppressionHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStrings;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RControlStructureStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.RArgumentListNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RGroupedExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RCodeBlockNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBraceCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubySuppressionUtil {
    @NonNls
    public static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("#\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*.*");

    private RubySuppressionUtil() {
    }

    public static SuppressQuickFix @NotNull [] getDefaultSuppressActions(@NotNull String toolId) {
        if (toolId == null) {
            RubySuppressionUtil.$$$reportNull$$$0(0);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new RubySuppressForStatementCommentFix(toolId), new RubySuppressForMethodCommentFix(toolId), new RubySuppressForClassCommentFix(toolId), new RubySuppressForModuleCommentFix(toolId), new RubySuppressAllForClassCommentFix(), new RubySuppressAllForModuleCommentFix()};
        if (suppressQuickFixArray == null) {
            RubySuppressionUtil.$$$reportNull$$$0(1);
        }
        return suppressQuickFixArray;
    }

    public static boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            RubySuppressionUtil.$$$reportNull$$$0(2);
        }
        if (toolId == null) {
            RubySuppressionUtil.$$$reportNull$$$0(3);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (RubySuppressionUtil.getSuppressedInStatement(element, toolId) != null) {
                return true;
            }
            if (RubySuppressionUtil.getSuppressedInMethod(element, toolId) != null) {
                return true;
            }
            if (RubySuppressionUtil.getSuppressedInBlock(element, toolId) != null) {
                return true;
            }
            return RubySuppressionUtil.getSuppressedInModuleOrClass(element, toolId) != null;
        });
    }

    @Nullable
    private static PsiComment getSuppressedInBlock(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            RubySuppressionUtil.$$$reportNull$$$0(4);
        }
        if (toolId == null) {
            RubySuppressionUtil.$$$reportNull$$$0(5);
        }
        RBlockCall call = RubyPsiUtil.getContainingRBlockCall(place);
        while (call != null) {
            PsiComment suppressionHolderElement = RubySuppressionUtil.getSuppressionComment(toolId, (PsiElement)call);
            if (suppressionHolderElement != null) {
                return suppressionHolderElement;
            }
            call = RubyPsiUtil.getContainingRBlockCall((PsiElement)call);
        }
        return null;
    }

    @Nullable
    private static PsiComment getSuppressedInMethod(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            RubySuppressionUtil.$$$reportNull$$$0(6);
        }
        if (toolId == null) {
            RubySuppressionUtil.$$$reportNull$$$0(7);
        }
        RContainer container = RubyPsiUtilCore.getParentContainerOrSelf((PsiElement)place);
        while (container instanceof RMethod) {
            PsiComment suppressionHolderElement = RubySuppressionUtil.getSuppressionComment(toolId, (PsiElement)container);
            if (suppressionHolderElement != null) {
                return suppressionHolderElement;
            }
            container = (RContainer)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)container, RContainer.class);
        }
        return null;
    }

    @Nullable
    private static PsiComment getSuppressedInModuleOrClass(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            RubySuppressionUtil.$$$reportNull$$$0(8);
        }
        if (toolId == null) {
            RubySuppressionUtil.$$$reportNull$$$0(9);
        }
        RContainer container = RubyPsiUtilCore.getParentContainerOrSelf((PsiElement)place);
        while (container instanceof RModule || container instanceof RClass || container instanceof RMethod) {
            PsiComment suppressionHolderElement;
            if (!(container instanceof RMethod) && (suppressionHolderElement = RubySuppressionUtil.getSuppressionComment(toolId, (PsiElement)container)) != null) {
                return suppressionHolderElement;
            }
            container = container.getParentContainer();
        }
        return null;
    }

    @Nullable
    private static PsiComment getSuppressedInStatement(@NotNull PsiElement place, @NotNull String toolId) {
        PsiElement suppressionForControlStatement;
        PsiElement statement;
        PsiComment suppressionHolderElement;
        if (place == null) {
            RubySuppressionUtil.$$$reportNull$$$0(10);
        }
        if (toolId == null) {
            RubySuppressionUtil.$$$reportNull$$$0(11);
        }
        if ((suppressionHolderElement = RubySuppressionUtil.getSuppressionComment(toolId, statement = RubySuppressionUtil.findEnclosingSuppressibleStatement(place))) != null) {
            return suppressionHolderElement;
        }
        RControlStructureStatement coveringControllStatement = (RControlStructureStatement)PsiTreeUtil.getParentOfType((PsiElement)place, RControlStructureStatement.class);
        if (coveringControllStatement != null && (suppressionHolderElement = RubySuppressionUtil.getSuppressionComment(toolId, suppressionForControlStatement = RubySuppressionUtil.findEnclosingSuppressibleStatement((PsiElement)coveringControllStatement))) != null) {
            return suppressionHolderElement;
        }
        return null;
    }

    @Nullable
    private static PsiComment getSuppressionComment(@NotNull String toolId, @Nullable PsiElement element) {
        if (toolId == null) {
            RubySuppressionUtil.$$$reportNull$$$0(12);
        }
        if (element != null) {
            List comments = RubyCommentsUtilCore.getPsiComments((PsiElement)element);
            for (PsiComment comment : comments) {
                String text = comment.getText();
                Matcher matcher = SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text);
                if (!matcher.matches() || !SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) continue;
                return comment;
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement findEnclosingSuppressibleStatement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement supressContext = element;
        supressContext = PsiTreeUtil.getParentOfType((PsiElement)supressContext, RubySuppressionHolder.class, (boolean)false);
        while (supressContext != null) {
            RGroupedExpression groupedExpression;
            RCodeBlock doCodeBlock;
            RArgumentList argumentList;
            RBlockCall blockCall;
            if (supressContext instanceof RIdentifier && ((RIdentifier)supressContext).isBlockParameterDeclaration() && (blockCall = RBlockCallNavigator.getByBlockParameters((RArgumentList)(argumentList = Objects.requireNonNull(RArgumentListNavigator.getByArgumentContents((RPsiElement)((RPsiElement)supressContext)), "Guaranteed by UsageAnalyzer.isBlockParameter")))) != null) {
                return blockCall;
            }
            RPsiElement unsplittableParent = (RPsiElement)PsiTreeUtil.getParentOfType((PsiElement)supressContext, (Class[])new Class[]{RArgumentList.class, RArray.class, RAssoc.class, RDStringLiteralImpl.class, RStrings.class});
            if (unsplittableParent != null) {
                supressContext = PsiTreeUtil.getParentOfType((PsiElement)unsplittableParent, RubySuppressionHolder.class, (boolean)false);
                continue;
            }
            PsiElement parent = supressContext.getParent();
            if (parent instanceof RCompoundStatement && (doCodeBlock = RCodeBlockNavigator.getByBlockCmsSt((RCompoundStatement)((RCompoundStatement)parent))) instanceof RBraceCodeBlock && !doCodeBlock.getText().contains("\n")) {
                supressContext = doCodeBlock;
                continue;
            }
            Access access = UsageAnalyzer.createUsageAccess((RPsiElement)supressContext);
            if (access instanceof RModuleAccess) {
                supressContext = ((RModuleAccess)access).getModule();
            }
            if (access instanceof RClassAccess) {
                supressContext = ((RClassAccess)access).getRClass();
            }
            if ((groupedExpression = RGroupedExpressionNavigator.getByExpression((PsiElement)parent)) == null && !(parent instanceof RubySuppressionHolder)) {
                return supressContext;
            }
            supressContext = parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/suppress/RubySuppressionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/suppress/RubySuppressionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultSuppressActions";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInBlock";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInMethod";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInModuleOrClass";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressionComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

