/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.superclass;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

public final class RubyModuleAsSuperclassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyModuleAsSuperclassInspection.$$$reportNull$$$0(0);
        }
        return new RubyModuleAsSuperclassVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/superclass/RubyModuleAsSuperclassInspection", "buildVisitor"));
    }

    private static class RubyModuleAsSuperclassVisitor
    extends RubyInspectionVisitor {
        RubyModuleAsSuperclassVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                RubyModuleAsSuperclassVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRClass(@NotNull RClass rClass) {
            RSuperClass superClass;
            if (rClass == null) {
                RubyModuleAsSuperclassVisitor.$$$reportNull$$$0(1);
            }
            if ((superClass = rClass.getPsiSuperClass()) == null) {
                return;
            }
            FQN fqn = rClass.getSuperClassFQN();
            if (fqn == null) {
                return;
            }
            RContainer parentContainer = rClass.getParentContainer();
            Symbol parentSymbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)parentContainer);
            if (parentSymbol == null) {
                return;
            }
            Symbol constant = SymbolUtil.resolveConstantFQN(parentSymbol, (RPsiElement)rClass, fqn, SymbolUtil.getClassModuleConstantTypes(), (PsiElement)rClass);
            if (constant != null && SymbolUtil.getModuleTypes().contains(constant.getType())) {
                this.registerProblem((PsiElement)superClass, RBundle.message((String)"inspection.module.as.superclass"));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/superclass/RubyModuleAsSuperclassInspection$RubyModuleAsSuperclassVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

