/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.strings;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.stringLiterals.baseString.RDStringLiteralImpl;

public final class RubyQuotedStringsInspection
extends LocalInspectionTool {
    private static final Pattern ESCAPE_SYMBOL_PATTERN = Pattern.compile("(\\\\)(a|b|c|e|f|n|r|s|t|v|[0-7])");
    @Attribute(value="m_ignoreSingleQuote")
    public boolean myIgnoreSingleQuote = false;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myIgnoreSingleQuote", (String)RBundle.message((String)"inspection.quoted.string.label"), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RubyQuotedStringsInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyQuotedStringsInspection.$$$reportNull$$$0(1);
        }
        return new DoubleQuotedStringVisitor(holder);
    }

    private static void convertToSingleQuoted(@Nullable PsiElement stringElement) {
        if (!(stringElement instanceof RDStringLiteralImpl)) {
            return;
        }
        RDStringLiteralImpl doubleQuotedString = (RDStringLiteralImpl)stringElement;
        PsiElement left = doubleQuotedString.getStringBeginning();
        PsiElement right = doubleQuotedString.getStringEnding();
        if (left == null || right == null) {
            return;
        }
        String text = "'" + RubyQuotedStringsInspection.doConvertToSingleQuoted(doubleQuotedString.getContent()) + "'";
        doubleQuotedString.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)doubleQuotedString, (String)text));
    }

    @NotNull
    private static String doConvertToSingleQuoted(@NotNull String doubleQuotedStringContent) {
        if (doubleQuotedStringContent == null) {
            RubyQuotedStringsInspection.$$$reportNull$$$0(2);
        }
        String unescapedString = RubyQuotedStringsInspection.doUnescape(doubleQuotedStringContent);
        String string = StringUtil.escapeChars((String)unescapedString, (char[])new char[]{'\\', '\''});
        if (string == null) {
            RubyQuotedStringsInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String doUnescape(@NotNull String doubleQuotedStringContent) {
        if (doubleQuotedStringContent == null) {
            RubyQuotedStringsInspection.$$$reportNull$$$0(4);
        }
        StringBuilder builder2 = new StringBuilder();
        for (int i = 0; i < doubleQuotedStringContent.length(); ++i) {
            char currentCharacter = doubleQuotedStringContent.charAt(i);
            if (currentCharacter == '\\') {
                if (i + 1 >= doubleQuotedStringContent.length() || doubleQuotedStringContent.charAt(i + 1) != '\\') continue;
                ++i;
            }
            builder2.append(currentCharacter);
        }
        String string = builder2.toString();
        if (string == null) {
            RubyQuotedStringsInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doubleQuotedStringContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "doConvertToSingleQuoted";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doUnescape";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doConvertToSingleQuoted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doUnescape";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4 -> new IllegalArgumentException(string);
        };
    }

    private class DoubleQuotedStringVisitor
    extends RubyInspectionVisitor {
        DoubleQuotedStringVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
            if (rDStringLiteral == null) {
                DoubleQuotedStringVisitor.$$$reportNull$$$0(0);
            }
            String content = rDStringLiteral.getContent();
            if (RubyQuotedStringsInspection.this.myIgnoreSingleQuote && StringUtil.containsChar((String)content, (char)'\'')) {
                return;
            }
            if (!rDStringLiteral.hasExpressionSubstitutions() && content != null && !ESCAPE_SYMBOL_PATTERN.matcher(content).find()) {
                this.registerProblem((PsiElement)rDStringLiteral, RBundle.message((String)"inspection.quoted.string.msg"), new DoubleQuotedStringFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rDStringLiteral", "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection$DoubleQuotedStringVisitor", "visitRDStringLiteral"));
        }
    }

    private static class DoubleQuotedStringFix
    extends RubyFix {
        private DoubleQuotedStringFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            if (project == null) {
                DoubleQuotedStringFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                DoubleQuotedStringFix.$$$reportNull$$$0(1);
            }
            PsiElement stringElement = descriptor.getPsiElement();
            RubyQuotedStringsInspection.convertToSingleQuoted(stringElement);
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.quoted.string.fix");
            if (string == null) {
                DoubleQuotedStringFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection$DoubleQuotedStringFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/strings/RubyQuotedStringsInspection$DoubleQuotedStringFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

