/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.simplify;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.simplify.RubySimplifyBooleanVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.refactoring.RubyReplaceExpressionUtil;

class RubySimplifyBooleanQuickFix
extends RubyFix {
    @Nullable
    private final String myReplacementText;

    RubySimplifyBooleanQuickFix(@NotNull RPsiElement element) {
        if (element == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(0);
        }
        this.myReplacementText = RubySimplifyBooleanQuickFix.createReplacementText(element);
    }

    @NotNull
    public String getName() {
        String string = RBundle.message((String)"inspection.simplify.message.quickfix.message", (Object[])new Object[]{this.myReplacementText});
        if (string == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"inspection.simplify.familyName");
        if (string == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement oldElement;
        if (project == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(4);
        }
        if ((oldElement = descriptor.getPsiElement()) == null || this.myReplacementText == null) {
            return;
        }
        RPsiElement replacement = RubyElementFactoryCore.createElementFromText((PsiElement)descriptor.getPsiElement(), (String)this.myReplacementText);
        oldElement.replace((PsiElement)replacement);
    }

    @Nullable
    private static String createReplacementText(@NotNull RPsiElement element) {
        RPsiElement replacementElement;
        if (element == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(5);
        }
        if ((replacementElement = RubySimplifyBooleanQuickFix.getReplacementElement(element)) == null) {
            return null;
        }
        if (RubyReplaceExpressionUtil.isNeedParenthesis(element, replacementElement)) {
            return "(" + replacementElement.getText() + ")";
        }
        return replacementElement.getText();
    }

    @Nullable
    static RPsiElement getReplacementElement(@NotNull RPsiElement element) {
        RPsiElement right;
        RPsiElement left;
        IElementType operation;
        RBoolMatchingExpression binExpression;
        if (element == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(6);
        }
        if (element instanceof RBoolNegExpression) {
            ControlFlowHolder holder = (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)element, ControlFlowHolder.class);
            assert (holder != null);
            RPsiElement child = element;
            RPsiElement acceptableChild = null;
            while (child instanceof RBoolNegExpression && child.getLastChild() instanceof RBoolNegExpression) {
                if (!RTypeUtil.isBoolType(RTypeUtil.getType((PsiElement)(child = child.getLastChild().getLastChild()))) || NilAnalysisUtil.getCanBeNil(child, holder) != ThreeState.NO) continue;
                acceptableChild = child;
            }
            if (acceptableChild != null) {
                return acceptableChild;
            }
        }
        if (element instanceof RBoolMatchingExpression) {
            binExpression = (RBoolMatchingExpression)element;
            operation = binExpression.getOperationType();
            left = binExpression.getLeftOperand();
            right = binExpression.getRightOperand();
            if (right == null) {
                return null;
            }
            if (RubySimplifyBooleanQuickFix.simplifyMatching(operation, left, right) != null) {
                return RubySimplifyBooleanQuickFix.simplifyMatching(operation, left, right);
            }
            if (RubySimplifyBooleanQuickFix.simplifyMatching(operation, right, left) != null) {
                return RubySimplifyBooleanQuickFix.simplifyMatching(operation, right, left);
            }
        }
        if (element instanceof RBoolBinExpression) {
            binExpression = (RBoolBinExpression)element;
            operation = binExpression.getOperationType();
            left = binExpression.getLeftOperand();
            right = binExpression.getRightOperand();
            if (right != null && RubySimplifyBooleanQuickFix.simplifyBooleanBinary(operation, left, right) != null) {
                return RubySimplifyBooleanQuickFix.simplifyBooleanBinary(operation, left, right);
            }
        }
        return null;
    }

    @Nullable
    private static RPsiElement simplifyMatching(@NotNull IElementType operation, @NotNull RPsiElement left, @NotNull RPsiElement right) {
        if (operation == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(7);
        }
        if (left == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(8);
        }
        if (right == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(9);
        }
        if (!(left instanceof RPseudoConstant)) {
            return null;
        }
        if (operation.equals(RubyTokenTypesCore.tEQ)) {
            if (left.getText().equals(RubySimplifyBooleanVisitor.RUBY_TRUE)) {
                return right;
            }
            if (left.getText().equals(RubySimplifyBooleanVisitor.RUBY_FALSE)) {
                return RubySimplifyBooleanQuickFix.negate(right);
            }
        }
        if (operation == RubyTokenTypes.tNEQ) {
            if (left.getText().equals(RubySimplifyBooleanVisitor.RUBY_TRUE)) {
                return RubySimplifyBooleanQuickFix.negate(right);
            }
            if (left.getText().equals(RubySimplifyBooleanVisitor.RUBY_FALSE)) {
                return right;
            }
        }
        return null;
    }

    @Nullable
    private static RPsiElement simplifyBooleanBinary(@NotNull IElementType operation, @NotNull RPsiElement left, @NotNull RPsiElement right) {
        if (operation == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(10);
        }
        if (left == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(11);
        }
        if (right == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(12);
        }
        String leftText = left.getText();
        if (operation.equals(RubyTokenTypesCore.tAND) || operation.equals(RubyTokenTypes.kAND)) {
            if (RubySimplifyBooleanVisitor.RUBY_TRUE.equals(leftText) || left instanceof RLiteral) {
                return right;
            }
            if (RubySimplifyBooleanVisitor.RUBY_FALSE.equals(leftText) || RubySimplifyBooleanVisitor.RUBY_NIL.equals(leftText)) {
                return left;
            }
            return RubySimplifyBooleanQuickFix.simplifyEqualExpressions(left, right, RubySimplifyBooleanVisitor.RUBY_FALSE);
        }
        if (operation == RubyTokenTypesCore.tOR || operation.equals(RubyTokenTypes.kOR)) {
            if (RubySimplifyBooleanVisitor.RUBY_TRUE.equals(leftText) || left instanceof RLiteral) {
                return left;
            }
            if (RubySimplifyBooleanVisitor.RUBY_FALSE.equals(leftText) || RubySimplifyBooleanVisitor.RUBY_NIL.equals(leftText)) {
                return right;
            }
            return RubySimplifyBooleanQuickFix.simplifyEqualExpressions(left, right, RubySimplifyBooleanVisitor.RUBY_TRUE);
        }
        return null;
    }

    @Nullable
    private static RPsiElement simplifyEqualExpressions(@NotNull RPsiElement left, @NotNull RPsiElement right, @NotNull String constant) {
        String rightText;
        String leftText;
        if (left == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(13);
        }
        if (right == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(14);
        }
        if (constant == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(15);
        }
        if ((leftText = left.getText()).equals(rightText = right.getText())) {
            return left;
        }
        if (right instanceof RBoolNegExpression && leftText.equals(right.getLastChild().getText())) {
            return RubySimplifyBooleanQuickFix.createConstant(right, constant);
        }
        if (left instanceof RBoolNegExpression && rightText.equals(left.getLastChild().getText())) {
            return RubySimplifyBooleanQuickFix.createConstant(left, constant);
        }
        return null;
    }

    @NotNull
    private static RPsiElement createConstant(@NotNull RPsiElement context, @NotNull String text) {
        if (context == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(16);
        }
        if (text == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(17);
        }
        RExpression rExpression = RubyElementFactoryCore.createExpressionFromText((PsiElement)context, (String)text);
        if (rExpression == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(18);
        }
        return rExpression;
    }

    @NotNull
    private static RPsiElement negate(@NotNull RPsiElement psiElement) {
        RExpression expression;
        if (psiElement == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(19);
        }
        if (!((expression = RubyElementFactoryCore.createExpressionFromText((PsiElement)psiElement, (String)"!true")) instanceof RBoolNegExpression)) {
            throw new AssertionError((Object)"could not create negative expression");
        }
        RPsiElement element = ((RBoolNegExpression)expression).getElement();
        assert (element != null);
        if (RubyReplaceExpressionUtil.isNeedParenthesis(element, psiElement)) {
            RExpression rExpression = RubyElementFactoryCore.createExpressionFromText((PsiElement)psiElement, (String)("!(" + psiElement.getText() + ")"));
            if (rExpression == null) {
                RubySimplifyBooleanQuickFix.$$$reportNull$$$0(20);
            }
            return rExpression;
        }
        RExpression rExpression = RubyElementFactoryCore.createExpressionFromText((PsiElement)psiElement, (String)("!" + psiElement.getText()));
        if (rExpression == null) {
            RubySimplifyBooleanQuickFix.$$$reportNull$$$0(21);
        }
        return rExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 18, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/simplify/RubySimplifyBooleanQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/simplify/RubySimplifyBooleanQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstant";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "negate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createReplacementText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "simplifyMatching";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "simplifyBooleanBinary";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "simplifyEqualExpressions";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createConstant";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "negate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 18, 20, 21 -> new IllegalStateException(string);
        };
    }
}

