/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.scopes;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.console.RubyLanguageConsoleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.Scope;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeVariable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.Access;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.ruby19.BlockCallLocalVariableAccess;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.scopes.RubyScopesInspection;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyExpressionCodeFragment;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.InstructionGraphUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RContainerBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RDoCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class RubyScopesVisitor
extends RubyInspectionVisitor {
    private final LocalInspectionToolSession mySession;

    public RubyScopesVisitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
        if (holder == null) {
            RubyScopesVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
        this.mySession = session;
    }

    public void visitRClass(@NotNull RClass rClass) {
        if (rClass == null) {
            RubyScopesVisitor.$$$reportNull$$$0(1);
        }
        this.checkControlFlowHolder((ControlFlowHolder)rClass);
        super.visitRClass(rClass);
    }

    public void visitRSingletonMethod(@NotNull RSingletonMethod rsMethod) {
        if (rsMethod == null) {
            RubyScopesVisitor.$$$reportNull$$$0(2);
        }
        this.checkControlFlowHolder((ControlFlowHolder)rsMethod);
        super.visitRSingletonMethod(rsMethod);
    }

    public void visitRMethod(@NotNull RMethod rMethod) {
        if (rMethod == null) {
            RubyScopesVisitor.$$$reportNull$$$0(3);
        }
        this.checkControlFlowHolder((ControlFlowHolder)rMethod);
        super.visitRMethod(rMethod);
    }

    public void visitRCodeBlock(@NotNull RCodeBlock codeBlock) {
        if (codeBlock == null) {
            RubyScopesVisitor.$$$reportNull$$$0(4);
        }
        this.checkControlFlowHolder((ControlFlowHolder)codeBlock);
        super.visitRCodeBlock(codeBlock);
    }

    public void visitRModule(@NotNull RModule rModule) {
        if (rModule == null) {
            RubyScopesVisitor.$$$reportNull$$$0(5);
        }
        this.checkControlFlowHolder((ControlFlowHolder)rModule);
        super.visitRModule(rModule);
    }

    public void visitRFile(@NotNull RFile rFile) {
        if (rFile == null) {
            RubyScopesVisitor.$$$reportNull$$$0(6);
        }
        this.checkControlFlowHolder((ControlFlowHolder)rFile);
        super.visitRFile(rFile);
    }

    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        if (rIdentifier == null) {
            RubyScopesVisitor.$$$reportNull$$$0(7);
        }
        ProgressManager.checkCanceled();
        if (rIdentifier.getContainingFile() instanceof RubyExpressionCodeFragment || RubyLanguageConsoleUtil.isInLanguageConsole((PsiElement)rIdentifier)) {
            return;
        }
        ScopeHolder owner = ScopeUtilCore.findScopeHolder((PsiElement)rIdentifier);
        if (owner == null) {
            return;
        }
        Scope scope = owner.getScope();
        String name = rIdentifier.getName();
        if (name == null || name.startsWith("_")) {
            return;
        }
        this.checkControlFlowHolder((ControlFlowHolder)owner);
        this.checkParameterDeclaration(rIdentifier, scope, name);
    }

    private void checkParameterDeclaration(@NotNull RIdentifier rIdentifier, @NotNull Scope scope, @NotNull String name) {
        if (rIdentifier == null) {
            RubyScopesVisitor.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            RubyScopesVisitor.$$$reportNull$$$0(9);
        }
        if (name == null) {
            RubyScopesVisitor.$$$reportNull$$$0(10);
        }
        if (!rIdentifier.isParameterDeclaration()) {
            return;
        }
        Access access = UsageAnalyzer.createUsageAccess((RPsiElement)rIdentifier);
        if (!RubyUsageAnalyzerCore.isParameterInScope((RPsiElement)rIdentifier)) {
            return;
        }
        boolean blockLocalDeclaration = access instanceof BlockCallLocalVariableAccess;
        boolean shadowingFound = false;
        ScopeVariable scopeVariable = scope.getDeclaredVariable((PsiElement)rIdentifier, name);
        ScopeVariable outerScopeVariable = (ScopeVariable)scope.getOuterScopeVariables().get(name);
        if (scopeVariable != null) {
            if (scopeVariable.getType() == Type.METHOD_PARAMETER) {
                if (outerScopeVariable != null) {
                    if (!blockLocalDeclaration) {
                        this.registerProblem((PsiElement)rIdentifier, RBundle.message((String)"inspection.scopes.parameter.shadows.outer", (Object[])new Object[]{name}));
                    }
                    shadowingFound = true;
                }
            } else {
                if (!blockLocalDeclaration) {
                    this.registerProblem((PsiElement)rIdentifier, RBundle.message((String)"inspection.scopes.parameter.shadows.outer", (Object[])new Object[]{name}));
                }
                shadowingFound = true;
            }
        }
        if (blockLocalDeclaration && !shadowingFound) {
            this.registerProblem((PsiElement)rIdentifier, RBundle.message((String)"inspection.scopes.redundant.block.local.variable", (Object[])new Object[]{name}));
        }
    }

    private void checkControlFlowHolder(@NotNull ControlFlowHolder owner) {
        if (owner == null) {
            RubyScopesVisitor.$$$reportNull$$$0(11);
        }
        if (TypeInferenceContext.isTooBigForTypeInference(InstructionGraphUtil.getInstructionGraph(owner))) {
            Set tooBigHolders = (Set)this.mySession.getUserData(RubyScopesInspection.TOO_BIG_CONTROL_FLOW_HOLDERS);
            assert (tooBigHolders != null) : "No too big control flow set found, please check that inspection " + ((Object)((Object)this)).getClass().getName() + " creates it in sessionStarted using createTooBigControlFlowHoldersSet()";
            if (tooBigHolders.contains(owner)) {
                return;
            }
            PsiElement element = owner instanceof RContainerBase ? ((RContainerBase)owner).getNameElement() : owner.getNavigationElement();
            String message = owner instanceof RCodeBlock ? RBundle.message((String)"inspection.scopes.do.block.too.big.for.type.inference") : RBundle.message((String)"inspection.scopes.too.big.for.type.inference", (Object[])new Object[]{owner.getName()});
            element = element instanceof RDoCodeBlock ? element.getFirstChild() : element;
            this.registerProblem(element, message, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
            tooBigHolders.add(owner);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rsMethod";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMethod";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/scopes/RubyScopesVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRSingletonMethod";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRMethod";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRCodeBlock";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIdentifier";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParameterDeclaration";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkControlFlowHolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

