/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop.asyncapi;

import com.intellij.application.options.CodeStyle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AsyncDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.FormattingService;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopAutocorrectFix;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInitialInformation;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyScriptExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public final class RubocopFormattingService
extends AsyncDocumentFormattingService {
    private static final Logger LOG = Logger.getInstance(RubocopFormattingService.class);
    private static final Set<FormattingService.Feature> FEATURES = EnumSet.noneOf(FormattingService.Feature.class);

    @Nullable
    protected AsyncDocumentFormattingService.FormattingTask createFormattingTask(final @NotNull AsyncFormattingRequest formattingRequest) {
        ProcessHandler processHandler;
        FormattingContext context;
        PsiFile file;
        VirtualFile virtualFile;
        if (formattingRequest == null) {
            RubocopFormattingService.$$$reportNull$$$0(0);
        }
        if ((virtualFile = (file = (context = formattingRequest.getContext()).getContainingFile()).getVirtualFile()) == null) {
            return null;
        }
        Project project = context.getProject();
        Sdk fileSdk = RubySdkUtil.getFileSdk(project, virtualFile);
        if (fileSdk == null) {
            return null;
        }
        RubocopInitialInformation initialInformation = new RubocopInitialInformation(project, virtualFile, fileSdk);
        final RubyGemExecutionContext executionContext = initialInformation.getGemExecutionContext(List.of("--fix-layout"));
        RubocopLinterModel model = initialInformation.getLinterModel();
        if (executionContext == null || !model.canRunInServerMode(executionContext.getGemVersion())) {
            return null;
        }
        RubyScriptExecutionContext scriptExecutionContext = executionContext.toRubyScriptExecutionContext();
        if (scriptExecutionContext == null) {
            return null;
        }
        try {
            processHandler = scriptExecutionContext.createProcessHandler();
        }
        catch (ExecutionException e) {
            LOG.warn("Error creating process handler!", (Throwable)e);
            return null;
        }
        if (processHandler == null) {
            return null;
        }
        final Document document = (Document)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getDocument(file));
        if (document == null) {
            return null;
        }
        return new AsyncDocumentFormattingService.FormattingTask(){

            public boolean cancel() {
                processHandler.destroyProcess();
                return true;
            }

            public void run() {
                processHandler.addProcessListener(RubocopAutocorrectFix.writeToStdinListener(document, virtualFile, false));
                processHandler.addProcessListener((ProcessListener)new CapturingProcessAdapter(){

                    public void processTerminated(@NotNull ProcessEvent event) {
                        int exitCode;
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((exitCode = event.getExitCode()) == 0 || exitCode == 1) {
                            ProcessOutput output2 = this.getOutput();
                            if (output2 == null) {
                                formattingRequest.onError(RBundle.message((String)"rubocop.formatter.process.output.null"), Optional.ofNullable(executionContext.getScriptPath()).orElse(""));
                                return;
                            }
                            String formattedText = RubocopAutocorrectFix.extractCorrectedText(output2, executionContext);
                            if (formattedText == null) {
                                formattingRequest.onError(RBundle.message((String)"rubocop.formatter.formatted.text.null.output"), output2.getStderr());
                            } else {
                                formattingRequest.onTextReady(formattedText);
                            }
                        } else {
                            LOG.debug(this.getOutput().getStdout());
                            LOG.debug(this.getOutput().getStderr());
                            formattingRequest.onError(RBundle.message((String)"rubocop.formatter.unexpected.error"), this.getOutput().getStderr());
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/asyncapi/RubocopFormattingService$1$1", "processTerminated"));
                    }
                });
                processHandler.startNotify();
            }

            public boolean isRunUnderProgress() {
                return true;
            }
        };
    }

    @NotNull
    protected String getNotificationGroupId() {
        return "Rubocop.Notification";
    }

    @NotNull
    protected String getName() {
        String string = RBundle.message((String)"rubocop.formatting.service");
        if (string == null) {
            RubocopFormattingService.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Set<FormattingService.Feature> getFeatures() {
        Set<FormattingService.Feature> set = FEATURES;
        if (set == null) {
            RubocopFormattingService.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean canFormat(@NotNull PsiFile file) {
        if (file == null) {
            RubocopFormattingService.$$$reportNull$$$0(3);
        }
        if (!Registry.is((String)"ruby.external.formatter")) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)RubyFileType.RUBY)) {
            return false;
        }
        RubyCodeStyleSettings settings = (RubyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, RubyCodeStyleSettings.class);
        if (!RubocopFormattingService.isRubocopFormatterPreferenceEnabled(settings)) {
            return false;
        }
        Project project = file.getProject();
        Sdk sdk = RubySdkUtil.getFileSdk(project, virtualFile);
        if (sdk == null) {
            return false;
        }
        RubocopLinterModel model = RubocopLinterModel.getModel(project);
        if (!model.isSupportedPlatform(sdk)) {
            return false;
        }
        return RubocopFormattingService.canRunRubocopInServerModeOnFile(project, file, sdk, model);
    }

    private static boolean canRunRubocopInServerModeOnFile(@NotNull Project project, @NotNull PsiFile file, @NotNull Sdk sdk, @NotNull RubocopLinterModel model) {
        VirtualFile virtualFile;
        if (project == null) {
            RubocopFormattingService.$$$reportNull$$$0(4);
        }
        if (file == null) {
            RubocopFormattingService.$$$reportNull$$$0(5);
        }
        if (sdk == null) {
            RubocopFormattingService.$$$reportNull$$$0(6);
        }
        if (model == null) {
            RubocopFormattingService.$$$reportNull$$$0(7);
        }
        if ((virtualFile = file.getVirtualFile()) == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        RubyGemExecutionContext executionContext = RubocopUtil.getExecutionContext(module, sdk, model.getGemName());
        return executionContext != null && model.canRunInServerMode(executionContext.getGemVersion());
    }

    private static boolean isRubocopFormatterPreferenceEnabled(@NotNull RubyCodeStyleSettings settings) {
        if (settings == null) {
            RubocopFormattingService.$$$reportNull$$$0(8);
        }
        if (!settings.USE_EXTERNAL_FORMATTER) {
            return false;
        }
        return RubyCodeStyleSettings.SupportedExternalFormatter.RUBOCOP.equals((Object)settings.SELECTED_EXTERNAL_FORMATTER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRequest";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/asyncapi/RubocopFormattingService";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/asyncapi/RubocopFormattingService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingTask";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canFormat";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canRunRubocopInServerModeOnFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRubocopFormatterPreferenceEnabled";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

