/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;

public final class StandardLinterModel
extends RubocopLinterModel {
    public static final StandardLinterModel INSTANCE = new StandardLinterModel();
    private static final String STANDARD_GEM_NAME = "standard";
    private static final String STANDARD_GEM_SCRIPT_NAME = "standardrb";
    private static final String STANDARD_FIX_UNSAFELY_FLAG = "--fix-unsafely";

    private StandardLinterModel() {
    }

    @Override
    @NotNull
    public String getGemName() {
        return STANDARD_GEM_NAME;
    }

    @Override
    public boolean canRunInServerMode(@Nullable String gemVersion) {
        return false;
    }

    @Override
    public boolean isSdkCompatible(@NotNull Sdk sdk) {
        if (sdk == null) {
            StandardLinterModel.$$$reportNull$$$0(0);
        }
        return RubyVersionUtil.isVersionGreaterOrEqual(sdk, "2.3");
    }

    @Override
    @NotNull
    public List<String> getAutocorrectArgs(@Nullable String gemVersion) {
        if (VersionComparatorUtil.compare((String)gemVersion, (String)"1.26") >= 0) {
            List<String> list = List.of("-A", STANDARD_FIX_UNSAFELY_FLAG);
            if (list == null) {
                StandardLinterModel.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (VersionComparatorUtil.compare((String)gemVersion, (String)"1.0") >= 0) {
            List<String> list = List.of("-A");
            if (list == null) {
                StandardLinterModel.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<String> list = List.of("-a");
        if (list == null) {
            StandardLinterModel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public String getGemScriptName() {
        return STANDARD_GEM_SCRIPT_NAME;
    }

    @TestOnly
    public static void installStandard(@NotNull Sdk sdk) {
        if (sdk == null) {
            StandardLinterModel.$$$reportNull$$$0(4);
        }
        INSTANCE.installToSdk(null, sdk, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/StandardLinterModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/StandardLinterModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutocorrectArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSdkCompatible";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installStandard";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

