/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsHolder;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyGemSearchUtil;
import org.jetbrains.plugins.ruby.gem.util.RubyProjectGemSearchService;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInitialInformation;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopUtil;
import org.jetbrains.plugins.ruby.utils.RubyPluginUtil;

@Service(value={Service.Level.PROJECT})
public final class RubocopSetUpNotificationService {
    private static final String NOTIFICATION_GROUP_ID = "RuboCop.SetUp.Notification";
    private final Project myProject;

    public RubocopSetUpNotificationService(@NotNull Project project) {
        if (project == null) {
            RubocopSetUpNotificationService.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        MessageBusConnection connection = this.myProject.getMessageBus().connect(RubyPluginUtil.getUnloadAwareDisposable(this.myProject));
        connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.checkNotifications(profile);
            }

            public void profileActivated(@Nullable InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                if (profile != null) {
                    this.checkNotifications(profile);
                }
            }

            private void checkNotifications(@NotNull InspectionProfile profile) {
                if (profile == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!profile.isToolEnabled(HighlightDisplayKey.find((String)RubocopInspection.SHORT_NAME))) {
                    RubocopSetUpNotificationService.this.getNotifications().forEach(Notification::expire);
                } else {
                    RubocopLinterModel model = RubocopLinterModel.getModel(RubocopSetUpNotificationService.this.myProject);
                    for (MyNotification notification : RubocopSetUpNotificationService.this.getNotifications()) {
                        if (notification.myModel == model) continue;
                        notification.expire();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "profile";
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopSetUpNotificationService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "profileChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNotifications";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(GemManager.MODULE_GEMS_CHANGED_TOPIC, module -> {
            for (MyNotification notification : this.getNotifications()) {
                if (RubyGemSearchUtil.findGem(notification.myModule, notification.mySdk, notification.myModel.getGemName()) == null) continue;
                notification.expire();
            }
        });
        connection.subscribe(GemRequirementsHolder.GEM_REQUIREMENTS_CHANGED_TOPIC, module -> {
            for (MyAddNotification notification : ContainerUtil.filterIsInstance(this.getNotifications(), MyAddNotification.class)) {
                @NotNull String gemName = notification.myModel.getGemName();
                if (RubyProjectGemSearchService.Companion.findGem(notification.myModule, gemName) == null) continue;
                notification.expire();
            }
        });
    }

    public void notify(@NotNull RubocopLinterModel model, @NotNull RubocopInitialInformation information) {
        Project project;
        if (model == null) {
            RubocopSetUpNotificationService.$$$reportNull$$$0(1);
        }
        if (information == null) {
            RubocopSetUpNotificationService.$$$reportNull$$$0(2);
        }
        if ((project = information.getProject()).isDisposed() || !RubocopInspection.isEnabled(project) || this.isNotificationActive()) {
            return;
        }
        Module module = information.getModule();
        Sdk sdk = information.getSdk();
        if (module == null || !model.isSdkCompatible(sdk)) {
            return;
        }
        if (BundlerUtil.hasGemfile(module)) {
            if (RubyProjectGemSearchService.Companion.findGem(module, model.getGemName()) == null) {
                new MyAddNotification(module, sdk, model).notify(project);
            }
        } else {
            new MyInstallNotification(module, sdk, model).notify(project);
        }
    }

    @NotNull
    private List<MyNotification> getNotifications() {
        List<MyNotification> list = List.of((MyNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(MyNotification.class, this.myProject));
        if (list == null) {
            RubocopSetUpNotificationService.$$$reportNull$$$0(3);
        }
        return list;
    }

    private boolean isNotificationActive() {
        return !this.getNotifications().isEmpty();
    }

    @NotNull
    public static RubocopSetUpNotificationService getInstance(@NotNull Project project) {
        if (project == null) {
            RubocopSetUpNotificationService.$$$reportNull$$$0(4);
        }
        RubocopSetUpNotificationService rubocopSetUpNotificationService = (RubocopSetUpNotificationService)project.getService(RubocopSetUpNotificationService.class);
        if (rubocopSetUpNotificationService == null) {
            RubocopSetUpNotificationService.$$$reportNull$$$0(5);
        }
        return rubocopSetUpNotificationService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "information";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopSetUpNotificationService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopSetUpNotificationService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotifications";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    private static final class MyAddNotification
    extends MyNotification {
        private MyAddNotification(@NotNull Module module, @NotNull Sdk sdk, @NotNull RubocopLinterModel model) {
            if (module == null) {
                MyAddNotification.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                MyAddNotification.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MyAddNotification.$$$reportNull$$$0(2);
            }
            super(module, sdk, model, RBundle.message((String)"inspection.rubocop.disabled"), RBundle.message((String)"inspection.rubocop.no.gem", (Object[])new Object[]{model.getGemName()}));
            this.setSuggestionType(true);
            this.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"inspection.rubocop.no.gem.action.title", (Object[])new Object[]{model.getGemName()})){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    RubocopUtil.addRubocopToGemfile(myModule.getProject(), myModule, myModel);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopSetUpNotificationService$MyAddNotification$1", "actionPerformed"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopSetUpNotificationService$MyAddNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyInstallNotification
    extends MyNotification {
        private MyInstallNotification(@NotNull Module module, @NotNull Sdk sdk, final @NotNull RubocopLinterModel model) {
            if (module == null) {
                MyInstallNotification.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                MyInstallNotification.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MyInstallNotification.$$$reportNull$$$0(2);
            }
            super(module, sdk, model, RBundle.message((String)"inspection.rubocop.disabled"), RBundle.message((String)"inspection.rubocop.install.gem", (Object[])new Object[]{model.getGemName()}));
            this.setSuggestionType(true);
            this.addAction((AnAction)new DumbAwareAction(RBundle.message((String)"inspection.rubocop.install.gem.action.title", (Object[])new Object[]{model.getGemName()})){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myModule.isDisposed()) {
                        return;
                    }
                    model.installToSdk(myModule, mySdk, () -> this.expire());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopSetUpNotificationService$MyInstallNotification$1", "actionPerformed"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopSetUpNotificationService$MyInstallNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MyNotification
    extends Notification {
        protected final Module myModule;
        protected final Sdk mySdk;
        protected final RubocopLinterModel myModel;

        private MyNotification(@NotNull Module module, @NotNull Sdk sdk, @NotNull RubocopLinterModel model, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content) {
            if (module == null) {
                MyNotification.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                MyNotification.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MyNotification.$$$reportNull$$$0(2);
            }
            if (title == null) {
                MyNotification.$$$reportNull$$$0(3);
            }
            if (content == null) {
                MyNotification.$$$reportNull$$$0(4);
            }
            super(RubocopSetUpNotificationService.NOTIFICATION_GROUP_ID, title, content, NotificationType.INFORMATION);
            this.myModule = module;
            this.mySdk = sdk;
            this.myModel = model;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "title";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "content";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopSetUpNotificationService$MyNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

