/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;

@Service(value={Service.Level.PROJECT})
public final class RubocopServerService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(RubocopServerService.class);
    private final Project myProject;
    private final Map<Module, Set<RubocopServerInfo>> myServerInfosByModule;

    public RubocopServerService(@NotNull Project project) {
        if (project == null) {
            RubocopServerService.$$$reportNull$$$0(0);
        }
        this.myServerInfosByModule = new ConcurrentHashMap<Module, Set<RubocopServerInfo>>();
        this.myProject = project;
        MessageBusConnection projectConnection = this.myProject.getMessageBus().connect((Disposable)this);
        projectConnection.subscribe(ModuleListener.TOPIC, (Object)new ModuleListener(){

            public void beforeModuleRemoved(@NotNull Project project, @NotNull Module module) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.debug("Stopping all Rubocop servers for removed module: ", new Object[]{module});
                RubocopServerService.this.stopModuleServers(module, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopServerService$1";
                objectArray[2] = "beforeModuleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        projectConnection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosing(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                LOG.debug("Stopping all Rubocop servers for closing project: ", new Object[]{project});
                RubocopServerService.this.stopAllServers(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopServerService$2", "projectClosing"));
            }
        });
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerServer(@NotNull Module module, @NotNull RubocopServerInfo serverInfo) {
        Set serverInfos;
        if (module == null) {
            RubocopServerService.$$$reportNull$$$0(1);
        }
        if (serverInfo == null) {
            RubocopServerService.$$$reportNull$$$0(2);
        }
        Set set = serverInfos = this.myServerInfosByModule.computeIfAbsent(module, __ -> new HashSet());
        synchronized (set) {
            if (serverInfos.add(serverInfo)) {
                LOG.debug("Registered Rubocop server path: module=", new Object[]{module, ", serverInfo=", serverInfo});
                if (serverInfos.size() > Registry.intValue((String)"ruby.rubocop.server.count.limit", (int)50)) {
                    LOG.warn("A limit on simultaneously running Rubocop servers is reached." + "Something is wrong, please contact the support: module=%s, serverInfo=%s".formatted(module, serverInfos));
                    RubocopLinterModel.showRubocopError(RBundle.message((String)"ruby.error.rubocop.servers.too.many", (Object[])new Object[]{module.getName()}), new AnAction[]{DumbAwareAction.create((String)RBundle.message((String)"ruby.actions.rubocop.servers.stop.all"), e -> {
                        this.stopModuleServers(module, true);
                        Notification.get((AnActionEvent)e).expire();
                    })});
                }
            }
        }
    }

    @VisibleForTesting
    public void stopAllServers(boolean isModal) {
        if (this.myServerInfosByModule.isEmpty()) {
            return;
        }
        LOG.debug("Stopping all Rubocop servers: project=", new Object[]{this.myProject});
        this.myServerInfosByModule.keySet().forEach(module -> this.stopModuleServers((Module)module, isModal));
        this.myServerInfosByModule.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopModuleServers(@NotNull Module module, boolean isModal) {
        ArrayList<RubocopServerInfo> serverInfosCopy;
        Set<RubocopServerInfo> serverInfos;
        if (module == null) {
            RubocopServerService.$$$reportNull$$$0(3);
        }
        if ((serverInfos = this.myServerInfosByModule.get(module)) == null) {
            return;
        }
        Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
        if (sdk == null) {
            LOG.warn("Failed to stop Rubocop servers due to unsupported sdk: module=%s, sdk=%s".formatted(module, sdk));
            return;
        }
        Set<RubocopServerInfo> set = serverInfos;
        synchronized (set) {
            serverInfosCopy = new ArrayList<RubocopServerInfo>(serverInfos);
            serverInfos.clear();
        }
        LOG.debug("Stopping Rubocop servers: module=", new Object[]{module, ", serverInfos=", serverInfosCopy});
        Project project = module.getProject();
        final Consumer<ProgressIndicator> stopServerRunnable = indicator -> {
            indicator.setIndeterminate(false);
            indicator.setText(RBundle.message((String)"progress.text.stopping.rubocop.servers.for.module", (Object[])new Object[]{module.getName()}));
            indicator.setFraction(0.0);
            for (int i = 0; i < serverInfosCopy.size(); ++i) {
                RubocopServerInfo serverInfo = (RubocopServerInfo)serverInfosCopy.get(i);
                indicator.setText2(RBundle.message((String)"progress.details.stopping.rubocop.server.at.path", (Object[])new Object[]{serverInfo.serverPath}));
                RubocopServerService.stopServer(module, sdk, serverInfo);
                indicator.setFraction(Math.min(((double)i + 1.0) / (double)serverInfosCopy.size(), 1.0));
            }
        };
        Object stopServerTask = isModal ? new Task.Modal(project, RBundle.message((String)"progress.title.stopping.rubocop.servers"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                stopServerRunnable.accept(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopServerService$3", "run"));
            }
        } : new Task.Backgroundable(project, RBundle.message((String)"progress.dialog.stopping.rubocop.servers"), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                stopServerRunnable.accept(indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopServerService$4", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)stopServerTask);
    }

    private static void stopServer(@NotNull Module module, @NotNull Sdk sdk, @NotNull RubocopServerInfo serverInfo) {
        ProcessOutput output2;
        if (module == null) {
            RubocopServerService.$$$reportNull$$$0(4);
        }
        if (sdk == null) {
            RubocopServerService.$$$reportNull$$$0(5);
        }
        if (serverInfo == null) {
            RubocopServerService.$$$reportNull$$$0(6);
        }
        LOG.debug("Stopping a Rubocop server: serverInfo=", new Object[]{serverInfo, ", module=", module});
        String gemName = serverInfo.gemName;
        String gemVersion = serverInfo.gemVersion;
        RubocopLinterModel model = RubocopLinterModel.getModel(gemName);
        RubyGemExecutionContext context = RubyGemExecutionContext.tryCreate(sdk, null, gemName, gemVersion);
        if (context == null) {
            LOG.warn("Failed to stop Rubocop server due to unsupported context: serverInfo=%s, module=%s, sdk=%s, context=%s".formatted(serverInfo, module, sdk, context));
            return;
        }
        ((RubyGemExecutionContext)((RubyGemExecutionContext)context.withProject(module.getProject())).withGemScriptName(model.getGemScriptName()).withArguments(List.of("--stop-server"))).withWorkingDirPath(serverInfo.serverPath);
        try {
            output2 = context.executeScript();
            LOG.debug("Rubocop server stopping output: ", new Object[]{output2});
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to stop Rubocop server: " + e.getMessage());
            return;
        }
        if (output2 == null) {
            LOG.warn("Rubocop server stopping output is null");
        } else if (!output2.isExitCodeSet()) {
            LOG.warn("Rubocop server stopping was interrupted or never finished");
        } else if (output2.getExitCode() != 0) {
            LOG.warn("Rubocop server stopping failed due to an error");
        }
    }

    @NotNull
    public static RubocopServerService getInstance(@NotNull Project project) {
        if (project == null) {
            RubocopServerService.$$$reportNull$$$0(7);
        }
        RubocopServerService rubocopServerService = (RubocopServerService)project.getService(RubocopServerService.class);
        if (rubocopServerService == null) {
            RubocopServerService.$$$reportNull$$$0(8);
        }
        return rubocopServerService;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopServerService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopServerService";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerServer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "stopModuleServers";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "stopServer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    public record RubocopServerInfo(@NotNull String serverPath, @NotNull String gemName, @Nullable String gemVersion) {
        @NotNull
        private final String serverPath;
        @NotNull
        private final String gemName;

        public RubocopServerInfo(@NotNull String serverPath, @NotNull String gemName, @Nullable String gemVersion) {
            if (serverPath == null) {
                RubocopServerInfo.$$$reportNull$$$0(0);
            }
            if (gemName == null) {
                RubocopServerInfo.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public String serverPath() {
            String string = this.serverPath;
            if (string == null) {
                RubocopServerInfo.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String gemName() {
            String string = this.gemName;
            if (string == null) {
                RubocopServerInfo.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gemName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopServerService$RubocopServerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopServerService$RubocopServerInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "serverPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "gemName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

