/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.google.gson.Gson;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopAutocorrectFix;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopOffenses;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopServerService;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.RContainerBase;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;

class RubocopResponse {
    private static final RubocopResponse EMPTY_RESPONSE = new RubocopResponse();
    private static final int OUTPUT_LOG_LIMIT = 1024;
    private static final Logger LOG = Logger.getInstance(RubocopResponse.class);
    @Nullable
    public Metadata metadata;
    @Nullable
    public List<File> files;
    @Nullable
    public Summary summary;
    public @NlsContexts.NotificationTitle @Nullable String myErrorTitle;
    public @NlsContexts.NotificationContent @Nullable String myErrorMessage;

    RubocopResponse() {
    }

    public boolean isSuccess() {
        return this.myErrorTitle == null && this.myErrorMessage == null;
    }

    @NlsContexts.NotificationContent
    @Nullable
    public String getErrorMessage() {
        return this.myErrorMessage;
    }

    @NlsContexts.NotificationTitle
    @Nullable
    public String getErrorTitle() {
        return this.myErrorTitle;
    }

    @Nullable
    public List<File> getFiles() {
        return this.files;
    }

    @NotNull
    private static RubocopResponse createErrorResponse(@NlsContexts.NotificationTitle @NotNull String errorTitle, @NlsContexts.NotificationContent @NotNull String errorMessage) {
        if (errorTitle == null) {
            RubocopResponse.$$$reportNull$$$0(0);
        }
        if (errorMessage == null) {
            RubocopResponse.$$$reportNull$$$0(1);
        }
        LOG.warn(errorTitle + "\n" + errorMessage);
        RubocopResponse response = new RubocopResponse();
        response.myErrorTitle = errorTitle;
        response.myErrorMessage = errorMessage;
        RubocopResponse rubocopResponse = response;
        if (rubocopResponse == null) {
            RubocopResponse.$$$reportNull$$$0(2);
        }
        return rubocopResponse;
    }

    @NotNull
    public static RubocopResponse computeWithArguments(@NotNull RubyGemExecutionContext context, @Nullable ProcessListener processListener) {
        RubocopResponse rubocopResponse;
        int exitCode;
        ProcessOutput processOutput;
        if (context == null) {
            RubocopResponse.$$$reportNull$$$0(3);
        }
        try {
            ExecutionModes.SameThreadMode executionMode;
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (currentIndicator instanceof ProgressWrapper) {
                if (!currentIndicator.isRunning()) {
                    currentIndicator.start();
                }
                executionMode = new ExecutionModes.SameThreadMode(true);
            } else {
                executionMode = new ExecutionModes.SameThreadMode(false);
            }
            if (processListener != null) {
                executionMode.addProcessListener(processListener);
            }
            RunnerUtil.validateSDK(context.getRubySdk());
            RubocopResponse.registerRubocopServer(context);
            processOutput = ((RubyGemExecutionContext)context.withExecutionMode((ExecutionMode)executionMode)).executeScript();
            ProgressManager.checkCanceled();
        }
        catch (ExecutionException e) {
            ProgressManager.checkCanceled();
            LOG.warn("Rubocop execution error: ", (Throwable)e);
            return RubocopResponse.createErrorResponse(RBundle.message((String)"inspection.rubocop.error"), RBundle.message((String)"inspection.rubocop.error.starting", (Object[])new Object[]{e.getMessage()}));
        }
        if (processOutput == null) {
            LOG.debug("Empty response");
            RubocopResponse rubocopResponse2 = EMPTY_RESPONSE;
            if (rubocopResponse2 == null) {
                RubocopResponse.$$$reportNull$$$0(4);
            }
            return rubocopResponse2;
        }
        if (!processOutput.isExitCodeSet()) {
            LOG.debug("Process interrupted");
            RubocopResponse rubocopResponse3 = EMPTY_RESPONSE;
            if (rubocopResponse3 == null) {
                RubocopResponse.$$$reportNull$$$0(5);
            }
            return rubocopResponse3;
        }
        String stderr = processOutput.getStderr();
        String stdout = processOutput.getStdout();
        if (RubocopUtil.containsRubocopServerStartedMessage(stdout)) {
            stdout = RubocopUtil.dropRubocopServerMessages(stdout);
        }
        if ((exitCode = processOutput.getExitCode()) != 1 && exitCode != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Rubocop returned exit code: ").append(exitCode).append("\n");
            if (StringUtil.isNotEmpty((String)stdout)) {
                sb.append("stdout:\n").append(StringUtil.trimLog((String)stdout, (int)1024)).append("\n");
            }
            if (StringUtil.isNotEmpty((String)stderr)) {
                sb.append("stderr:\n").append(StringUtil.trimLog((String)stderr, (int)1024)).append("\n");
            }
            return RubocopResponse.createErrorResponse(RBundle.message((String)"inspection.rubocop.error.code", (Object[])new Object[]{exitCode}), sb.toString());
        }
        if (StringUtil.isEmpty((String)stdout)) {
            if (StringUtil.isNotEmpty((String)stderr)) {
                return RubocopResponse.createErrorResponse(RBundle.message((String)"inspection.rubocop.error.starting.no.details"), StringUtil.trimLog((String)stderr, (int)1024));
            }
            LOG.debug("Empty output");
            RubocopResponse rubocopResponse4 = EMPTY_RESPONSE;
            if (rubocopResponse4 == null) {
                RubocopResponse.$$$reportNull$$$0(6);
            }
            return rubocopResponse4;
        }
        LOG.debug("Rubocop output: ", new Object[]{stdout});
        try {
            rubocopResponse = (RubocopResponse)new Gson().fromJson(stdout, RubocopResponse.class);
        }
        catch (Exception e) {
            return RubocopResponse.createErrorResponse(RBundle.message((String)"inspection.rubocop.error.parsing"), StringUtil.trimLog((String)stdout, (int)1024));
        }
        if (rubocopResponse == null) {
            RubocopResponse.$$$reportNull$$$0(7);
        }
        return rubocopResponse;
    }

    static void registerRubocopServer(@NotNull RubyGemExecutionContext context) {
        if (context == null) {
            RubocopResponse.$$$reportNull$$$0(8);
        }
        if (!RubocopLinterModel.containsServerFlag(context)) {
            return;
        }
        Module module = context.getModule();
        String workingDirPath = context.getWorkingDirPath();
        if (module != null && workingDirPath != null) {
            RubocopServerService.RubocopServerInfo serverInfo = new RubocopServerService.RubocopServerInfo(workingDirPath, context.getGemName(), context.getGemVersion());
            RubocopServerService.getInstance(module.getProject()).registerServer(module, serverInfo);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorResponse";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeWithArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createErrorResponse";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeWithArguments";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerRubocopServer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    static class Location {
        public int line;
        public int column;
        public int length;

        Location() {
        }

        @Nullable
        public TextRange getRangeInDocument(@NotNull Document document) {
            if (document == null) {
                Location.$$$reportNull$$$0(0);
            }
            if (this.line == 0 || document.getLineCount() < this.line || this.length == 0 || this.column == 0) {
                return null;
            }
            int lineStartOffset = document.getLineStartOffset(this.line - 1);
            return TextRange.from((int)(lineStartOffset + this.column - 1), (int)this.length);
        }

        public String toString() {
            return "Location{line=" + this.line + ", column=" + this.column + ", length=" + this.length + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Location", "getRangeInDocument"));
        }
    }

    static class Offense {
        private static final Set<String> COPS_WITH_LONG_OFFENSES = Set.of("Metrics/MethodLength", "Metrics/ModuleLength", "Metrics/ClassLength", "Metrics/BlockLength", "Metrics/AbcSize", "Metrics/CyclomaticComplexity", "Metrics/PerceivedComplexity");
        @Nullable
        public String severity;
        @Nullable
        public String message;
        @Nullable
        public String cop_name;
        @Nullable
        public Boolean corrected;
        @Nullable
        public Boolean correctable;
        @Nullable
        public Location location;

        Offense() {
        }

        public String toString() {
            return "Offense{severity='" + this.severity + "', message='" + this.message + "', cop_name='" + this.cop_name + "', corrected=" + this.corrected + ", correctable=" + this.correctable + ", location=" + String.valueOf(this.location) + "}";
        }

        @Nullable
        public String getDepartmentName() {
            int separatorIndex;
            int n = separatorIndex = this.cop_name == null ? -1 : this.cop_name.lastIndexOf(47);
            if (separatorIndex == -1) {
                return null;
            }
            return this.cop_name.substring(0, separatorIndex);
        }

        @Nullable
        public String getCopName() {
            int separatorIndex;
            int n = separatorIndex = this.cop_name == null ? -1 : this.cop_name.lastIndexOf(47);
            if (separatorIndex == -1) {
                return null;
            }
            return this.cop_name.substring(separatorIndex + 1);
        }

        @Nullable
        public String getCopFullName() {
            return this.cop_name;
        }

        private void annotateOffense(@NotNull PsiFile psiFile, @NotNull ResponseSink responseSink, @NotNull Map<String, RubocopAutocorrectFix> quickFixesHolder, @NotNull Function<? super String, ? extends HighlightSeverity> severityMapper) {
            if (psiFile == null) {
                Offense.$$$reportNull$$$0(0);
            }
            if (responseSink == null) {
                Offense.$$$reportNull$$$0(1);
            }
            if (quickFixesHolder == null) {
                Offense.$$$reportNull$$$0(2);
            }
            if (severityMapper == null) {
                Offense.$$$reportNull$$$0(3);
            }
            if (this.location == null || StringUtil.isEmpty((String)this.message)) {
                return;
            }
            Project project = psiFile.getProject();
            if (project.isDisposed()) {
                return;
            }
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (document == null) {
                return;
            }
            TextRange rangeInDocument = this.location.getRangeInDocument(document);
            if (rangeInDocument == null && this.location.line > 0) {
                rangeInDocument = new TextRange(document.getLineStartOffset(this.location.line - 1), document.getLineEndOffset(this.location.line - 1));
            }
            if (rangeInDocument == null) {
                return;
            }
            @NlsSafe String message = "RuboCop: " + StringUtil.trimStart((String)this.message, (String)(this.cop_name + ": ")) + " [" + this.cop_name + "]";
            responseSink.offenseFound(severityMapper.apply(this.severity), this.adjustRangeInDocument(psiFile, rangeInDocument), message, this.getQuickFixes(quickFixesHolder));
        }

        @NotNull
        private List<RubocopAutocorrectFix> getQuickFixes(@NotNull Map<String, RubocopAutocorrectFix> quickFixesHolder) {
            if (quickFixesHolder == null) {
                Offense.$$$reportNull$$$0(4);
            }
            String fullName = this.getCopFullName();
            if (this.correctable == Boolean.FALSE || this.correctable == null && !RubocopOffenses.CORRECTABLE_OFFENSES.contains(fullName)) {
                LOG.debug("Offense is not correctable: ", new Object[]{this});
                List<RubocopAutocorrectFix> list = Collections.emptyList();
                if (list == null) {
                    Offense.$$$reportNull$$$0(5);
                }
                return list;
            }
            LOG.debug("Creating quickfixes for: ", new Object[]{this});
            List<RubocopAutocorrectFix> list = Arrays.asList(quickFixesHolder.get(this.getDepartmentName()), quickFixesHolder.get(fullName), quickFixesHolder.get(""));
            if (list == null) {
                Offense.$$$reportNull$$$0(6);
            }
            return list;
        }

        @NotNull
        private TextRange adjustRangeInDocument(@NotNull PsiFile psiFile, @NotNull TextRange textRange) {
            if (psiFile == null) {
                Offense.$$$reportNull$$$0(7);
            }
            if (textRange == null) {
                Offense.$$$reportNull$$$0(8);
            }
            if (this.cop_name == null || !COPS_WITH_LONG_OFFENSES.contains(this.cop_name)) {
                TextRange textRange2 = textRange;
                if (textRange2 == null) {
                    Offense.$$$reportNull$$$0(9);
                }
                return textRange2;
            }
            int startOffset = textRange.getStartOffset();
            PsiElement psiLeaf = psiFile.getViewProvider().findElementAt(startOffset, (Language)RubyLanguage.INSTANCE);
            if (psiLeaf == null) {
                TextRange textRange3 = textRange;
                if (textRange3 == null) {
                    Offense.$$$reportNull$$$0(10);
                }
                return textRange3;
            }
            PsiElement namedElement = PsiTreeUtil.getParentOfType((PsiElement)psiLeaf, PsiNamedElement.class);
            if (namedElement == null || namedElement.getTextRange().getStartOffset() != startOffset) {
                TextRange textRange4 = psiLeaf.getTextRange();
                if (textRange4 == null) {
                    Offense.$$$reportNull$$$0(11);
                }
                return textRange4;
            }
            RPsiElement identifier = null;
            if (namedElement instanceof RContainerBase) {
                identifier = ((RContainerBase)namedElement).getNameElement();
            }
            TextRange textRange5 = identifier == null ? psiLeaf.getTextRange() : identifier.getTextRange();
            if (textRange5 == null) {
                Offense.$$$reportNull$$$0(12);
            }
            return textRange5;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "responseSink";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "quickFixesHolder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severityMapper";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Offense";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$Offense";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getQuickFixes";
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustRangeInDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "annotateOffense";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getQuickFixes";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustRangeInDocument";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }
    }

    static interface ResponseSink {
        public void offenseFound(@NotNull HighlightSeverity var1, @NotNull TextRange var2, @NotNull @InspectionMessage String var3, @NotNull List<? extends RubocopAutocorrectFix> var4);
    }

    static class File {
        @Nullable
        public String path;
        @Nullable
        public List<Offense> offenses;

        File() {
        }

        void annotateOffenses(@NotNull PsiFile psiFile, @NotNull ResponseSink responseSink, @NotNull RubyGemExecutionContext executionContext, @NotNull Function<? super String, ? extends HighlightSeverity> severityMapper, @NotNull RubocopLinterModel linterModel) {
            if (psiFile == null) {
                File.$$$reportNull$$$0(0);
            }
            if (responseSink == null) {
                File.$$$reportNull$$$0(1);
            }
            if (executionContext == null) {
                File.$$$reportNull$$$0(2);
            }
            if (severityMapper == null) {
                File.$$$reportNull$$$0(3);
            }
            if (linterModel == null) {
                File.$$$reportNull$$$0(4);
            }
            if (this.offenses == null || this.offenses.isEmpty()) {
                return;
            }
            Map quickFixesHolder = FactoryMap.create(it -> new RubocopAutocorrectFix(executionContext, linterModel, (String)it));
            for (Offense offense : this.offenses) {
                offense.annotateOffense(psiFile, responseSink, quickFixesHolder, severityMapper);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "responseSink";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executionContext";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "severityMapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linterModel";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopResponse$File";
            objectArray[2] = "annotateOffenses";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class Summary {
        public int offense_count;
        public int target_file_count;
        public int inspected_file_count;

        Summary() {
        }
    }

    static class Metadata {
        @Nullable
        public String rubocop_version;
        @Nullable
        public String ruby_engine;
        @Nullable
        public String ruby_version;
        @Nullable
        public String ruby_patchlevel;
        @Nullable
        public String ruby_platform;

        Metadata() {
        }
    }
}

