/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.execution.ExecutionHelper;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.VersionComparatorUtil;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemDependency;
import org.jetbrains.plugins.ruby.gem.GemInstallCommandOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallProcessOptions;
import org.jetbrains.plugins.ruby.gem.GemInstallUtil;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopResponse;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopService;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.StandardLinterModel;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubyVersionUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public class RubocopLinterModel {
    public static final String RUBOCOP_NOTIFICATION_GROUP_ID = "Rubocop.Notification";
    public static final RubocopLinterModel INSTANCE = new RubocopLinterModel();
    private static final String GEM_NAME = "rubocop";
    private static final String GEM_SCRIPT_NAME = "rubocop";
    @NonNls
    private static final String SERVER_MODE_VERSION = "1.31";
    private static final String RUBOCOP_SERVER_FLAG = "--server";
    public static final String RUBOCOP_STOP_SERVER_FLAG = "--stop-server";
    public static final String RUBOCOP_FIX_LAYOUT_FLAG = "--fix-layout";
    public static final String RUBOCOP_FORCE_EXCLUSION_FLAG = "--force-exclusion";
    public static final String RUBOCOP_AUTOCORRECT_FLAG = "-a";
    protected static final String RUBOCOP_AUTOCORRECT_ALL_FLAG = "-A";
    private static final String RUBOCOP_STDIN_FLAG = "--stdin";
    private static final String RUBOCOP_ONLY_COP_FLAG = "--only";
    private static final String RUBOCOP_FORMAT_FLAG = "--format";
    private static final String RUBOCOP_CONFIG_FILE_FLAG = "--config";
    private final SingletonNotificationManager myErrorNotificationManager = new SingletonNotificationManager("Rubocop.Notification", NotificationType.ERROR);

    protected RubocopLinterModel() {
    }

    @NotNull
    public String getGemName() {
        return "rubocop";
    }

    @NotNull
    public String getGemScriptName() {
        return "rubocop";
    }

    void installToSdk(@Nullable Module module, @NotNull Sdk sdk, @Nullable Runnable callback) {
        if (sdk == null) {
            RubocopLinterModel.$$$reportNull$$$0(0);
        }
        HashMap<GemDependency, String> errorHolder = new HashMap<GemDependency, String>();
        GemInstallCommandOptions options = new GemInstallCommandOptions().withNoDocument();
        Runnable rubocopInstaller = () -> GemInstallUtil.installGemsInBackground(sdk, module, GemDependency.anyAsList(this.getGemName()), options, GemInstallProcessOptions.installMissingOnlyAsync(errorHolder).withCallback(callback));
        if (RubyLanguageLevelService.getEffectiveLanguageLevel((Sdk)sdk).isLessThan(LanguageLevel.RUBY22)) {
            GemInstallUtil.installGemsInBackground(sdk, module, GemDependency.anyAsList("parallel"), options, GemInstallProcessOptions.installMissingOnlyAsync(errorHolder).withCallback(rubocopInstaller));
        } else {
            rubocopInstaller.run();
        }
    }

    public String toString() {
        return "Linter: " + this.getGemName();
    }

    public boolean canRunInServerMode(@Nullable String gemVersion) {
        return VersionComparatorUtil.compare((String)SERVER_MODE_VERSION, (String)gemVersion) <= 0;
    }

    @VisibleForTesting
    public boolean isServerModeCompatible(@NotNull Sdk sdk, @Nullable String gemVersion) {
        if (sdk == null) {
            RubocopLinterModel.$$$reportNull$$$0(1);
        }
        return RubocopLinterModel.isServerModeEnabled() && this.isSupportedPlatform(sdk) && this.canRunInServerMode(gemVersion);
    }

    public final boolean isSupportedPlatform(@Nullable Sdk sdk) {
        if (!RubocopLinterModel.isSupportedOS()) {
            return false;
        }
        return sdk != null && this.isSdkCompatible(sdk);
    }

    public boolean isSdkCompatible(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubocopLinterModel.$$$reportNull$$$0(2);
        }
        return !JRubySdkUtil.isJRubySDK(sdk) && !RubyRemoteInterpreterManager.isRemoteSdk(sdk) && RubyVersionUtil.isVersionGreaterOrEqual(sdk, "2.0");
    }

    @NotNull
    public final List<String> getServerArgs(@NotNull Sdk sdk, @Nullable String gemVersion) {
        if (sdk == null) {
            RubocopLinterModel.$$$reportNull$$$0(3);
        }
        if (this.isServerModeCompatible(sdk, gemVersion)) {
            List<String> list = List.of(RUBOCOP_SERVER_FLAG);
            if (list == null) {
                RubocopLinterModel.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            RubocopLinterModel.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<String> getAutocorrectArgs(@Nullable String gemVersion) {
        if (VersionComparatorUtil.compare((String)gemVersion, (String)"0.87") >= 0) {
            List<String> list = List.of(RUBOCOP_AUTOCORRECT_ALL_FLAG);
            if (list == null) {
                RubocopLinterModel.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<String> list = List.of(RUBOCOP_AUTOCORRECT_FLAG);
        if (list == null) {
            RubocopLinterModel.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<String> getCopFilterArgs(@Nullable String copFilter) {
        if (StringUtil.isNotEmpty((String)copFilter)) {
            List<String> list = List.of(RUBOCOP_ONLY_COP_FLAG, copFilter);
            if (list == null) {
                RubocopLinterModel.$$$reportNull$$$0(8);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            RubocopLinterModel.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<String> getStdInFromFileArgs(@NotNull String path) {
        if (path == null) {
            RubocopLinterModel.$$$reportNull$$$0(10);
        }
        List<String> list = List.of(RUBOCOP_STDIN_FLAG, path);
        if (list == null) {
            RubocopLinterModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<String> getJsonFormatArgs() {
        List<String> list = List.of(RUBOCOP_FORMAT_FLAG, "json");
        if (list == null) {
            RubocopLinterModel.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<String> getConfigFileArgs(@NotNull Project project, @NotNull VirtualFile root) {
        String configFilePath;
        if (project == null) {
            RubocopLinterModel.$$$reportNull$$$0(13);
        }
        if (root == null) {
            RubocopLinterModel.$$$reportNull$$$0(14);
        }
        if ((configFilePath = RubocopService.getInstance(project).getConfigFilePath()).isEmpty()) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RubocopLinterModel.$$$reportNull$$$0(15);
            }
            return list;
        }
        VirtualFile configFile = (VirtualFile)ObjectUtils.coalesce((Object)VfsUtil.findFile((Path)Path.of(configFilePath, new String[0]), (boolean)false), (Object)VfsUtil.findFile((Path)Path.of(root.getPath(), configFilePath), (boolean)false));
        if (configFile == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                RubocopLinterModel.$$$reportNull$$$0(16);
            }
            return list;
        }
        List<String> list = List.of(RUBOCOP_CONFIG_FILE_FLAG, RubocopUtil.getFilePathRelativeToRoot(configFile, root));
        if (list == null) {
            RubocopLinterModel.$$$reportNull$$$0(17);
        }
        return list;
    }

    void showRubocopError(@NotNull Project project, @NotNull RubocopResponse response) {
        if (project == null) {
            RubocopLinterModel.$$$reportNull$$$0(18);
        }
        if (response == null) {
            RubocopLinterModel.$$$reportNull$$$0(19);
        }
        String title = (String)ObjectUtils.coalesce((Object)response.getErrorTitle(), (Object)RBundle.message((String)"inspection.rubocop.error"));
        String message = response.getErrorMessage();
        this.myErrorNotificationManager.notify(title, "", project, notification -> {
            if (message != null) {
                notification.addAction(RubocopLinterModel.createDetailsAction(project, title, message));
            }
            notification.addAction(RubocopLinterModel.createDisableRubocopAction(project));
        });
    }

    @TestOnly
    public static void installRubocop(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubocopLinterModel.$$$reportNull$$$0(20);
        }
        INSTANCE.installToSdk(null, sdk, null);
    }

    @NotNull
    private static AnAction createDetailsAction(final @NotNull Project project, final @NlsContexts.TabTitle @NotNull String tabTitle, final @NotNull String errorMessage) {
        if (project == null) {
            RubocopLinterModel.$$$reportNull$$$0(21);
        }
        if (tabTitle == null) {
            RubocopLinterModel.$$$reportNull$$$0(22);
        }
        if (errorMessage == null) {
            RubocopLinterModel.$$$reportNull$$$0(23);
        }
        return new AnAction(RBundle.message((String)"inspection.rubocop.details")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExecutionHelper.showErrors((Project)project, Collections.singletonList(new Exception(errorMessage)), (String)tabTitle, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopLinterModel$1", "actionPerformed"));
            }
        };
    }

    @NotNull
    static AnAction createDisableRubocopAction(final @NotNull Project project) {
        if (project == null) {
            RubocopLinterModel.$$$reportNull$$$0(24);
        }
        return new AnAction(RBundle.message((String)"inspection.rubocop.disable")){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                Notification.get((AnActionEvent)e).expire();
                RubocopInspection.disableInspection(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopLinterModel$2", "actionPerformed"));
            }
        };
    }

    static void showRubocopError(@NlsContexts.NotificationContent @NotNull String message, AnAction ... actions) {
        if (message == null) {
            RubocopLinterModel.$$$reportNull$$$0(25);
        }
        if (actions == null) {
            RubocopLinterModel.$$$reportNull$$$0(26);
        }
        RubocopLinterModel.showRubocopError(message, Arrays.asList(actions));
    }

    static void showRubocopError(@NlsContexts.NotificationContent @NotNull String message, @NotNull List<AnAction> actions) {
        if (message == null) {
            RubocopLinterModel.$$$reportNull$$$0(27);
        }
        if (actions == null) {
            RubocopLinterModel.$$$reportNull$$$0(28);
        }
        Notification notification = new Notification(RUBOCOP_NOTIFICATION_GROUP_ID, RBundle.message((String)"inspection.rubocop.error"), message, NotificationType.ERROR);
        for (AnAction action : actions) {
            notification.addAction(action);
        }
        Notifications.Bus.notify((Notification)notification);
    }

    @NotNull
    public static RubocopLinterModel getModel(@NotNull Project project) {
        if (project == null) {
            RubocopLinterModel.$$$reportNull$$$0(29);
        }
        RubocopLinterModel rubocopLinterModel = RubocopService.getInstance(project).isUseStandard() ? StandardLinterModel.INSTANCE : INSTANCE;
        if (rubocopLinterModel == null) {
            RubocopLinterModel.$$$reportNull$$$0(30);
        }
        return rubocopLinterModel;
    }

    @NotNull
    public static RubocopLinterModel getModel(@NotNull String gemName) {
        if (gemName == null) {
            RubocopLinterModel.$$$reportNull$$$0(31);
        }
        RubocopLinterModel rubocopLinterModel = gemName.equals(StandardLinterModel.INSTANCE.getGemName()) ? StandardLinterModel.INSTANCE : INSTANCE;
        if (rubocopLinterModel == null) {
            RubocopLinterModel.$$$reportNull$$$0(32);
        }
        return rubocopLinterModel;
    }

    private static boolean isServerModeEnabled() {
        return Registry.is((String)"ruby.rubocop.server.support");
    }

    public static boolean containsServerFlag(@NotNull RubyGemExecutionContext rubocopContext) {
        if (rubocopContext == null) {
            RubocopLinterModel.$$$reportNull$$$0(33);
        }
        return rubocopContext.getArguments().contains(RUBOCOP_SERVER_FLAG);
    }

    public static boolean isSupportedOS() {
        return !SystemInfo.isWindows;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 11, 12, 15, 16, 17, 30, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopLinterModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 18: 
            case 21: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabTitle";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemName";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubocopContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopLinterModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerArgs";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutocorrectArgs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopFilterArgs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStdInFromFileArgs";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonFormatArgs";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFileArgs";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installToSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isServerModeCompatible";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSdkCompatible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getServerArgs";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 30: 
            case 32: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStdInFromFileArgs";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConfigFileArgs";
                break;
            }
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "showRubocopError";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "installRubocop";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createDetailsAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDisableRubocopAction";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getModel";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "containsServerFlag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 11, 12, 15, 16, 17, 30, 32 -> new IllegalStateException(string);
        };
    }
}

