/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopUtil;

public class RubocopInitialInformation {
    private static final Logger LOG = Logger.getInstance(RubocopInitialInformation.class);
    @NotNull
    private final Sdk mySdk;
    @NotNull
    private final VirtualFile myVirtualFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final RubocopLinterModel myLinterModel;

    RubocopInitialInformation(@NotNull Sdk sdk, @NotNull PsiFile psiFile) {
        if (sdk == null) {
            RubocopInitialInformation.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            RubocopInitialInformation.$$$reportNull$$$0(1);
        }
        this(psiFile.getProject(), Objects.requireNonNull(PsiUtilCore.getVirtualFile((PsiElement)psiFile)), sdk);
    }

    public RubocopInitialInformation(@NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull Sdk sdk) {
        if (project == null) {
            RubocopInitialInformation.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            RubocopInitialInformation.$$$reportNull$$$0(3);
        }
        if (sdk == null) {
            RubocopInitialInformation.$$$reportNull$$$0(4);
        }
        this.mySdk = sdk;
        this.myVirtualFile = virtualFile;
        this.myProject = project;
        this.myLinterModel = RubocopLinterModel.getModel(project);
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            RubocopInitialInformation.$$$reportNull$$$0(5);
        }
        return sdk;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myVirtualFile;
        if (virtualFile == null) {
            RubocopInitialInformation.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @Nullable
    public VirtualFile getLintRoot() {
        if (this.isScratchFile()) {
            return this.getProject().getBaseDir();
        }
        VirtualFile virtualFile = this.getVirtualFile();
        VirtualFile contentRoot = ProjectFileIndex.getInstance((Project)this.getProject()).getContentRootForFile(virtualFile, false);
        return contentRoot == null ? virtualFile.getParent() : contentRoot;
    }

    @Nullable
    public RubyGemExecutionContext getGemExecutionContext() {
        return this.getGemExecutionContext(RubocopLinterModel.getModel(this.myProject).getJsonFormatArgs());
    }

    @Nullable
    public RubyGemExecutionContext getGemExecutionContext(@NotNull @NotNull List<@NotNull String> baseArguments) {
        if (baseArguments == null) {
            RubocopInitialInformation.$$$reportNull$$$0(7);
        }
        return (RubyGemExecutionContext)ReadAction.compute(() -> {
            RubocopLinterModel model = RubocopLinterModel.getModel(this.myProject);
            Module module = this.getModule();
            RubyGemExecutionContext executionContext = RubocopUtil.getExecutionContext(module, this.mySdk, model.getGemName());
            if (executionContext == null) {
                LOG.debug("Could not create a gem execution context");
                return null;
            }
            VirtualFile root = this.getLintRoot();
            ArrayList<String> arguments = new ArrayList<String>(baseArguments);
            arguments.add("--force-exclusion");
            arguments.addAll(model.getStdInFromFileArgs(this.getFileName()));
            arguments.addAll(model.getServerArgs(this.mySdk, executionContext.getGemVersion()));
            if (root != null) {
                arguments.addAll(model.getConfigFileArgs(this.getProject(), root));
            }
            LOG.debug("Gem execution context arguments: ", new Object[]{arguments});
            RubyGemExecutionContext context = (RubyGemExecutionContext)((RubyGemExecutionContext)((RubyGemExecutionContext)executionContext.withWorkingDir(this.getLintRoot())).withGemScriptName(model.getGemScriptName()).withModule(module)).withArguments(arguments);
            LOG.debug("Gem execution context: ", new Object[]{context});
            return context;
        });
    }

    @NotNull
    public String getFileName() {
        if (this.isScratchFile()) {
            return "scratch.rb";
        }
        String string = RubocopUtil.getFilePathRelativeToRoot(this.getVirtualFile(), this.getLintRoot());
        if (string == null) {
            RubocopInitialInformation.$$$reportNull$$$0(8);
        }
        return string;
    }

    private boolean isScratchFile() {
        return ScratchUtil.isScratch((VirtualFile)this.getVirtualFile());
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            RubocopInitialInformation.$$$reportNull$$$0(9);
        }
        return project;
    }

    @NotNull
    public RubocopLinterModel getLinterModel() {
        RubocopLinterModel rubocopLinterModel = this.myLinterModel;
        if (rubocopLinterModel == null) {
            RubocopInitialInformation.$$$reportNull$$$0(10);
        }
        return rubocopLinterModel;
    }

    public boolean isValid() {
        return (Boolean)ReadAction.compute(() -> ((VirtualFile)this.myVirtualFile).isValid());
    }

    public byte[] getSourceFileBytes() {
        String documentText = this.getDocument().getText();
        String lineSeparator = FileDocumentManager.getInstance().getLineSeparator(this.getVirtualFile(), this.getProject());
        if (!lineSeparator.equals("\n")) {
            documentText = StringUtil.convertLineSeparators((String)documentText, (String)lineSeparator);
        }
        return documentText.getBytes(this.getVirtualFile().getCharset());
    }

    @Nullable
    public Module getModule() {
        return ModuleUtilCore.findModuleForFile((VirtualFile)this.myVirtualFile, (Project)this.myProject);
    }

    @NotNull
    public Document getDocument() {
        Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
        LOG.assertTrue(document != null);
        Document document2 = document;
        if (document2 == null) {
            RubocopInitialInformation.$$$reportNull$$$0(11);
        }
        return document2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopInitialInformation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopInitialInformation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinterModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGemExecutionContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

