/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.lang.GlobalInspectionContextExtension;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.gem.bundler.BundlerGemInfrastructure;
import org.jetbrains.plugins.ruby.gem.bundler.actions.AbstractBundlerAction;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopFileResultDescriptor;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopResponse;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;

final class RubocopGlobalInspectionContext
implements GlobalInspectionContextExtension<RubocopGlobalInspectionContext> {
    private static final Logger LOG = Logger.getInstance(RubocopGlobalInspectionContext.class);
    static final Key<RubocopGlobalInspectionContext> ID = Key.create((String)"RubocopGlobalInspectionContext");
    private final Map<String, RubocopFileResultDescriptor> myFilesCache = new HashMap<String, RubocopFileResultDescriptor>();
    private final Set<Sdk> myPotentialSdk = new HashSet<Sdk>();
    @Nullable
    private RubyGemExecutionContext myContextToUse;
    @Nullable
    private RubocopResponse myStopResponse;
    @Nullable
    private RubocopLinterModel myLinterModel;

    RubocopGlobalInspectionContext() {
    }

    @NotNull
    public Key<RubocopGlobalInspectionContext> getID() {
        Key<RubocopGlobalInspectionContext> key = ID;
        if (key == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void performPreRunActivities(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        Set<VirtualFile> rootsToLint;
        if (globalTools == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(1);
        }
        if (localTools == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(2);
        }
        if (context == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(3);
        }
        Project project = context.getProject();
        if (!(context instanceof GlobalInspectionContextImpl)) {
            LOG.debug("Wrong context");
            return;
        }
        Map tools = ((GlobalInspectionContextImpl)context).getTools();
        Tools rubocopTool = (Tools)tools.get(RubocopInspection.SHORT_NAME);
        if (rubocopTool == null) {
            LOG.debug("No rubocop selected");
            return;
        }
        this.myLinterModel = RubocopLinterModel.getModel(context.getProject());
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        if (application.isSaveAllowed()) {
            application.invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
        }
        if ((rootsToLint = this.collectRootsToLint((GlobalInspectionContextImpl)context)).isEmpty()) {
            LOG.debug("No roots to lint");
            return;
        }
        if (this.myContextToUse == null) {
            Module module = (Module)ReadAction.compute(() -> ModuleUtilCore.findModuleForFile((VirtualFile)((VirtualFile)rootsToLint.iterator().next()), (Project)project));
            this.sdkNotFound(project, module);
            return;
        }
        RubocopInspection rubocopInspection = RubocopInspection.from(rubocopTool);
        assert (rubocopInspection != null) : "Rubocop missing in " + String.valueOf(rubocopTool);
        this.preLintRoots((GlobalInspectionContextImpl)context, rootsToLint, rubocopInspection.getSeveritiesMap());
        if (this.myLinterModel != null && this.myStopResponse != null) {
            this.myLinterModel.showRubocopError(project, this.myStopResponse);
        }
    }

    @NotNull
    RubocopLinterModel getLinterModel() {
        RubocopLinterModel rubocopLinterModel = Objects.requireNonNull(this.myLinterModel, "This method should not be invoked before performPreRunActivities");
        if (rubocopLinterModel == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(4);
        }
        return rubocopLinterModel;
    }

    private void sdkNotFound(final @NotNull Project project, final @Nullable Module module) {
        String message;
        if (project == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(5);
        }
        final RubocopLinterModel model = this.getLinterModel();
        String gem = model.getGemName();
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        if (BundlerUtil.hasGemfile(module)) {
            boolean hasMissingGems;
            VirtualFile gemfile = BundlerUtil.getGemfile(module);
            boolean bl = hasMissingGems = gemfile != null && BundlerGemInfrastructure.hasMissingGems(gemfile);
            if (!hasMissingGems) {
                message = RBundle.message((String)"inspection.rubocop.run.no.gem", (Object[])new Object[]{gem});
                actions.add((AnAction)new DumbAwareAction(RBundle.message((String)"inspection.rubocop.run.no.gem.action.title")){

                    public void actionPerformed(@NotNull AnActionEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        RubocopUtil.addRubocopToGemfile(project, module, model);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopGlobalInspectionContext$1", "actionPerformed"));
                    }
                });
            } else {
                message = RBundle.message((String)"inspection.rubocop.run.bundle.install", (Object[])new Object[]{gem});
                actions.add((AnAction)new DumbAwareAction(RBundle.message((String)"inspection.rubocop.run.bundle.install.action.title")){

                    public void actionPerformed(@NotNull AnActionEvent event) {
                        AbstractBundlerAction action;
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if ((action = (AbstractBundlerAction)((Object)ObjectUtils.tryCast((Object)ActionManager.getInstance().getAction("org.jetbrains.plugins.ruby.gem.bundler.actions.RunBundlerInstallAction"), AbstractBundlerAction.class))) != null) {
                            action.runBundlerAction(module);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopGlobalInspectionContext$2", "actionPerformed"));
                    }
                });
            }
        } else if (module != null) {
            message = RBundle.message((String)"inspection.rubocop.run.install.gem", (Object[])new Object[]{gem});
            for (final Sdk potentialSdk : this.myPotentialSdk) {
                actions.add((AnAction)new DumbAwareAction(RBundle.message((String)"inspection.rubocop.run.install.gem.action.title", (Object[])new Object[]{potentialSdk.getName()})){

                    public void actionPerformed(@NotNull AnActionEvent event) {
                        if (event == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        if (!module.isDisposed()) {
                            model.installToSdk(module, potentialSdk, null);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopGlobalInspectionContext$3", "actionPerformed"));
                    }
                });
            }
        } else {
            message = RBundle.message((String)"inspection.rubocop.run.fallback", (Object[])new Object[]{gem});
        }
        RubocopLinterModel.showRubocopError(message, actions);
    }

    @NotNull
    private Set<VirtualFile> collectRootsToLint(GlobalInspectionContextImpl context) {
        LinkedHashSet<VirtualFile> rootsToLint = new LinkedHashSet<VirtualFile>();
        context.getCurrentScope().accept(virtualFile -> {
            VirtualFile containingDir;
            if (!FileTypeRegistry.getInstance().isFileOfType(virtualFile, (FileType)RubyFileType.RUBY)) {
                return true;
            }
            if (this.myContextToUse == null) {
                ReadAction.run(() -> this.tryToChooseSdk(context.getProject(), (VirtualFile)virtualFile));
            }
            if (rootsToLint.contains(containingDir = virtualFile.getParent())) {
                return true;
            }
            Iterator iterator = rootsToLint.iterator();
            while (iterator.hasNext()) {
                VirtualFile root = (VirtualFile)iterator.next();
                if (VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)containingDir, (boolean)true)) {
                    return true;
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)containingDir, (VirtualFile)root, (boolean)true)) continue;
                iterator.remove();
            }
            rootsToLint.add(containingDir);
            return true;
        });
        LinkedHashSet<VirtualFile> linkedHashSet = rootsToLint;
        if (linkedHashSet == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(6);
        }
        return linkedHashSet;
    }

    private void preLintRoots(@NotNull GlobalInspectionContextImpl context, @NotNull Set<VirtualFile> rootsToLint, @NotNull Map<String, String> severitiesMap) {
        if (context == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(7);
        }
        if (rootsToLint == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(8);
        }
        if (severitiesMap == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(9);
        }
        if (this.myContextToUse == null) {
            return;
        }
        Project project = context.getProject();
        Sdk sdk = this.myContextToUse.getRubySdk();
        String gemVersion = this.myContextToUse.getGemVersion();
        RubocopLinterModel model = this.getLinterModel();
        for (VirtualFile rootToLint : rootsToLint) {
            LOG.debug("Linting " + String.valueOf(rootToLint));
            String pathToLint = null;
            ArrayList<String> arguments = new ArrayList<String>(model.getJsonFormatArgs());
            arguments.addAll(model.getServerArgs(sdk, gemVersion));
            VirtualFile workingDir = (VirtualFile)ReadAction.compute(() -> ProjectFileIndex.getInstance((Project)project).getContentRootForFile(rootToLint));
            if (workingDir != null) {
                pathToLint = VfsUtilCore.getRelativePath((VirtualFile)rootToLint, (VirtualFile)workingDir);
            } else {
                workingDir = rootToLint;
            }
            arguments.addAll(model.getConfigFileArgs(project, workingDir));
            if (StringUtil.isNotEmpty((String)pathToLint)) {
                arguments.add(pathToLint);
            }
            context.incrementJobDoneAmount(context.getStdJobDescriptors().LOCAL_ANALYSIS_ARRAY[0], pathToLint == null ? "" : pathToLint);
            RubocopResponse response = RubocopResponse.computeWithArguments((RubyGemExecutionContext)((RubyGemExecutionContext)new RubyGemExecutionContext(this.myContextToUse).withWorkingDirPath(RubySdkUtil.convertToRemote(sdk, this.myContextToUse.getModule(), workingDir.getPath()))).withArguments(arguments), null);
            if (!response.isSuccess()) {
                this.myStopResponse = response;
                LOG.debug("Non-success response: ", new Object[]{response.getErrorMessage()});
                return;
            }
            List<RubocopResponse.File> files = response.getFiles();
            if (files == null) {
                LOG.debug("No files in response");
                continue;
            }
            LOG.debug("Got files " + files.size() + " in response");
            for (RubocopResponse.File fileInfo : files) {
                String resultingFileCanonicalPath;
                VirtualFile resultingFile;
                if (StringUtil.isEmpty((String)fileInfo.path) || (resultingFile = workingDir.findFileByRelativePath(fileInfo.path)) == null || !StringUtil.isNotEmpty((String)(resultingFileCanonicalPath = resultingFile.getCanonicalPath()))) continue;
                RubyGemExecutionContext rubocopContext = (RubyGemExecutionContext)new RubyGemExecutionContext(this.myContextToUse).withWorkingDir(workingDir);
                this.myFilesCache.put(resultingFileCanonicalPath, new RubocopFileResultDescriptor(fileInfo, rubocopContext, severitiesMap, model));
            }
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("ruby.rubocop.check.manual");
    }

    private void tryToChooseSdk(@NotNull Project project, @NotNull VirtualFile rubyFile) {
        Sdk sdk;
        if (project == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(10);
        }
        if (rubyFile == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(11);
        }
        if ((sdk = RubySdkUtil.getFileSdk(project, rubyFile)) == null) {
            return;
        }
        RubocopLinterModel model = this.getLinterModel();
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)rubyFile, (Project)project);
        if (BundlerUtil.hasGemfile(module)) {
            boolean hasMissingGems;
            VirtualFile gemfile = BundlerUtil.getGemfile(module);
            boolean bl = hasMissingGems = gemfile != null && BundlerGemInfrastructure.hasMissingGems(gemfile);
            if (!hasMissingGems) {
                this.myContextToUse = RubyGemExecutionContext.tryCreate(null, module, model.getGemName());
            }
        } else {
            this.myContextToUse = RubyGemExecutionContext.tryCreate(sdk, module, model.getGemName());
        }
        if (this.myContextToUse != null) {
            this.myContextToUse = this.myContextToUse.withGemScriptName(model.getGemScriptName());
        } else if (model.isSdkCompatible(sdk)) {
            this.myPotentialSdk.add(sdk);
        }
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper<?, ?>> inspections, @NotNull GlobalInspectionContext context) {
        if (inspections == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(12);
        }
        if (context == null) {
            RubocopGlobalInspectionContext.$$$reportNull$$$0(13);
        }
    }

    public void cleanup() {
    }

    boolean shouldStop() {
        return this.myContextToUse == null || this.myStopResponse != null;
    }

    @Nullable
    RubocopFileResultDescriptor getFileResult(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return null;
        }
        return this.myFilesCache.get(virtualFile.getCanonicalPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopGlobalInspectionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToLint";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severitiesMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopGlobalInspectionContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinterModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRootsToLint";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performPreRunActivities";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sdkNotFound";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "preLintRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToChooseSdk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performPostRunActivities";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

