/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.resolve;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.InspectionResult;
import org.jetbrains.plugins.ruby.rails.inspections.paramdefs.VisibilityInspectionResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.ParamDef;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.MatchResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.paramDefs.matcher.ParamDefMatcher;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.accessmodifier.AccessModifierProblem;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.CoreFqns;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class InvalidCallToProtectedPrivateMethodInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InvalidCallToProtectedPrivateMethodInspection.$$$reportNull$$$0(0);
        }
        return new Visitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/resolve/InvalidCallToProtectedPrivateMethodInspection", "buildVisitor"));
    }

    private static final class Visitor
    extends RubyInspectionVisitor {
        private Visitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRSymbol(@NotNull RSymbol rSymbol) {
            if (rSymbol == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitMethodRef((PsiElement)rSymbol);
        }

        public void visitRStringLiteral(@NotNull RStringLiteral rStringLiteral) {
            if (rStringLiteral == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (rStringLiteral.getParent() instanceof RSymbol) {
                return;
            }
            this.visitMethodRef((PsiElement)rStringLiteral);
        }

        public void visitRDStringLiteral(@NotNull RStringLiteral rDStringLiteral) {
            if (rDStringLiteral == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (rDStringLiteral.getParent() instanceof RSymbol) {
                return;
            }
            this.visitMethodRef((PsiElement)rDStringLiteral);
        }

        public void visitRBinaryExpression(@NotNull RBinaryExpression rBinaryExpression) {
            Symbol symbol;
            if (rBinaryExpression == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (!((symbol = ResolveUtil.resolveToSymbolWithCaching(rBinaryExpression.getReference())) instanceof RMethodSymbol)) {
                return;
            }
            this.visitCall(rBinaryExpression.getOperation(), (PsiElement)rBinaryExpression, (RMethodSymbol)symbol, rBinaryExpression.getLeftOperand());
        }

        public void visitRIdentifier(@NotNull RIdentifier identifier) {
            RReference dotReference;
            RReference fullyQualifiedCall;
            Symbol symbol;
            if (identifier == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            if (!((symbol = ResolveUtil.resolveToSymbolWithCaching((fullyQualifiedCall = (dotReference = (RReference)Optional.ofNullable((RReference)PsiTreeUtil.getParentOfType((PsiElement)identifier, RReference.class)).filter(it -> it.getValue() == identifier).orElse(null)) != null ? dotReference : identifier).getReference())) instanceof RMethodSymbol) || "initialize".equals(symbol.getName()) && identifier.isConstructorLike()) {
                return;
            }
            this.visitCall((PsiElement)identifier, (PsiElement)fullyQualifiedCall, (RMethodSymbol)symbol, dotReference != null ? dotReference.getReceiver() : null);
        }

        private void visitCall(@NotNull PsiElement whereRegisterProblem, @NotNull PsiElement fullyQualifiedCall, @NotNull RMethodSymbol resolvedSymbol, @Nullable RPsiElement explicitReceiver) {
            if (whereRegisterProblem == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            if (fullyQualifiedCall == null) {
                Visitor.$$$reportNull$$$0(7);
            }
            if (resolvedSymbol == null) {
                Visitor.$$$reportNull$$$0(8);
            }
            if (CoreFqns.KERNEL.equals(resolvedSymbol.getFQNWithNesting().getCallerFQN())) {
                return;
            }
            RType implicitReceiverType = RTypeUtil.getTypeForSelf(fullyQualifiedCall);
            AccessModifierProblem problem = AccessModifierProblem.calculateAccessModifierProblem(resolvedSymbol, implicitReceiverType, RTypeUtil.getType((PsiElement)explicitReceiver), explicitReceiver);
            if (problem != null) {
                String message = RBundle.message((String)"inspection.invalid.call.to.protected.private.method.warning.text", (Object[])new Object[]{resolvedSymbol.getVisibility().getPresentableName(), whereRegisterProblem.getText()});
                this.myHolder.registerProblem(whereRegisterProblem, message, problem.createQuickFixes(fullyQualifiedCall).toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private void visitMethodRef(@NotNull PsiElement methodRef) {
            MatchResult match;
            if (methodRef == null) {
                Visitor.$$$reportNull$$$0(9);
            }
            if ((match = ParamDefMatcher.match(methodRef)) == null) {
                return;
            }
            ParamDef paramDef = match.getParamDef();
            VisibilityInspectionResult result = paramDef.inspectVisibility(match.getContext());
            if (result.getType() != InspectionResult.Type.OK) {
                String message = RBundle.message((String)"inspection.invalid.call.to.protected.private.method.visibility.violation", (Object[])new Object[]{result.getMinAllowedVisibility().getPresentableName(), result.getActualVisibility().getPresentableName()});
                this.myHolder.registerProblem(result.getAffectedPsiElement(), message, result.getQuickFixes());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rSymbol";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rStringLiteral";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rDStringLiteral";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rBinaryExpression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "whereRegisterProblem";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fullyQualifiedCall";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedSymbol";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodRef";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/resolve/InvalidCallToProtectedPrivateMethodInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRSymbol";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRStringLiteral";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRDStringLiteral";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRBinaryExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIdentifier";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCall";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodRef";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

