/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.resolve;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LazyInitializer;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.ContextImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public class CreateRubyMethodFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(CreateRubyMethodFix.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final SmartPsiElementPointer<RPsiElement> myLocation;
    private final LazyInitializer.LazyValue<SmartPsiElementPointer<RCompoundStatement>> myCompoundStatement;
    private final String myMethodName;
    private final ContextImpl myContext;
    private final Visibility myVisibility;

    public CreateRubyMethodFix(@NotNull Project project, @Nullable RPsiElement location, @NotNull LazyInitializer.LazyValue<SmartPsiElementPointer<RCompoundStatement>> cmpSt, String methodName, ContextImpl context, Visibility visibility) {
        if (project == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(0);
        }
        if (cmpSt == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myMethodName = methodName;
        this.myContext = context;
        this.myVisibility = visibility;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        this.myLocation = location == null ? null : smartPointerManager.createSmartPsiElementPointer((PsiElement)location);
        this.myCompoundStatement = cmpSt;
    }

    public CreateRubyMethodFix(@NotNull Project project, @Nullable RPsiElement location, @NotNull RContainer rContainer, String methodName, ContextImpl context, Visibility visibility) {
        if (project == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(2);
        }
        if (rContainer == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(3);
        }
        this(project, location, CreateRubyMethodFix.getLazyCompoundStatement(project, rContainer), methodName, context, visibility);
    }

    public CreateRubyMethodFix(@NotNull Project project, @Nullable RPsiElement location, @NotNull RCompoundStatement cmpSt, String methodName, ContextImpl context, Visibility visibility) {
        if (project == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(4);
        }
        if (cmpSt == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(5);
        }
        this(project, location, CreateRubyMethodFix.getLazyCompoundStatement(project, cmpSt), methodName, context, visibility);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull LazyInitializer.LazyValue<SmartPsiElementPointer<@Nullable RCompoundStatement>> getLazyCompoundStatement(@NotNull Project project, @NotNull RContainer container) {
        if (project == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(6);
        }
        if (container == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(7);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        SmartPsiElementPointer containerPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)container);
        LazyInitializer.LazyValue lazyValue = LazyInitializer.create(() -> {
            RContainer originalContainer = (RContainer)containerPointer.getElement();
            if (originalContainer == null) {
                return null;
            }
            return smartPointerManager.createSmartPsiElementPointer((PsiElement)originalContainer.getCompoundStatement());
        });
        if (lazyValue == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(8);
        }
        return lazyValue;
    }

    @NotNull
    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull LazyInitializer.LazyValue<SmartPsiElementPointer<@NotNull RCompoundStatement>> getLazyCompoundStatement(@NotNull Project project, @NotNull RCompoundStatement compoundStatement) {
        if (project == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(9);
        }
        if (compoundStatement == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(10);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        SmartPsiElementPointer containerPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)compoundStatement);
        LazyInitializer.LazyValue lazyValue = LazyInitializer.create(() -> containerPointer);
        if (lazyValue == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(11);
        }
        return lazyValue;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        RCompoundStatement compoundStatement;
        if (target == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(12);
        }
        if ((compoundStatement = (RCompoundStatement)((SmartPsiElementPointer)this.myCompoundStatement.get()).dereference()) == null) {
            LOG.debug("Unable to find compound statement in the element");
            return null;
        }
        if (!target.getOriginalFile().equals(compoundStatement.getContainingFile())) {
            return null;
        }
        RCompoundStatement compoundStatementElement = (RCompoundStatement)PsiTreeUtil.findSameElementInCopy((PsiElement)compoundStatement, (PsiFile)target);
        RPsiElement newLocation = this.myLocation == null ? null : (RPsiElement)PsiTreeUtil.findSameElementInCopy((PsiElement)((RPsiElement)this.myLocation.getElement()), (PsiFile)target);
        return new CreateRubyMethodFix(this.myProject, newLocation, compoundStatementElement, this.myMethodName, this.myContext, this.myVisibility);
    }

    @NotNull
    public String getName() {
        String string = RBundle.message((String)"ruby.action.create.new.method.fix.name", (Object[])new Object[]{this.myMethodName});
        if (string == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.action.create.new.method.fix.familyName");
        if (string == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        RMethod prevMethod;
        RPsiElement location;
        RCompoundStatement cmpSt;
        if (project == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(15);
        }
        if (descriptor == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(16);
        }
        if ((cmpSt = (RCompoundStatement)((SmartPsiElementPointer)this.myCompoundStatement.get()).getElement()) == null || !cmpSt.isValid()) {
            return;
        }
        if (this.myLocation != null) {
            location = (RPsiElement)this.myLocation.getElement();
            if (location == null || !location.isValid()) {
                return;
            }
        } else {
            location = null;
            assert (this.myContext != null);
        }
        ContextImpl context = this.myContext != null ? this.myContext : ContextImpl.getContext((PsiElement)location);
        StringBuilder builder2 = new StringBuilder();
        builder2.append("def ");
        if (CreateRubyMethodFix.shouldBeStaticMethod(location, context)) {
            builder2.append("self.");
        }
        builder2.append(this.myMethodName);
        if (!(location instanceof RSymbol)) {
            CreateRubyMethodFix.buildArguments(project, builder2, (PsiElement)location);
        }
        String methodText = builder2.append("\n  # code here\nend").toString();
        RMethod method = (RMethod)RubyElementFactoryCore.createElementFromText((PsiElement)cmpSt, (String)methodText);
        if (location != null && PsiTreeUtil.isAncestor((PsiElement)cmpSt, (PsiElement)location, (boolean)false)) {
            PsiElement anchor = PsiTreeUtil.findPrevParent((PsiElement)cmpSt, (PsiElement)location);
            method = (RMethod)cmpSt.addBefore((PsiElement)method, anchor);
        } else {
            method = (RMethod)cmpSt.add((PsiElement)method);
        }
        if (!(this.myVisibility == null || (prevMethod = (RMethod)PsiTreeUtil.getPrevSiblingOfType((PsiElement)method, RMethod.class)) != null && prevMethod.getVisibility().equals((Object)this.myVisibility))) {
            RPsiElement visibilityElement = RubyElementFactoryCore.createElementFromText((PsiElement)cmpSt, (String)this.myVisibility.getPresentableName());
            cmpSt.addBefore((PsiElement)visibilityElement, (PsiElement)method);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            method = (RMethod)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)method);
            TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)method);
            for (RArgument argument : method.getArguments()) {
                templateBuilder.replaceElement((PsiElement)argument, argument.getText());
            }
            PsiComment psiComment = (PsiComment)PsiTreeUtil.getChildOfType((PsiElement)method, PsiComment.class);
            if (psiComment != null) {
                templateBuilder.replaceElement((PsiElement)psiComment, psiComment.getText());
                Editor editor = PsiEditorUtil.findEditor((PsiElement)psiComment);
                if (editor != null) {
                    templateBuilder.run(editor, false);
                }
            }
        }
    }

    @Nullable
    public static RCompoundStatement getClosestApplicableEnclosingCompoundStatementForFix(@NotNull PsiElement element) {
        if (element == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(17);
        }
        PsiElement currentElement = element;
        while (currentElement != null) {
            RCompoundStatement enclosingCompoundStatement = (RCompoundStatement)PsiTreeUtil.getParentOfType((PsiElement)currentElement, RCompoundStatement.class);
            if (enclosingCompoundStatement != null && CreateRubyMethodFix.isApplicableCompoundStatementForFix(enclosingCompoundStatement)) {
                return enclosingCompoundStatement;
            }
            currentElement = enclosingCompoundStatement;
        }
        return null;
    }

    public static boolean isApplicableCompoundStatementForFix(@NotNull RCompoundStatement compoundStatement) {
        PsiElement parent;
        if (compoundStatement == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(18);
        }
        if ((parent = compoundStatement.getParent()) instanceof RBodyStatement) {
            parent = parent.getParent();
        }
        if (parent instanceof RCodeBlock) {
            return true;
        }
        return parent instanceof RFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldBeStaticMethod(@Nullable RPsiElement location, @NotNull ContextImpl context) {
        boolean inSomeRubyDSL;
        if (context == null) {
            CreateRubyMethodFix.$$$reportNull$$$0(19);
        }
        boolean bl = inSomeRubyDSL = location != null && !(location instanceof RReference) && RubyPsiUtilCore.getContainingRClassOrModule((PsiElement)location) == null;
        if (inSomeRubyDSL) {
            RMethod containingMethod = (RMethod)PsiTreeUtil.getParentOfType((PsiElement)location, RMethod.class);
            if (containingMethod == null) return false;
            if (!(containingMethod instanceof RSingletonMethod)) return false;
            return true;
        }
        if (context.getAccess().acceptInstance()) return false;
        return true;
    }

    private static void buildArguments(Project project, StringBuilder builder2, PsiElement location) {
        RCall call = (RCall)PsiTreeUtil.getParentOfType((PsiElement)location, RCall.class);
        if (call != null && call.getPsiCommand() == location) {
            Object argName = "i";
            int count = 0;
            List args = call.getArguments();
            HashSet<Object> usedArgNames = new HashSet<Object>();
            if (!args.isEmpty()) {
                RubyCodeStyleSettings settings = RubyCodeStyleSettings.getInstance((PsiElement)location);
                boolean generateParenthesesAroundArguments = settings.PARENTHESES_AROUND_METHOD_ARGUMENTS;
                char open = generateParenthesesAroundArguments ? (char)'(' : ' ';
                char close = generateParenthesesAroundArguments ? (char)')' : ' ';
                builder2.append(open);
                for (RPsiElement arg : args) {
                    if (count > 0) {
                        builder2.append(", ");
                    }
                    if (arg instanceof RAssoc) {
                        argName = ((RAssoc)arg).getKeyText() + ":";
                        if (LanguageLevel.RUBY21.isGreaterThan(arg.getLanguageLevel())) {
                            argName = (String)argName + " nil";
                        }
                    } else if (arg instanceof RIdentifier && !usedArgNames.contains(arg.getText())) {
                        argName = arg.getText();
                    } else if (arg instanceof RField && !usedArgNames.contains(arg.getName())) {
                        argName = arg.getName();
                    }
                    builder2.append((String)argName);
                    usedArgNames.add(argName);
                    argName = "i" + ++count;
                }
                builder2.append(close);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmpSt";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rContainer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/resolve/CreateRubyMethodFix";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compoundStatement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/resolve/CreateRubyMethodFix";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyCompoundStatement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLazyCompoundStatement";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getClosestApplicableEnclosingCompoundStatementForFix";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableCompoundStatementForFix";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeStaticMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

