/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.resolve;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Properties;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class CreateRubyClassFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance(CreateRubyClassFix.class);
    private final boolean myCreateAsInner;

    public CreateRubyClassFix(boolean createAsInner) {
        this.myCreateAsInner = createAsInner;
    }

    @NotNull
    public String getName() {
        String string = RBundle.message((String)(this.myCreateAsInner ? "ruby.action.create.new.class.fix.as.inner.name" : "ruby.action.create.new.class.fix.name"));
        if (string == null) {
            CreateRubyClassFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = RBundle.message((String)"ruby.action.create.new.class.familyName");
        if (string == null) {
            CreateRubyClassFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        PsiFile file;
        PsiDirectory currentDirectory;
        if (project == null) {
            CreateRubyClassFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            CreateRubyClassFix.$$$reportNull$$$0(3);
        }
        if ((currentDirectory = (file = (element = descriptor.getPsiElement()).getContainingFile()).getContainingDirectory()) == null) {
            return;
        }
        if (element instanceof RConstant) {
            RConstant constantElement = (RConstant)element;
            String name = constantElement.getName();
            if (name == null) {
                return;
            }
            if (!this.myCreateAsInner) {
                FileChooserDescriptor chooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                chooserDescriptor.setRoots(new VirtualFile[]{project.getBaseDir()});
                chooserDescriptor.withTreeRootVisible(true);
                VirtualFile selectedDir = FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Project)project, null);
                if (selectedDir == null) {
                    return;
                }
                CreateRubyClassFix.createRClassWriteAction(project, name, () -> CreateRubyClassFix.createRClassInNewFile(project, name, selectedDir));
            } else {
                CreateRubyClassFix.createRClassWriteAction(project, name, () -> CreateRubyClassFix.createRClassInCurrentFile(name, file));
            }
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        PsiElement element;
        if (project == null) {
            CreateRubyClassFix.$$$reportNull$$$0(4);
        }
        if (previewDescriptor == null) {
            CreateRubyClassFix.$$$reportNull$$$0(5);
        }
        if ((element = previewDescriptor.getStartElement()) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CreateRubyClassFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }
        if (element instanceof RConstant) {
            RConstant constantElement = (RConstant)element;
            String name = constantElement.getName();
            if (name == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    CreateRubyClassFix.$$$reportNull$$$0(7);
                }
                return intentionPreviewInfo;
            }
            PsiFile file = element.getContainingFile();
            RClass rClass = (RClass)WriteCommandAction.writeCommandAction((Project)project).compute(() -> CreateRubyClassFix.createRClassInCurrentFile(name, file));
            if (rClass == null) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    CreateRubyClassFix.$$$reportNull$$$0(8);
                }
                return intentionPreviewInfo;
            }
            return new IntentionPreviewInfo.CustomDiff((FileType)RubyFileType.RUBY, "", CreateRubyClassFix.getNewClassText(name));
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            CreateRubyClassFix.$$$reportNull$$$0(9);
        }
        return intentionPreviewInfo;
    }

    private static void createRClassWriteAction(@NotNull Project project, @NotNull String name, @NotNull Supplier<RClass> createRClassSupplier) {
        if (project == null) {
            CreateRubyClassFix.$$$reportNull$$$0(10);
        }
        if (name == null) {
            CreateRubyClassFix.$$$reportNull$$$0(11);
        }
        if (createRClassSupplier == null) {
            CreateRubyClassFix.$$$reportNull$$$0(12);
        }
        WriteCommandAction.writeCommandAction((Project)project).withName(RBundle.message((String)"ruby.action.create.new.class.action.name", (Object[])new Object[]{name})).run(() -> {
            RClass aClass = (RClass)createRClassSupplier.get();
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            if (aClass != null && aClass.isValid()) {
                aClass.navigate(true);
            }
        });
    }

    @Nullable
    private static RClass createRClassInCurrentFile(@NotNull String name, @NotNull PsiFile currentFile) {
        RPsiElement element;
        RClass rClass;
        if (name == null) {
            CreateRubyClassFix.$$$reportNull$$$0(13);
        }
        if (currentFile == null) {
            CreateRubyClassFix.$$$reportNull$$$0(14);
        }
        return (rClass = (RClass)PsiTreeUtil.findChildOfType((PsiElement)(element = RubyElementFactoryCore.createElementFromText((PsiElement)currentFile, (String)CreateRubyClassFix.getNewClassText(name))), RClass.class, (boolean)false)) != null ? (RClass)currentFile.add((PsiElement)rClass) : null;
    }

    @Nullable
    private static RClass createRClassInNewFile(@NotNull Project project, @NotNull String name, @NotNull VirtualFile selectedDir) {
        if (project == null) {
            CreateRubyClassFix.$$$reportNull$$$0(15);
        }
        if (name == null) {
            CreateRubyClassFix.$$$reportNull$$$0(16);
        }
        if (selectedDir == null) {
            CreateRubyClassFix.$$$reportNull$$$0(17);
        }
        FileTemplate rubyClassTemplate = FileTemplateManager.getInstance((Project)project).getInternalTemplate("Ruby Class");
        Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        properties.setProperty("NAME", name);
        PsiDirectory directory = PsiManager.getInstance((Project)project).findDirectory(selectedDir);
        if (directory == null) {
            return null;
        }
        try {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
            PsiElement element = FileTemplateUtil.createFromTemplate((FileTemplate)rubyClassTemplate, (String)NamingConventions.toUnderscoreCase((String)name, (Module)module), (Properties)properties, (PsiDirectory)directory);
            return (RClass)PsiTreeUtil.findChildOfType((PsiElement)element, RClass.class, (boolean)false);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    private static String getNewClassText(@NotNull String name) {
        if (name == null) {
            CreateRubyClassFix.$$$reportNull$$$0(18);
        }
        String string = String.format("class %s\n\nend", name);
        if (string == null) {
            CreateRubyClassFix.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/resolve/CreateRubyClassFix";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 11: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createRClassSupplier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/resolve/CreateRubyClassFix";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewClassText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRClassWriteAction";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRClassInCurrentFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRClassInNewFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNewClassText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
        };
    }
}

