/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.probableBugs;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ArgMapping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.CallableSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.probableBugs.RubyExpectedMethodSignatureProvider;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RBlockCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RPseudoConstant;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyIncorrectArgumentCountInspection
extends LocalInspectionTool {
    private final Set<String> myDisabledExpectedSignatureProviders = new TreeSet<String>();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyIncorrectArgumentCountInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder, this.myDisabledExpectedSignatureProviders);
    }

    @NotNull
    public OptPane getOptionsPane() {
        List extensions = ContainerUtil.sorted((Collection)RubyExpectedMethodSignatureProvider.EP_NAME.getExtensionList(), Comparator.comparing(it -> it.getDisplayName(), Comparator.nullsFirst(Comparator.naturalOrder())));
        if (extensions.isEmpty()) {
            OptPane optPane = OptPane.EMPTY;
            if (optPane == null) {
                RubyIncorrectArgumentCountInspection.$$$reportNull$$$0(1);
            }
            return optPane;
        }
        ArrayList<OptCheckbox> components = new ArrayList<OptCheckbox>();
        for (RubyExpectedMethodSignatureProvider extension : extensions) {
            String displayName = extension.getDisplayName();
            if (displayName == null) continue;
            String label = RBundle.message((String)"ruby.inspection.incorrect.call.argument.count.extension.setting.prefix", (Object[])new Object[]{displayName});
            components.add(OptPane.checkbox((String)extension.getId(), (String)label, (OptRegularComponent[])new OptRegularComponent[0]).prefix("RubyExpectedSignatureProvider"));
        }
        OptPane optPane = OptPane.pane((OptRegularComponent[])components.toArray(new OptRegularComponent[0]));
        if (optPane == null) {
            RubyIncorrectArgumentCountInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController controller = OptionController.of(key -> !this.myDisabledExpectedSignatureProviders.contains(key), (key, value) -> {
            Boolean bool;
            if (value instanceof Boolean && (bool = (Boolean)value).booleanValue()) {
                this.myDisabledExpectedSignatureProviders.remove(key);
            } else {
                this.myDisabledExpectedSignatureProviders.add((String)key);
            }
        });
        OptionController optionController = super.getOptionController().onPrefix("RubyExpectedSignatureProvider", controller);
        if (optionController == null) {
            RubyIncorrectArgumentCountInspection.$$$reportNull$$$0(3);
        }
        return optionController;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            RubyIncorrectArgumentCountInspection.$$$reportNull$$$0(4);
        }
        for (Element extension : node.getChildren("extension")) {
            boolean enabled;
            String id = extension.getAttributeValue("id");
            if (id == null || (enabled = Boolean.parseBoolean((String)ObjectUtils.coalesce((Object)extension.getAttributeValue("enabled"), (Object)"true")))) continue;
            this.myDisabledExpectedSignatureProviders.add(id);
        }
    }

    @TestOnly
    public void setDisabledExpectedSignatureProviders(@NotNull Set<String> disabledExpectedSignatureProviders) {
        if (disabledExpectedSignatureProviders == null) {
            RubyIncorrectArgumentCountInspection.$$$reportNull$$$0(5);
        }
        this.myDisabledExpectedSignatureProviders.clear();
        this.myDisabledExpectedSignatureProviders.addAll(disabledExpectedSignatureProviders);
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            RubyIncorrectArgumentCountInspection.$$$reportNull$$$0(6);
        }
        for (String id : this.myDisabledExpectedSignatureProviders) {
            node.addContent(new Element("extension").setAttribute("id", id).setAttribute("enabled", "false"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/probableBugs/RubyIncorrectArgumentCountInspection";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledExpectedSignatureProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/probableBugs/RubyIncorrectArgumentCountInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledExpectedSignatureProviders";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RubyInspectionVisitor {
        private final Set<String> myDisabledExpectedSignatureProviders;

        private MyVisitor(@NotNull ProblemsHolder holder, @NotNull Set<String> disabledExpectedSignatureProviders) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (disabledExpectedSignatureProviders == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            super(holder);
            this.myDisabledExpectedSignatureProviders = Set.copyOf(disabledExpectedSignatureProviders);
        }

        public void visitRArrayIndexing(@NotNull RArrayIndexing indexing) {
            if (indexing == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (indexing.getParent() instanceof RAssignmentExpression) {
                return;
            }
            PsiElement commandElement = (PsiElement)ObjectUtils.doIfNotNull((Object)indexing.getReceiver(), PsiElement::getNextSibling);
            String command = RubyPsiUtil.getCallCommand((PsiElement)indexing);
            if (commandElement == null || command == null) {
                return;
            }
            this.visitRPossibleCall((RPossibleCall)indexing, indexing.getIndexes(), commandElement, command);
        }

        public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignment) {
            if (assignment == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if (assignment.getOperationType() != RubyTokenTypes.tASSGN) {
                return;
            }
            ArrayList arguments = new ArrayList(assignment.getArguments());
            RArrayIndexing indexing = (RArrayIndexing)ObjectUtils.tryCast((Object)assignment.getObject(), RArrayIndexing.class);
            if (indexing != null) {
                PsiElement commandElement = (PsiElement)ObjectUtils.doIfNotNull((Object)indexing.getReceiver(), PsiElement::getNextSibling);
                String command = RubyPsiUtil.getCallCommand((PsiElement)assignment);
                if (commandElement != null && command != null) {
                    arguments.addAll(0, indexing.getIndexes());
                    this.visitRAssignmentOfIndexing((RPossibleCall)assignment, arguments, commandElement, command);
                }
            } else {
                this.visitRPossibleCall((RPossibleCall)assignment, arguments);
            }
        }

        @Override
        public void visitRCall(@NotNull RCall call) {
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (call.getPsiCommand() instanceof RPseudoConstant) {
                return;
            }
            ArrayList<RCodeBlock> arguments = new ArrayList<RCodeBlock>(call.getArguments());
            RBlockCall blockCall = RBlockCallNavigator.getByCall((RPsiElement)call);
            if (blockCall != null) {
                arguments.add(blockCall.getBlock());
            }
            this.visitRPossibleCall((RPossibleCall)call, arguments);
        }

        public void visitRFid(@NotNull RFid fid) {
            if (fid == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if (RCallNavigator.getByCommand((PsiElement)fid) != null || fid.getParent() instanceof RReference) {
                return;
            }
            ArrayList<RCodeBlock> arguments = new ArrayList<RCodeBlock>();
            RBlockCall blockCall = RBlockCallNavigator.getByCall((RPsiElement)fid);
            if (blockCall != null) {
                arguments.add(blockCall.getBlock());
            }
            this.visitRPossibleCall((RPossibleCall)fid, arguments);
        }

        public void visitRIdentifier(@NotNull RIdentifier identifier) {
            if (identifier == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            if (RCallNavigator.getByCommand((PsiElement)identifier) != null || identifier.getParent() instanceof RReference) {
                return;
            }
            if (identifier.isParameterDeclaration() || identifier.isLocalVariable()) {
                return;
            }
            ArrayList<RCodeBlock> arguments = new ArrayList<RCodeBlock>();
            RBlockCall blockCall = RBlockCallNavigator.getByCall((RPsiElement)identifier);
            if (blockCall != null) {
                arguments.add(blockCall.getBlock());
            }
            this.visitRPossibleCall((RPossibleCall)identifier, arguments);
        }

        public void visitRPseudoConstant(@NotNull RPseudoConstant pseudoConstant) {
            if (pseudoConstant == null) {
                MyVisitor.$$$reportNull$$$0(7);
            }
            if (!"super".equals(pseudoConstant.getText())) {
                return;
            }
            RContainer container = pseudoConstant.getParentContainer();
            if (!(container instanceof RMethod)) {
                return;
            }
            RMethod method = (RMethod)container;
            Symbol symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)method);
            if (!(symbol instanceof CallableSymbol)) {
                return;
            }
            CallableSymbol methodSymbol = (CallableSymbol)symbol;
            RCall parent = RCallNavigator.getByCommand((PsiElement)pseudoConstant);
            RPossibleCall call = (RPossibleCall)ObjectUtils.coalesce((Object)RBlockCallNavigator.getByCall((RPsiElement)((RPsiElement)ObjectUtils.coalesce((Object)parent, (Object)pseudoConstant))), (Object)parent);
            if (call != null) {
                ArrayList<RCodeBlock> arguments = new ArrayList<RCodeBlock>(call.getArguments());
                if (call instanceof RBlockCall) {
                    RBlockCall blockCall = (RBlockCall)call;
                    arguments.add(blockCall.getBlock());
                }
                for (RubyExpectedMethodSignatureProvider extension : this.getEnabledExpectedSignatureProviders()) {
                    boolean hasProblems;
                    Map mapping;
                    List<ArgumentInfo> parameters = extension.getExpectedMethodSignature((RPossibleCall)pseudoConstant);
                    if (parameters == null || (mapping = ArgMapping.get(parameters, arguments)) == null || !(hasProblems = this.checkCallArgumentProblems(parameters, arguments, mapping, (PsiElement)pseudoConstant, method.getName()))) continue;
                    return;
                }
            } else {
                List argumentInfos = methodSymbol.getArgumentInfos();
                if (argumentInfos == null) {
                    return;
                }
                LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElementOrLatest((PsiElement)method);
                List arguments = method.getArguments();
                for (RubyExpectedMethodSignatureProvider extension : this.getEnabledExpectedSignatureProviders()) {
                    boolean hasProblems;
                    Map mapping;
                    List<ArgumentInfo> parameters = extension.getExpectedMethodSignature((RPossibleCall)pseudoConstant);
                    if (parameters == null || (mapping = ArgMapping.getSuper(parameters, (List)argumentInfos, (LanguageLevel)languageLevel)) == null || !(hasProblems = this.checkSuperArgumentProblems(parameters, arguments, mapping, (PsiElement)pseudoConstant, method.getName()))) continue;
                    return;
                }
            }
        }

        public void visitRReference(@NotNull RReference reference) {
            if (reference == null) {
                MyVisitor.$$$reportNull$$$0(8);
            }
            if (RReferenceBase.doesResolveToConstant((RReference)reference)) {
                return;
            }
            if (RCallNavigator.getByCommand((PsiElement)reference) != null || RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)reference) != null) {
                return;
            }
            ArrayList<RCodeBlock> arguments = new ArrayList<RCodeBlock>(reference.getArguments());
            RBlockCall blockCall = RBlockCallNavigator.getByCall((RPsiElement)reference);
            if (blockCall != null) {
                arguments.add(blockCall.getBlock());
            }
            this.visitRPossibleCall((RPossibleCall)reference, arguments);
        }

        public void visitRYieldStatement(@NotNull RYieldStatement yield) {
            if (yield == null) {
                MyVisitor.$$$reportNull$$$0(9);
            }
        }

        private void visitRAssignmentOfIndexing(@NotNull RPossibleCall call, @NotNull List<? extends RPsiElement> arguments, @NotNull PsiElement commandElement, @NotNull String command) {
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(10);
            }
            if (arguments == null) {
                MyVisitor.$$$reportNull$$$0(11);
            }
            if (commandElement == null) {
                MyVisitor.$$$reportNull$$$0(12);
            }
            if (command == null) {
                MyVisitor.$$$reportNull$$$0(13);
            }
            for (RubyExpectedMethodSignatureProvider extension : this.getEnabledExpectedSignatureProviders()) {
                boolean hasProblems;
                Map mapping;
                List<ArgumentInfo> parameters = extension.getExpectedMethodSignature(call);
                if (parameters == null) continue;
                ArrayList<ArgumentInfo> indexingParameters = new ArrayList<ArgumentInfo>(parameters);
                ArrayList<? extends RPsiElement> indexingArguments = new ArrayList<RPsiElement>(arguments);
                if (!indexingParameters.isEmpty() && indexingArguments.size() > indexingParameters.size()) {
                    indexingParameters.remove(indexingParameters.size() - 1);
                    indexingArguments.remove(indexingArguments.size() - 1);
                }
                if ((mapping = ArgMapping.get(indexingParameters, indexingArguments)) == null || !(hasProblems = this.checkCallArgumentProblems(indexingParameters, indexingArguments, mapping, commandElement, command))) continue;
                return;
            }
        }

        private void visitRPossibleCall(@NotNull RPossibleCall call, @NotNull List<? extends RPsiElement> arguments) {
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(14);
            }
            if (arguments == null) {
                MyVisitor.$$$reportNull$$$0(15);
            }
            PsiElement commandElement = (PsiElement)ObjectUtils.coalesce((Object)RubyPsiUtil.getCallCommandElement((PsiElement)call), (Object)call);
            String command = (String)ObjectUtils.coalesce((Object)RubyPsiUtil.getCallCommand((PsiElement)RCallNavigator.getRealCall((RPossibleCall)call)), (Object)commandElement.getText());
            this.visitRPossibleCall(call, arguments, commandElement, command);
        }

        private void visitRPossibleCall(@NotNull RPossibleCall call, @NotNull List<? extends RPsiElement> arguments, @NotNull PsiElement commandElement, @NotNull String command) {
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(16);
            }
            if (arguments == null) {
                MyVisitor.$$$reportNull$$$0(17);
            }
            if (commandElement == null) {
                MyVisitor.$$$reportNull$$$0(18);
            }
            if (command == null) {
                MyVisitor.$$$reportNull$$$0(19);
            }
            for (RubyExpectedMethodSignatureProvider extension : this.getEnabledExpectedSignatureProviders()) {
                boolean hasProblems;
                Map mapping;
                List<ArgumentInfo> parameters = extension.getExpectedMethodSignature(call);
                if (parameters == null || (mapping = ArgMapping.get(parameters, arguments)) == null || !(hasProblems = this.checkCallArgumentProblems(parameters, arguments, mapping, commandElement, command))) continue;
                return;
            }
        }

        private boolean checkCallArgumentProblems(@NotNull List<? extends ArgumentInfo> parameters, @NotNull List<? extends RPsiElement> arguments, @NotNull Map<ArgumentInfo, ArgMapping.MappingRange> mapping, @NotNull PsiElement commandElement, @NotNull String command) {
            if (parameters == null) {
                MyVisitor.$$$reportNull$$$0(20);
            }
            if (arguments == null) {
                MyVisitor.$$$reportNull$$$0(21);
            }
            if (mapping == null) {
                MyVisitor.$$$reportNull$$$0(22);
            }
            if (commandElement == null) {
                MyVisitor.$$$reportNull$$$0(23);
            }
            if (command == null) {
                MyVisitor.$$$reportNull$$$0(24);
            }
            List problems = ArgMapping.getArgumentsProblems(parameters, arguments, mapping, (PsiElement)commandElement, (String)command);
            for (ArgMapping.Problem problem : problems) {
                PsiElement startElement = problem.getElement();
                PsiElement endElement = problem.getEndElement();
                if (startElement == null || endElement == null) continue;
                @NlsSafe String message = problem.toString();
                LocalQuickFix[] quickFixes = problem.getQuickFixes().toArray(LocalQuickFix.EMPTY_ARRAY);
                ProblemDescriptor descriptor = InspectionManager.getInstance((Project)this.myHolder.getProject()).createProblemDescriptor(startElement, endElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myHolder.isOnTheFly(), quickFixes);
                this.myHolder.registerProblem(descriptor);
            }
            return !problems.isEmpty();
        }

        private boolean checkSuperArgumentProblems(@NotNull List<? extends ArgumentInfo> parameters, @NotNull List<? extends RPsiElement> arguments, @NotNull Map<ArgumentInfo, ArgMapping.MappingRange> mapping, @NotNull PsiElement commandElement, @NotNull String command) {
            List problems;
            if (parameters == null) {
                MyVisitor.$$$reportNull$$$0(25);
            }
            if (arguments == null) {
                MyVisitor.$$$reportNull$$$0(26);
            }
            if (mapping == null) {
                MyVisitor.$$$reportNull$$$0(27);
            }
            if (commandElement == null) {
                MyVisitor.$$$reportNull$$$0(28);
            }
            if (command == null) {
                MyVisitor.$$$reportNull$$$0(29);
            }
            if ((problems = ArgMapping.getArgumentsProblems(parameters, arguments, mapping, (PsiElement)commandElement, (String)command)).isEmpty()) {
                return false;
            }
            String message = RBundle.message((String)"ruby.inspection.incorrect.call.argument.count.mismatched.super.description");
            ProblemDescriptor descriptor = InspectionManager.getInstance((Project)this.myHolder.getProject()).createProblemDescriptor(commandElement, commandElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myHolder.isOnTheFly(), new LocalQuickFix[0]);
            this.myHolder.registerProblem(descriptor);
            return true;
        }

        @NotNull
        private List<RubyExpectedMethodSignatureProvider> getEnabledExpectedSignatureProviders() {
            List list = ContainerUtil.filter((Collection)RubyExpectedMethodSignatureProvider.EP_NAME.getExtensionList(), it -> !this.myDisabledExpectedSignatureProviders.contains(it.getId()));
            if (list == null) {
                MyVisitor.$$$reportNull$$$0(30);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 30 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disabledExpectedSignatureProviders";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexing";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 4: 
                case 10: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fid";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "identifier";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pseudoConstant";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yield";
                    break;
                }
                case 11: 
                case 15: 
                case 17: 
                case 21: 
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arguments";
                    break;
                }
                case 12: 
                case 18: 
                case 23: 
                case 28: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandElement";
                    break;
                }
                case 13: 
                case 19: 
                case 24: 
                case 29: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 20: 
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 22: 
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/probableBugs/RubyIncorrectArgumentCountInspection$MyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/probableBugs/RubyIncorrectArgumentCountInspection$MyVisitor";
                    break;
                }
                case 30: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnabledExpectedSignatureProviders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRArrayIndexing";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRAssignmentExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRCall";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRFid";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRIdentifier";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRPseudoConstant";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRReference";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRYieldStatement";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRAssignmentOfIndexing";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRPossibleCall";
                    break;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "checkCallArgumentProblems";
                    break;
                }
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "checkSuperArgumentProblems";
                    break;
                }
                case 30: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 30 -> new IllegalStateException(string);
            };
        }
    }
}

