/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.nilanalysis;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RPsiPolyVariantReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.SymbolResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;

public final class RubyReferencesListTableFactory {
    private RubyReferencesListTableFactory() {
    }

    @Nullable
    public static Reference getReference(@NotNull RExpression expression) {
        SymbolResolveResult result;
        if (expression == null) {
            RubyReferencesListTableFactory.$$$reportNull$$$0(0);
        }
        if (expression instanceof RArrayIndexing) {
            Symbol receiver = RTypeUtilCore.getBirthTypeSymbol((RType)RTypeUtil.getType((PsiElement)((RArrayIndexing)expression).getReceiver()));
            if (receiver == null) {
                return null;
            }
            result = new SymbolResolveResult(SymbolUtil.findMethod(receiver, "[]", Types.METHODS_LIKE, (PsiElement)expression), true);
        } else {
            result = (SymbolResolveResult)ObjectUtils.doIfCast((Object)expression.getReference(), RPsiPolyVariantReference.class, RPsiPolyVariantReference::resolveToSymbol);
        }
        if (result == null) {
            return null;
        }
        RMethodSymbol symbol = (RMethodSymbol)ObjectUtils.tryCast((Object)result.getSymbol(), RMethodSymbol.class);
        if (symbol == null) {
            return null;
        }
        Symbol parent = symbol.getParentSymbol();
        String name = symbol.getName();
        if (parent == null || name == null) {
            return null;
        }
        FQN parentFqn = parent.getFQNWithNesting();
        return new Reference(RObjectClass.makeNonSingletonClassFqn((FQN)parentFqn).getFullPath() + (RObjectClass.isSingletonFQN((FQN)parentFqn) ? "::" : "#") + name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyReferencesListTableFactory", "getReference"));
    }

    public static class Reference {
        @Nullable
        public String myValue;

        public Reference() {
        }

        public Reference(@Nullable @NlsSafe String value) {
            this.myValue = value;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            return Objects.equals(this.myValue, ((Reference)obj).myValue);
        }

        @Nullable
        public String get() {
            return this.myValue;
        }

        public int hashCode() {
            return this.myValue != null ? this.myValue.hashCode() : 0;
        }

        public void set(@Nullable String value) {
            this.myValue = value;
        }
    }
}

