/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.nilanalysis;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.nilanalysis.RubyReferencesListTableFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;

public class RubyNilAnalysisVisitor
extends RubyInspectionVisitor {
    private final List<RubyReferencesListTableFactory.Reference> myIgnoredReceivers;

    public RubyNilAnalysisVisitor(@NotNull ProblemsHolder holder, @NotNull List<RubyReferencesListTableFactory.Reference> ignoredReceivers) {
        if (holder == null) {
            RubyNilAnalysisVisitor.$$$reportNull$$$0(0);
        }
        if (ignoredReceivers == null) {
            RubyNilAnalysisVisitor.$$$reportNull$$$0(1);
        }
        super(holder);
        this.myIgnoredReceivers = List.copyOf(ignoredReceivers);
    }

    public void visitRDotReference(@NotNull RDotReference rDotReference) {
        if (rDotReference == null) {
            RubyNilAnalysisVisitor.$$$reportNull$$$0(2);
        }
        if (!rDotReference.isSafeNavigation()) {
            this.visitRReference((RReference)rDotReference);
        }
    }

    public void visitRReference(@NotNull RReference reference) {
        RPsiElement rPsiElement;
        if (reference == null) {
            RubyNilAnalysisVisitor.$$$reportNull$$$0(3);
        }
        if (!((rPsiElement = reference.getReceiver()) instanceof RExpression)) {
            return;
        }
        RExpression receiver = (RExpression)rPsiElement;
        String name = receiver.getName();
        if (name == null || name.startsWith("@")) {
            return;
        }
        Project project = reference.getProject();
        String command = reference.getCommand();
        if (command == null || NilAnalysisUtil.isClassMethod(project, "NilClass", command)) {
            return;
        }
        ControlFlowHolder holder = TypeInferenceContext.getControlFlowHolder((PsiElement)receiver);
        if (holder == null) {
            return;
        }
        RubyReferencesListTableFactory.Reference receiverFqn = RubyReferencesListTableFactory.getReference(receiver);
        if (receiverFqn != null && this.myIgnoredReceivers.contains(receiverFqn)) {
            return;
        }
        if (NilAnalysisUtil.getCanBeNil((RPsiElement)receiver, holder) == ThreeState.YES) {
            PsiElement value = (PsiElement)Objects.requireNonNull(reference.getValue());
            this.registerProblem(value, RBundle.message((String)"inspection.nil.analysis.warning", (Object[])new Object[]{value.getText()}));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredReceivers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rDotReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/nilanalysis/RubyNilAnalysisVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDotReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

