/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.RubyUsageAnalyzerCore;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyParameterNamingConventionInspection
extends ConventionInspection {
    public boolean m_ignoreBlockParameters = true;
    public boolean m_ignoreRescueParameters = true;
    public boolean m_ignoreLambdaParameters = true;
    private static final int DEFAULT_MIN_LENGTH = 2;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            String string = RBundle.message((String)"parameter.name.ref.is.too.short");
            if (string == null) {
                RubyParameterNamingConventionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = RBundle.message((String)"parameter.name.ref.is.too.long");
            if (string == null) {
                RubyParameterNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = RBundle.message((String)"parameter.name.ref.doesn.t.match.regex", (Object[])new Object[]{this.getRegex()});
        if (string == null) {
            RubyParameterNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    @Override
    public Collection<? extends OptRegularComponent> createExtraOptions() {
        return Arrays.asList(OptPane.checkbox((String)"m_ignoreBlockParameters", (String)RBundle.message((String)"inspection.ruby.parameter.naming.convention.block"), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreLambdaParameters", (String)RBundle.message((String)"inspection.ruby.parameter.naming.convention.lambda"), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"m_ignoreRescueParameters", (String)RBundle.message((String)"inspection.ruby.parameter.naming.convention.rescue"), (OptRegularComponent[])new OptRegularComponent[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyParameterNamingConventionInspection", "buildErrorString"));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitRIdentifier(@NotNull RIdentifier identifier) {
            if (identifier == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            if (!RubyUsageAnalyzerCore.isParameter((RPsiElement)identifier)) {
                return;
            }
            if (RubyParameterNamingConventionInspection.this.m_ignoreBlockParameters && (RubyUsageAnalyzerCore.isBlockCallLocalDeclaration((RPsiElement)identifier) || RubyUsageAnalyzerCore.isBlockParameter((RPsiElement)identifier))) {
                return;
            }
            if (RubyParameterNamingConventionInspection.this.m_ignoreLambdaParameters && RubyUsageAnalyzerCore.isLambdaParameter((RPsiElement)identifier)) {
                return;
            }
            if (RubyParameterNamingConventionInspection.this.m_ignoreRescueParameters && RubyUsageAnalyzerCore.isRescueParameter((RPsiElement)identifier)) {
                return;
            }
            String name = identifier.getName();
            if (RubyParameterNamingConventionInspection.this.isValid(name, (PsiElement)identifier)) {
                return;
            }
            this.registerVariableError(identifier, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyParameterNamingConventionInspection$NamingConventionsVisitor", "visitRIdentifier"));
        }
    }
}

