/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.impl.StartRenameQuickFix;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.model.psi.ExtensionsKt;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.model.rename.UtilKt;

public final class RubyGlobalVariableNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 2;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    protected LocalQuickFix buildFix(PsiElement location) {
        Project project = location.getProject();
        if (!(location instanceof RGlobalVariable)) {
            return null;
        }
        RGlobalVariable globalVariable = (RGlobalVariable)location;
        RenameTarget target = (RenameTarget)ObjectUtils.doIfNotNull((Object)ExtensionsKt.getSymbol((PsiElement)globalVariable), it -> UtilKt.renameTarget(project, it));
        if (target == null) {
            return null;
        }
        return new StartRenameQuickFix(target);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            String string = RBundle.message((String)"global.variable.name.ref.is.too.short");
            if (string == null) {
                RubyGlobalVariableNamingConventionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = RBundle.message((String)"global.variable.name.ref.is.too.long");
            if (string == null) {
                RubyGlobalVariableNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = RBundle.message((String)"global.variable.name.ref.doesn.t.match.regex", (Object[])new Object[]{this.getRegex()});
        if (string == null) {
            RubyGlobalVariableNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyGlobalVariableNamingConventionInspection", "buildErrorString"));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitRGlobalVariable(@NotNull RGlobalVariable globalVariable) {
            if (globalVariable == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            String name = globalVariable.getName();
            if (!RubyPsiUtilCore.isDeclaration((PsiElement)globalVariable) || StringUtil.isEmpty((String)name) || RubyGlobalVariableNamingConventionInspection.this.isValid(name, (PsiElement)globalVariable)) {
                return;
            }
            this.registerGlobalVariableError(globalVariable, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalVariable", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyGlobalVariableNamingConventionInspection$NamingConventionsVisitor", "visitRGlobalVariable"));
        }
    }
}

