/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RObjectClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.search.overriden.RubySuperMethodsSearch;

public final class RubyClassMethodNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 2;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern() + "[!?=]?|\\[\\]=?";
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            String string = RBundle.message((String)"class.method.name.ref.is.too.short");
            if (string == null) {
                RubyClassMethodNamingConventionInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (className.length() > this.getMaxLength()) {
            String string = RBundle.message((String)"class.method.name.ref.is.too.long");
            if (string == null) {
                RubyClassMethodNamingConventionInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = RBundle.message((String)"class.method.name.ref.doesn.t.match.regex", (Object[])new Object[]{this.getRegex()});
        if (string == null) {
            RubyClassMethodNamingConventionInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyClassMethodNamingConventionInspection", "buildErrorString"));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitRMethod(@NotNull RMethod rMethod) {
            if (rMethod == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(0);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)rMethod, RContainer.class) instanceof RObjectClass) {
                this.checkMethod(rMethod);
            }
        }

        public void visitRSingletonMethod(@NotNull RSingletonMethod rsMethod) {
            if (rsMethod == null) {
                NamingConventionsVisitor.$$$reportNull$$$0(1);
            }
            this.checkMethod((RMethod)rsMethod);
        }

        private void checkMethod(RMethod rMethod) {
            String name = rMethod.getName();
            if (RubyClassMethodNamingConventionInspection.this.isValid(name, (PsiElement)rMethod) || RubySuperMethodsSearch.search(rMethod).findFirst() != null) {
                return;
            }
            this.registerMethodError(rMethod, name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rMethod";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rsMethod";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyClassMethodNamingConventionInspection$NamingConventionsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRSingletonMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

