/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.options.OptCheckbox;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.codeInspection.options.RegexValidator;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyBaseInspection;

public abstract class ConventionInspection
extends RubyBaseInspection {
    public String m_regex = this.getDefaultRegex();
    public boolean myRegexEnabled = true;
    public int m_minLength = this.getDefaultMinLength();
    public boolean myMinLengthEnabled = false;
    public int m_maxLength = this.getDefaultMaxLength();
    public boolean myMaxLengthEnabled = false;
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    @NonNls
    protected abstract String getDefaultRegex();

    protected abstract int getDefaultMinLength();

    protected abstract int getDefaultMaxLength();

    protected String getRegex() {
        return this.m_regex;
    }

    protected int getMinLength() {
        return this.m_minLength;
    }

    protected int getMaxLength() {
        return this.m_maxLength;
    }

    protected boolean isValid(String name, @Nullable PsiElement context) {
        if (StringUtil.isEmpty((String)name)) {
            return true;
        }
        if (!ConventionInspection.containsAnyLetter(name)) {
            return true;
        }
        int length = name.length();
        if (this.myMinLengthEnabled && length < this.m_minLength) {
            return false;
        }
        if (this.myMaxLengthEnabled && length > this.m_maxLength) {
            return false;
        }
        return this.myRegexEnabled && this.m_regexPattern.matcher(name).matches();
    }

    protected static boolean containsAnyLetter(@NotNull String name) {
        if (name == null) {
            ConventionInspection.$$$reportNull$$$0(0);
        }
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isLetter(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ConventionInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public Collection<? extends OptRegularComponent> createExtraOptions() {
        return Collections.emptyList();
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onValueSet("m_regex", value -> {
            try {
                this.m_regexPattern = Pattern.compile(this.m_regex);
            }
            catch (PatternSyntaxException ignore) {
                this.m_regex = this.getDefaultRegex();
                this.m_regexPattern = Pattern.compile(this.m_regex);
            }
        });
        if (optionController == null) {
            ConventionInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    @NotNull
    public OptPane getOptionsPane() {
        ArrayList<OptCheckbox> components = new ArrayList<OptCheckbox>(List.of(OptPane.checkbox((String)"myRegexEnabled", (String)InspectionsBundle.message((String)"label.pattern", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.string((String)"m_regex", (String)"", (int)-1, (StringValidator)new RegexValidator())}), OptPane.checkbox((String)"myMinLengthEnabled", (String)InspectionsBundle.message((String)"label.min.length", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_minLength", (String)"", (int)1, (int)1000000)}), OptPane.checkbox((String)"myMaxLengthEnabled", (String)InspectionsBundle.message((String)"label.max.length", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"m_maxLength", (String)"", (int)1, (int)1000000)})));
        components.addAll(this.createExtraOptions());
        OptPane optPane = OptPane.pane((OptRegularComponent[])components.toArray(new OptRegularComponent[0]));
        if (optPane == null) {
            ConventionInspection.$$$reportNull$$$0(3);
        }
        return optPane;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @TestOnly
    public void setMinLengthEnabled(boolean minLengthEnabled) {
        this.myMinLengthEnabled = minLengthEnabled;
    }

    @TestOnly
    public void setMaxLengthEnabled(boolean maxLengthEnabled) {
        this.myMaxLengthEnabled = maxLengthEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/ConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/ConventionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyLetter";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

