/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RDuckType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtilCore;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyCoercibleExpressionTypeProvider;

abstract class RubyMismatchedTypeVisitor
extends RubyInspectionVisitor {
    RubyMismatchedTypeVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    void checkExpectedNilability(@NotNull RTypeWithNilability expectedTypeWithNilability, @NotNull RTypeWithNilability actualTypeWithNilability, @NotNull PsiElement element, @NotNull @NotNull LocalQuickFix @NotNull [] quickFixes) {
        RType expectedType;
        boolean isDuckType;
        if (expectedTypeWithNilability == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(1);
        }
        if (actualTypeWithNilability == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(2);
        }
        if (element == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(3);
        }
        if (quickFixes == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(4);
        }
        Project project = element.getProject();
        ThreeState expectedNilability = expectedTypeWithNilability.getCanBeNil();
        ThreeState actualNilability = actualTypeWithNilability.getCanBeNil();
        if (expectedNilability != ThreeState.NO || actualNilability != ThreeState.YES) {
            return;
        }
        if (RTypeUtilCore.isNullOrEmpty((RType)actualTypeWithNilability.getType()) && (isDuckType = ContainerUtil.all(RTypeUtil.flattenUnionAndIntersectionType(expectedType = expectedTypeWithNilability.getType()), it -> it instanceof RDuckType)) && RTypeUtil.isSubtype(RTypeFactory.createTypeByFQN(project, "NilClass"), expectedType) != ThreeState.NO) {
            return;
        }
        this.myHolder.registerProblem(element, this.createExpectedNilabilityProblemMessage(), quickFixes);
    }

    void checkExpectedNilability(@Nullable ThreeState expectedNilability, @NotNull ThreeState actualNilability, @NotNull PsiElement element) {
        if (actualNilability == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(5);
        }
        if (element == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(6);
        }
        if (expectedNilability != ThreeState.NO || actualNilability != ThreeState.YES) {
            return;
        }
        this.myHolder.registerProblem(element, this.createExpectedNilabilityProblemMessage(), new LocalQuickFix[0]);
    }

    void checkExpectedType(@NotNull RType expectedType, @NotNull RType actualType, @NotNull PsiElement element, @NotNull @NotNull LocalQuickFix @NotNull [] quickFixes) {
        if (expectedType == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(7);
        }
        if (actualType == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(8);
        }
        if (element == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(9);
        }
        if (quickFixes == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(10);
        }
        if (RTypeUtil.isSubtype(actualType, expectedType) != ThreeState.NO) {
            return;
        }
        String expected = XmlStringUtil.escapeString((String)RFrozenType.clearFrozenStatus(expectedType).getPresentableName());
        String actual = XmlStringUtil.escapeString((String)RFrozenType.clearFrozenStatus(actualType).getPresentableName());
        if (expected != null && actual != null) {
            this.myHolder.registerProblem(element, this.createExpectedTypeProblemMessage(expected, actual), quickFixes);
        }
    }

    void checkExpectedTypeWithCoercion(@NotNull RType expectedType, @NotNull RType actualType, @NotNull RType receiverType, @NotNull PsiElement element, @NotNull @NotNull LocalQuickFix @NotNull [] quickFixes) {
        if (expectedType == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(11);
        }
        if (actualType == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(12);
        }
        if (receiverType == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(13);
        }
        if (element == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(14);
        }
        if (quickFixes == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(15);
        }
        if (RTypeUtil.isSubtype(actualType, expectedType) != ThreeState.NO) {
            return;
        }
        List<ThreeState> isCoercible = RubyCoercibleExpressionTypeProvider.EP_NAME.getExtensionList().stream().flatMap(extension -> Stream.ofNullable(extension.getCoercibleType(element))).map(coercibleType -> RTypeUtil.isSubtype(receiverType, coercibleType)).toList();
        String expected = XmlStringUtil.escapeString((String)RFrozenType.clearFrozenStatus(expectedType).getPresentableName());
        String actual = XmlStringUtil.escapeString((String)RFrozenType.clearFrozenStatus(actualType).getPresentableName());
        String receiver = receiverType.getPresentableName();
        if (!isCoercible.isEmpty()) {
            if (ThreeState.mostPositive(isCoercible) == ThreeState.NO && receiver != null && actual != null) {
                this.myHolder.registerProblem(element, this.createCannotCoerceTypeProblemMessage(receiver, actual), quickFixes);
            }
        } else if (actualType.getMemberForName("coerce", Symbol.Filter.ACCEPT_ALL, element) == null && expected != null && actual != null) {
            this.myHolder.registerProblem(element, this.createExpectedTypeProblemMessage(expected, actual), quickFixes);
        }
    }

    @InspectionMessage
    @NotNull
    String createCannotCoerceTypeProblemMessage(@NotNull String receiver, @NotNull String actual) {
        if (receiver == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(16);
        }
        if (actual == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(17);
        }
        String string = RBundle.message((String)"inspection.mismatched.type.incoercible.warning", (Object[])new Object[]{receiver, actual});
        if (string == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(18);
        }
        return string;
    }

    @InspectionMessage
    @NotNull
    String createExpectedNilabilityProblemMessage() {
        String string = RBundle.message((String)"inspection.mismatched.type.nilability.warning");
        if (string == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(19);
        }
        return string;
    }

    @InspectionMessage
    @NotNull
    String createExpectedTypeProblemMessage(@NotNull String expected, @NotNull String actual) {
        if (expected == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(20);
        }
        if (actual == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(21);
        }
        String string = RBundle.message((String)"inspection.mismatched.type.warning", (Object[])new Object[]{expected, actual});
        if (string == null) {
            RubyMismatchedTypeVisitor.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 19, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeWithNilability";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeWithNilability";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualNilability";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedTypeVisitor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedTypeVisitor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createCannotCoerceTypeProblemMessage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpectedNilabilityProblemMessage";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpectedTypeProblemMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkExpectedNilability";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkExpectedType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkExpectedTypeWithCoercion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCannotCoerceTypeProblemMessage";
                break;
            }
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createExpectedTypeProblemMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 19, 22 -> new IllegalStateException(string);
        };
    }
}

