/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyExpectedConstantTypeProvider;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyMismatchedTypeInspectionUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyMismatchedTypeVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;

public final class RubyMismatchedConstantTypeInspection
extends LocalInspectionTool {
    private final Set<String> myDisabledExpectedTypeProviders = new TreeSet<String>();
    private boolean myCheckNilability = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyMismatchedConstantTypeInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder, this.myDisabledExpectedTypeProviders, this.myCheckNilability);
    }

    @NotNull
    public OptPane getOptionsPane() {
        ArrayList<OptRegularComponent> components = new ArrayList<OptRegularComponent>(RubyMismatchedTypeInspectionUtil.createOptExtensionComponents(RubyExpectedConstantTypeProvider.EP_NAME, it -> it.getId(), it -> it.getDisplayName(), "RubyExpectedTypeProvider"));
        components.add(RubyMismatchedTypeInspectionUtil.createOptCheckNilabilityComponent("myCheckNilability"));
        OptPane optPane = OptPane.pane((OptRegularComponent[])components.toArray(new OptRegularComponent[0]));
        if (optPane == null) {
            RubyMismatchedConstantTypeInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onPrefix("RubyExpectedTypeProvider", RubyMismatchedTypeInspectionUtil.createOptionController(this.myDisabledExpectedTypeProviders));
        if (optionController == null) {
            RubyMismatchedConstantTypeInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            RubyMismatchedConstantTypeInspection.$$$reportNull$$$0(3);
        }
        for (Pair<String, Boolean> extension : RubyMismatchedTypeInspectionUtil.readExtensionSettings(node)) {
            if (((Boolean)extension.getSecond()).booleanValue()) continue;
            this.myDisabledExpectedTypeProviders.add((String)extension.getFirst());
        }
        this.myCheckNilability = RubyMismatchedTypeInspectionUtil.readCheckNilabilitySetting(node);
    }

    @TestOnly
    public void setDisabledExpectedTypeProviders(@NotNull Set<String> disabledExpectedTypeProviders) {
        if (disabledExpectedTypeProviders == null) {
            RubyMismatchedConstantTypeInspection.$$$reportNull$$$0(4);
        }
        this.myDisabledExpectedTypeProviders.clear();
        this.myDisabledExpectedTypeProviders.addAll(disabledExpectedTypeProviders);
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            RubyMismatchedConstantTypeInspection.$$$reportNull$$$0(5);
        }
        RubyMismatchedTypeInspectionUtil.writeExtensionSettings(node, this.myDisabledExpectedTypeProviders);
        RubyMismatchedTypeInspectionUtil.writeCheckNilabilitySetting(node, this.myCheckNilability);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedConstantTypeInspection";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledExpectedTypeProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedConstantTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledExpectedTypeProviders";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RubyMismatchedTypeVisitor {
        private final Set<String> myDisabledExpectedTypeProviders;
        private final boolean myCheckNilability;

        private MyVisitor(@NotNull ProblemsHolder holder, @NotNull Set<String> disabledExpectedConstantTypeProviders, boolean checkNilability) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (disabledExpectedConstantTypeProviders == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            super(holder);
            this.myDisabledExpectedTypeProviders = Set.copyOf(disabledExpectedConstantTypeProviders);
            this.myCheckNilability = checkNilability;
        }

        public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignment) {
            RConstant constant;
            if (assignment == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((constant = MyVisitor.getConstant(assignment)) == null) {
                return;
            }
            RPsiElement value = assignment.getValue();
            if (value == null) {
                return;
            }
            RTypeWithNilability actualTypeWithNilability = RTypeWithNilability.fromPsiElement((PsiElement)value);
            if (actualTypeWithNilability.isEmpty()) {
                return;
            }
            for (RubyExpectedConstantTypeProvider extension : this.getEnabledExpectedTypeProviders()) {
                RTypeWithNilability typeWithNilability = extension.getExpectedConstantTypeWithNilability(constant);
                if (typeWithNilability == null) continue;
                RType expectedType = typeWithNilability.getType();
                RType actualType = actualTypeWithNilability.getType();
                this.checkExpectedType(expectedType, actualType, (PsiElement)value, extension.getMismatchedTypeQuickFixes((PsiElement)value));
                if (!this.myCheckNilability) continue;
                this.checkExpectedNilability(typeWithNilability, actualTypeWithNilability, (PsiElement)value, extension.getMismatchedTypeQuickFixes((PsiElement)value));
            }
        }

        @Nullable
        private static RConstant getConstant(@NotNull RAssignmentExpression assignment) {
            RPsiElement object;
            if (assignment == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((object = assignment.getObject()) instanceof RColonReference) {
                return (RConstant)ContainerUtil.getLastItem((List)((RColonReference)object).getConstantList());
            }
            return (RConstant)ObjectUtils.tryCast((Object)object, RConstant.class);
        }

        @NotNull
        private List<RubyExpectedConstantTypeProvider> getEnabledExpectedTypeProviders() {
            List list = ContainerUtil.filter((Collection)RubyExpectedConstantTypeProvider.EP_NAME.getExtensionList(), it -> !this.myDisabledExpectedTypeProviders.contains(it.getId()));
            if (list == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disabledExpectedConstantTypeProviders";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedConstantTypeInspection$MyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedConstantTypeInspection$MyVisitor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnabledExpectedTypeProviders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getConstant";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

