/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptionController;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.TypeInferenceContext;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RHashType;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyExpectedArgumentNilabilityProvider;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyExpectedArgumentTypeProvider;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyMismatchedTypeInspectionUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes.RubyMismatchedTypeVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

public final class RubyMismatchedArgumentTypeInspection
extends LocalInspectionTool {
    private final Set<String> myDisabledExpectedTypeProviders = new TreeSet<String>();
    private boolean myCheckNilability = true;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyMismatchedArgumentTypeInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder, this.myDisabledExpectedTypeProviders, this.myCheckNilability);
    }

    @NotNull
    public OptPane getOptionsPane() {
        ArrayList<OptRegularComponent> components = new ArrayList<OptRegularComponent>(RubyMismatchedTypeInspectionUtil.createOptExtensionComponents(RubyExpectedArgumentTypeProvider.EP_NAME, it -> it.getId(), it -> it.getDisplayName(), "RubyExpectedTypeProvider"));
        components.add(RubyMismatchedTypeInspectionUtil.createOptCheckNilabilityComponent("myCheckNilability"));
        OptPane optPane = OptPane.pane((OptRegularComponent[])components.toArray(new OptRegularComponent[0]));
        if (optPane == null) {
            RubyMismatchedArgumentTypeInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @NotNull
    public OptionController getOptionController() {
        OptionController optionController = super.getOptionController().onPrefix("RubyExpectedTypeProvider", RubyMismatchedTypeInspectionUtil.createOptionController(this.myDisabledExpectedTypeProviders));
        if (optionController == null) {
            RubyMismatchedArgumentTypeInspection.$$$reportNull$$$0(2);
        }
        return optionController;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            RubyMismatchedArgumentTypeInspection.$$$reportNull$$$0(3);
        }
        for (Pair<String, Boolean> extension : RubyMismatchedTypeInspectionUtil.readExtensionSettings(node)) {
            if (((Boolean)extension.getSecond()).booleanValue()) continue;
            this.myDisabledExpectedTypeProviders.add((String)extension.getFirst());
        }
        this.myCheckNilability = RubyMismatchedTypeInspectionUtil.readCheckNilabilitySetting(node);
    }

    @TestOnly
    public void setDisabledExpectedTypeProviders(@NotNull Set<String> disabledExpectedTypeProviders) {
        if (disabledExpectedTypeProviders == null) {
            RubyMismatchedArgumentTypeInspection.$$$reportNull$$$0(4);
        }
        this.myDisabledExpectedTypeProviders.clear();
        this.myDisabledExpectedTypeProviders.addAll(disabledExpectedTypeProviders);
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            RubyMismatchedArgumentTypeInspection.$$$reportNull$$$0(5);
        }
        RubyMismatchedTypeInspectionUtil.writeExtensionSettings(node, this.myDisabledExpectedTypeProviders);
        RubyMismatchedTypeInspectionUtil.writeCheckNilabilitySetting(node, this.myCheckNilability);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedArgumentTypeInspection";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledExpectedTypeProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedArgumentTypeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionController";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledExpectedTypeProviders";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static final class MyVisitor
    extends RubyMismatchedTypeVisitor {
        private final Set<String> myDisabledExpectedTypeProviders;
        private final boolean myCheckNilability;

        private MyVisitor(@NotNull ProblemsHolder holder, @NotNull Set<String> disabledExpectedTypeProviders, boolean checkNilability) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (disabledExpectedTypeProviders == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            super(holder);
            this.myDisabledExpectedTypeProviders = Set.copyOf(disabledExpectedTypeProviders);
            this.myCheckNilability = checkNilability;
        }

        public void visitRBinaryExpression(@NotNull RBinaryExpression expression) {
            RPsiElement argument;
            if (expression == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if ((argument = expression.getRightOperand()) == null) {
                return;
            }
            ControlFlowHolder holder = TypeInferenceContext.getControlFlowHolder((PsiElement)expression);
            if (holder == null) {
                return;
            }
            for (RubyExpectedArgumentTypeProvider extension : this.getEnabledExpectedTypeProviders()) {
                if (extension.isMismatchedTypeChecksEnabled(expression, argument)) continue;
                return;
            }
            for (RubyExpectedArgumentTypeProvider extension : this.getEnabledExpectedTypeProviders()) {
                RTypeWithNilability parameterTypeWithNilability = extension.getExpectedArgumentTypeWithNilability(expression, argument);
                if (parameterTypeWithNilability == null) continue;
                RType expectedType = parameterTypeWithNilability.getType();
                RType actualType = RTypeUtil.getType((PsiElement)argument);
                RType receiverType = RTypeUtil.getType((PsiElement)expression.getLeftOperand());
                this.checkExpectedTypeWithCoercion(expectedType, actualType, receiverType, (PsiElement)argument, extension.getMismatchedTypeQuickFixes((PsiElement)argument));
                if (!this.myCheckNilability) continue;
                RTypeWithNilability actualTypeWithNilability = new RTypeWithNilability(actualType, NilAnalysisUtil.getCanBeNil(argument, holder));
                this.checkExpectedNilability(parameterTypeWithNilability, actualTypeWithNilability, (PsiElement)argument, extension.getMismatchedTypeQuickFixes((PsiElement)argument));
            }
        }

        @Override
        public void visitRCall(@NotNull RCall call) {
            ControlFlowHolder holder;
            if (call == null) {
                MyVisitor.$$$reportNull$$$0(3);
            }
            if ((holder = TypeInferenceContext.getControlFlowHolder((PsiElement)call)) == null) {
                return;
            }
            RType symbolType = RTypeFactory.createSymbolType(call.getProject());
            for (RPsiElement argument : call.getArguments()) {
                for (RubyExpectedArgumentTypeProvider extension : this.getEnabledExpectedTypeProviders()) {
                    RHashType parameterHashType;
                    RTypeWithNilability parameterTypeWithNilability = extension.getExpectedArgumentTypeWithNilability((RPossibleCall)call, argument);
                    if (parameterTypeWithNilability == null) continue;
                    RType parameterType = parameterTypeWithNilability.getType();
                    RType argumentType = RTypeUtil.getType((PsiElement)argument);
                    RPsiElement assocKey = (RPsiElement)ObjectUtils.doIfCast((Object)argument, RAssoc.class, RAssoc::getKey);
                    RPsiElement assocValue = (RPsiElement)ObjectUtils.doIfCast((Object)argument, RAssoc.class, RAssoc::getValue);
                    PsiElement element = (PsiElement)ObjectUtils.coalesce((Object)assocValue, (Object)assocKey);
                    if (parameterType instanceof RHashType && (parameterHashType = (RHashType)parameterType).getKeyType().equals(symbolType) && element != null) {
                        if (!(argumentType instanceof RHashType)) continue;
                        RHashType argumentHashType = (RHashType)argumentType;
                        RType expectedType = parameterHashType.getValueType();
                        RType actualType = argumentHashType.getValueType();
                        this.checkExpectedType(expectedType, actualType, element, extension.getMismatchedTypeQuickFixes(element));
                        continue;
                    }
                    this.checkExpectedType(parameterType, argumentType, (PsiElement)argument, extension.getMismatchedTypeQuickFixes((PsiElement)argument));
                    if (!this.myCheckNilability) continue;
                    RTypeWithNilability actualTypeWithNilability = new RTypeWithNilability(argumentType, NilAnalysisUtil.getCanBeNil(argument, holder));
                    this.checkExpectedNilability(parameterTypeWithNilability, actualTypeWithNilability, (PsiElement)argument, extension.getMismatchedTypeQuickFixes((PsiElement)argument));
                }
            }
        }

        public void visitRAssignmentExpression(@NotNull RAssignmentExpression assignment) {
            RArrayIndexing indexing;
            RDotReference reference;
            if (assignment == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            if (ObjectUtils.coalesce((Object)(reference = (RDotReference)ObjectUtils.tryCast((Object)assignment.getObject(), RDotReference.class)), (Object)(indexing = (RArrayIndexing)ObjectUtils.tryCast((Object)assignment.getObject(), RArrayIndexing.class))) == null || assignment.getOperationType() != RubyTokenTypes.tASSGN) {
                return;
            }
            RPsiElement value = assignment.getValue();
            if (value == null) {
                return;
            }
            RPsiElement singleArgument = (RPsiElement)ContainerUtil.getOnlyItem((Collection)assignment.getArguments());
            if (singleArgument == null) {
                return;
            }
            ControlFlowHolder holder = TypeInferenceContext.getControlFlowHolder((PsiElement)assignment);
            if (holder == null) {
                return;
            }
            for (RubyExpectedArgumentTypeProvider extension : this.getEnabledExpectedTypeProviders()) {
                RTypeWithNilability parameterTypeWithNilability = extension.getExpectedArgumentTypeWithNilability((RPossibleCall)assignment, singleArgument);
                if (parameterTypeWithNilability == null) continue;
                RType parameterType = parameterTypeWithNilability.getType();
                RType argumentType = RTypeUtil.getType((PsiElement)singleArgument);
                RTypeWithNilability actualTypeWithNilability = new RTypeWithNilability(argumentType, NilAnalysisUtil.getCanBeNil(singleArgument, holder));
                this.checkExpectedType(parameterType, argumentType, (PsiElement)value, extension.getMismatchedTypeQuickFixes((PsiElement)value));
                if (!this.myCheckNilability) continue;
                this.checkExpectedNilability(parameterTypeWithNilability, actualTypeWithNilability, (PsiElement)value, extension.getMismatchedTypeQuickFixes((PsiElement)value));
            }
            if (this.myCheckNilability) {
                RubyExpectedArgumentNilabilityProvider.EP_NAME.getExtensionList().forEach(nilabilityProvider -> {
                    ThreeState canBeNil = nilabilityProvider.getExpectedArgumentNilability((RPossibleCall)assignment, singleArgument);
                    if (canBeNil != null && canBeNil != ThreeState.UNSURE) {
                        RType argumentType = RTypeUtil.getType((PsiElement)singleArgument);
                        RTypeWithNilability actualTypeWithNilability = new RTypeWithNilability(argumentType, NilAnalysisUtil.getCanBeNil(singleArgument, holder));
                        this.checkExpectedNilability(canBeNil, actualTypeWithNilability.getCanBeNil(), (PsiElement)value);
                    }
                });
            }
        }

        public void visitRYieldStatement(@NotNull RYieldStatement yield) {
            ControlFlowHolder holder;
            if (yield == null) {
                MyVisitor.$$$reportNull$$$0(5);
            }
            if ((holder = TypeInferenceContext.getControlFlowHolder((PsiElement)yield)) == null) {
                return;
            }
            RType symbolType = RTypeFactory.createSymbolType(yield.getProject());
            for (RPsiElement argument : yield.getArguments()) {
                for (RubyExpectedArgumentTypeProvider extension : this.getEnabledExpectedTypeProviders()) {
                    RTypeWithNilability parameterTypeWithNilability = extension.getExpectedArgumentTypeWithNilability(yield, argument);
                    if (parameterTypeWithNilability == null) continue;
                    RType parameterType = parameterTypeWithNilability.getType();
                    RPsiElement assocValue = (RPsiElement)ObjectUtils.doIfCast((Object)argument, RAssoc.class, RAssoc::getValue);
                    if (parameterType instanceof RHashType && ((RHashType)parameterType).getKeyType().equals(symbolType) && assocValue != null) {
                        RType expectedType = ((RHashType)parameterType).getValueType();
                        RType actualType = RTypeUtil.getType((PsiElement)assocValue);
                        this.checkExpectedType(expectedType, actualType, (PsiElement)assocValue, extension.getMismatchedTypeQuickFixes((PsiElement)assocValue));
                        continue;
                    }
                    RType argumentType = RTypeUtil.getType((PsiElement)argument);
                    this.checkExpectedType(parameterType, argumentType, (PsiElement)argument, extension.getMismatchedTypeQuickFixes((PsiElement)argument));
                    if (!this.myCheckNilability) continue;
                    RTypeWithNilability actualTypeWithNilability = new RTypeWithNilability(argumentType, NilAnalysisUtil.getCanBeNil(argument, holder));
                    this.checkExpectedNilability(parameterTypeWithNilability, actualTypeWithNilability, (PsiElement)argument, extension.getMismatchedTypeQuickFixes((PsiElement)argument));
                }
            }
        }

        @NotNull
        private List<RubyExpectedArgumentTypeProvider> getEnabledExpectedTypeProviders() {
            List list = ContainerUtil.filter((Collection)RubyExpectedArgumentTypeProvider.EP_NAME.getExtensionList(), it -> !this.myDisabledExpectedTypeProviders.contains(it.getId()));
            if (list == null) {
                MyVisitor.$$$reportNull$$$0(6);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disabledExpectedTypeProviders";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "yield";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedArgumentTypeInspection$MyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyMismatchedArgumentTypeInspection$MyVisitor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnabledExpectedTypeProviders";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRBinaryExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRCall";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRAssignmentExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "visitRYieldStatement";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 6 -> new IllegalStateException(string);
            };
        }
    }
}

