/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.mismatchedTypes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.util.ThreeState;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.ArgMapping;
import org.jetbrains.plugins.ruby.ruby.codeInsight.annotations.MethodParameterTypesData;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.RMethodSymbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeFactory;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeWithNilability;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.serializable.SerializableType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RYieldStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;

public interface RubyExpectedArgumentTypeProvider {
    public static final ExtensionPointName<RubyExpectedArgumentTypeProvider> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.ruby.ruby.expectedArgumentTypeProvider");

    @NlsContexts.Label
    @Nullable
    default public String getDisplayName() {
        return null;
    }

    @Nullable
    default public RTypeWithNilability getExpectedArgumentTypeWithNilability(@NotNull RBinaryExpression expression, @NotNull RPsiElement argument) {
        if (expression == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(0);
        }
        if (argument == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    default public RTypeWithNilability getExpectedArgumentTypeWithNilability(@NotNull RPossibleCall call, @NotNull RPsiElement argument) {
        if (call == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(2);
        }
        if (argument == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    @Nullable
    default public RTypeWithNilability getExpectedArgumentTypeWithNilability(@NotNull RYieldStatement yield, @NotNull RPsiElement argument) {
        if (yield == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(4);
        }
        if (argument == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    default public String getId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    default public @NotNull LocalQuickFix @NotNull [] getMismatchedTypeQuickFixes(@NotNull PsiElement element) {
        if (element == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(7);
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(8);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    default public boolean isMismatchedTypeChecksEnabled(@NotNull RBinaryExpression expression, @NotNull RPsiElement argument) {
        if (expression == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(9);
        }
        if (argument == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(10);
        }
        return true;
    }

    @Nullable
    public static RTypeWithNilability getArgumentTypeWithNilability(@NotNull RPossibleCall invocationPoint, @NotNull RPsiElement argument, @NotNull RMethodSymbol methodSymbol, @NotNull Map<ArgumentInfo, ArgMapping.MappingRange> mapping, @NotNull MethodParameterTypesData methodParameterTypesData) {
        String argumentName;
        if (invocationPoint == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(11);
        }
        if (argument == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(12);
        }
        if (methodSymbol == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(13);
        }
        if (mapping == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(14);
        }
        if (methodParameterTypesData == null) {
            RubyExpectedArgumentTypeProvider.$$$reportNull$$$0(15);
        }
        Project project = methodSymbol.getProject();
        ArgumentInfo parameterInfo = ArgMapping.getArgumentInfoByIncomingArgumentNo(mapping, (int)invocationPoint.getArguments().indexOf(argument));
        String string = argumentName = parameterInfo != null ? parameterInfo.getName() : null;
        if (argumentName == null) {
            return null;
        }
        SerializableType parameterSerializableType = methodParameterTypesData.getParameterType(argumentName);
        if (parameterSerializableType == null) {
            return null;
        }
        RTypeWithNilability parameterTypeWithNilability = RTypeWithNilability.fromSerializableType(parameterSerializableType, project, ThreeState.NO, (PsiElement)invocationPoint);
        ArgumentInfo.Type argumentType = parameterInfo.getType();
        if (argumentType == ArgumentInfo.Type.ARRAY) {
            RType parameterType = parameterTypeWithNilability.getType();
            if (!(parameterType instanceof RCollectionType)) {
                return null;
            }
            return parameterTypeWithNilability.swapType((RType)((RCollectionType)parameterType).getIndexType());
        }
        if (argumentType.isKeyword()) {
            RType symbolType = RTypeFactory.createSymbolType(project);
            RType hashType = RTypeFactory.createHashType(project, symbolType, parameterTypeWithNilability.getType());
            return new RTypeWithNilability(hashType, false);
        }
        return parameterTypeWithNilability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yield";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyExpectedArgumentTypeProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invocationPoint";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodSymbol";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodParameterTypesData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/mismatchedTypes/RubyExpectedArgumentTypeProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMismatchedTypeQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedArgumentTypeWithNilability";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMismatchedTypeQuickFixes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMismatchedTypeChecksEnabled";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentTypeWithNilability";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }
}

