/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.jumpError;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBreakStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RDefinedStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RLoopStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RNextStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RRedoStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RRetryStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RClassObject;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.controlStructures.RLambda;

public class RubyJumpErrorVisitor
extends RubyInspectionVisitor {
    private static final String LAMBDA_COMMAND = "lambda";

    public RubyJumpErrorVisitor(ProblemsHolder holder) {
        super(holder);
    }

    public void visitRReturnStatement(@NotNull RReturnStatement rReturnStatement) {
        if (rReturnStatement == null) {
            RubyJumpErrorVisitor.$$$reportNull$$$0(0);
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)rReturnStatement, (Class[])new Class[]{RContainer.class, RBlockCall.class, RLambda.class});
        while (parent != null && !(parent instanceof RMethod) && !(parent instanceof RLambda)) {
            if (RubyPsiUtil.isCallOfType(parent, RubyCallTypes.DEFINE_METHOD_CALL) || RubyPsiUtil.isCallWithCommand(parent, LAMBDA_COMMAND)) {
                return;
            }
            if (parent instanceof RClass || parent instanceof RClassObject || parent instanceof RModule) {
                this.registerProblem((PsiElement)rReturnStatement, RBundle.message((String)"inspection.jump.error.return.inside.class.or.module"));
                return;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{RContainer.class, RBlockCall.class, RLambda.class});
        }
        return;
    }

    public void visitRBreakStatement(@NotNull RBreakStatement statement) {
        RLoopStatement loop;
        if (statement == null) {
            RubyJumpErrorVisitor.$$$reportNull$$$0(1);
        }
        if ((loop = statement.getLoop()) == null && !(statement.getParent() instanceof RDefinedStatement)) {
            this.registerProblem((PsiElement)statement, RBundle.message((String)"inspection.jump.error.no.loop.for.break"));
        }
    }

    public void visitRNextStatement(@NotNull RNextStatement statement) {
        RLoopStatement loop;
        if (statement == null) {
            RubyJumpErrorVisitor.$$$reportNull$$$0(2);
        }
        if ((loop = statement.getLoop()) == null && !(statement.getParent() instanceof RDefinedStatement)) {
            this.registerProblem((PsiElement)statement, RBundle.message((String)"inspection.jump.error.no.loop.for.next"));
        }
    }

    public void visitRRedoStatement(@NotNull RRedoStatement statement) {
        RLoopStatement loop;
        if (statement == null) {
            RubyJumpErrorVisitor.$$$reportNull$$$0(3);
        }
        if ((loop = statement.getLoop()) == null && !(statement.getParent() instanceof RDefinedStatement)) {
            this.registerProblem((PsiElement)statement, RBundle.message((String)"inspection.jump.error.no.loop.for.redo"));
        }
    }

    public void visitRRetryStatement(@NotNull RRetryStatement statement) {
        RPsiElement context;
        if (statement == null) {
            RubyJumpErrorVisitor.$$$reportNull$$$0(4);
        }
        if ((context = statement.getRetryContext()) == null && !(statement.getParent() instanceof RDefinedStatement)) {
            this.registerProblem((PsiElement)statement, RBundle.message((String)"inspection.jump.error.no.context.for.retry"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rReturnStatement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/jumpError/RubyJumpErrorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRReturnStatement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBreakStatement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRNextStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRRedoStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRRetryStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

