/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.ifcanbecase;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypesCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElsifBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyCaseUtil {
    @Nullable
    public static RPsiElement getSwitchExpression(RIfStatement statement, int minimumBranches) {
        List elsifBlocks = statement.getElsifBlocks();
        int elsifBlocksSize = elsifBlocks.size();
        if (elsifBlocksSize < minimumBranches) {
            return null;
        }
        RCondition condition = statement.getCondition();
        RPsiElement possibleSwitchExpression = RubyCaseUtil.determinePossibleSwitchExpressions((RPsiElement)condition);
        if (possibleSwitchExpression == null) {
            return null;
        }
        boolean flag = true;
        for (RElsifBlock block : statement.getElsifBlocks()) {
            RCondition blockCondition = block.getCondition();
            if (blockCondition == null) {
                flag = false;
                break;
            }
            PsiElement firstChild = blockCondition.getFirstChild();
            if (!(firstChild instanceof RPsiElement) || RubyCaseUtil.canBeMadeIntoCase((RPsiElement)firstChild, possibleSwitchExpression)) continue;
            flag = false;
            break;
        }
        return flag ? possibleSwitchExpression : null;
    }

    private static boolean canBeMadeIntoCase(@NotNull RPsiElement element, @NotNull RPsiElement expression) {
        if (element == null) {
            RubyCaseUtil.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            RubyCaseUtil.$$$reportNull$$$0(1);
        }
        if (!(element instanceof RBinaryExpression)) {
            return false;
        }
        RBinaryExpression binaryExpression = (RBinaryExpression)element;
        IElementType operation = binaryExpression.getOperationType();
        RPsiElement lhs = binaryExpression.getLeftOperand();
        RPsiElement rhs = binaryExpression.getRightOperand();
        if (lhs == null || rhs == null) {
            return false;
        }
        if (operation.equals(RubyTokenTypesCore.tOR)) {
            return RubyCaseUtil.canBeMadeIntoCase(lhs, expression) && RubyCaseUtil.canBeMadeIntoCase(rhs, expression);
        }
        if (operation.equals(RubyTokenTypesCore.tEQ) || operation.equals(RubyTokenTypes.tEQQ)) {
            boolean left = RubyCaseUtil.checkForEquals(expression, lhs);
            boolean right = RubyCaseUtil.checkForEquals(expression, rhs);
            return left || right;
        }
        return false;
    }

    private static boolean canBeSwitchLabel(RPsiElement element) {
        if (element == null) {
            return false;
        }
        return element instanceof RIdentifier && (((RIdentifier)element).isParameter() || ((RIdentifier)element).isLocalVariable());
    }

    private static boolean checkForEquals(@NotNull RPsiElement expression, @NotNull RPsiElement rhs) {
        if (expression == null) {
            RubyCaseUtil.$$$reportNull$$$0(2);
        }
        if (rhs == null) {
            RubyCaseUtil.$$$reportNull$$$0(3);
        }
        String text = expression.getText();
        String text1 = rhs.getText();
        return text != null && text.equals(text1);
    }

    @Nullable
    private static RPsiElement determinePossibleSwitchExpressions(RPsiElement condition) {
        if (condition == null) {
            return null;
        }
        PsiElement expression = condition.getFirstChild();
        if (!(expression instanceof RBinaryExpression)) {
            return null;
        }
        RBinaryExpression binaryExpression = (RBinaryExpression)expression;
        IElementType operation = binaryExpression.getOperationType();
        RPsiElement lhs = binaryExpression.getLeftOperand();
        RPsiElement rhs = binaryExpression.getRightOperand();
        if (operation.equals(RubyTokenTypesCore.tOR)) {
            return RubyCaseUtil.determinePossibleSwitchExpressions(lhs);
        }
        if (operation.equals(RubyTokenTypesCore.tEQ) || operation.equals(RubyTokenTypes.tEQQ)) {
            if (RubyCaseUtil.canBeSwitchLabel(lhs)) {
                return lhs;
            }
            if (RubyCaseUtil.canBeSwitchLabel(rhs)) {
                return rhs;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rhs";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/ifcanbecase/RubyCaseUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeMadeIntoCase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForEquals";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

