/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.hash;

import com.intellij.psi.PsiElement;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyHashType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RArrayToArguments;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;

public final class RubyHashUtil {
    public static RubyHashType checkSyntax(RArrayIndexing arrayIndexing) {
        PsiElement nameIndexing = arrayIndexing.getFirstChild();
        if (nameIndexing == null || !"Hash".equals(nameIndexing.getText())) {
            return RubyHashType.NO_ACTION_TYPE;
        }
        List indexes = arrayIndexing.getIndexes();
        int size = indexes.size();
        if (size == 0) {
            return RubyHashType.NO_ACTION_TYPE;
        }
        RPsiElement firstIndex = (RPsiElement)indexes.get(0);
        if (firstIndex instanceof RArray) {
            if (RubyHashUtil.checkArray(indexes, false)) {
                return RubyHashType.BAD_SYNTAX_TYPE;
            }
            return RubyHashType.ARRAY_TYPE;
        }
        if (firstIndex instanceof RAssoc) {
            for (RPsiElement index : indexes) {
                if (index instanceof RAssoc) continue;
                return RubyHashType.BAD_SYNTAX_TYPE;
            }
            return RubyHashType.ASSOC_TYPE;
        }
        if (firstIndex instanceof RBlockCall || firstIndex instanceof RCall) {
            return RubyHashType.NO_ACTION_TYPE;
        }
        for (RPsiElement index : indexes) {
            if (!(index instanceof RAssoc) && !(index instanceof RArray)) continue;
            return RubyHashType.BAD_SYNTAX_TYPE;
        }
        if (size > 1 && size % 2 == 1 && !(firstIndex instanceof RArrayToArguments)) {
            return RubyHashType.ODD_NUMBER_OF_PARAMETERS_TYPE;
        }
        return RubyHashType.LIST_TYPE;
    }

    private static boolean checkArray(List<? extends RPsiElement> elements, boolean last) {
        int size = elements.size();
        if (size == 0) {
            return false;
        }
        if (last) {
            if (size != 2) {
                return true;
            }
            RPsiElement first = elements.get(0);
            RPsiElement second = elements.get(1);
            return first instanceof RArray || first instanceof RAssoc || second instanceof RArray || second instanceof RAssoc;
        }
        RPsiElement first = elements.get(0);
        if (size == 1) {
            return !(first instanceof RArray) || RubyHashUtil.checkArray(((RArray)first).getElements(), false);
        }
        for (RPsiElement rPsiElement : elements) {
            if (rPsiElement instanceof RArray) continue;
            return true;
        }
        for (RPsiElement rPsiElement : elements) {
            if (!RubyHashUtil.checkArray(((RArray)rPsiElement).getElements(), true)) continue;
            return true;
        }
        return false;
    }

    public static List<RPsiElement> collectKeysFromArray(List<? extends RPsiElement> elements, boolean last) {
        LinkedList<RPsiElement> list = new LinkedList<RPsiElement>();
        int size = elements.size();
        if (size == 0) {
            return list;
        }
        if (last) {
            list.add(elements.get(0));
        } else {
            RPsiElement first = elements.get(0);
            if (size == 1) {
                list.addAll(RubyHashUtil.collectKeysFromArray(((RArray)first).getElements(), false));
            } else {
                for (RPsiElement rPsiElement : elements) {
                    list.addAll(RubyHashUtil.collectKeysFromArray(((RArray)rPsiElement).getElements(), true));
                }
            }
        }
        return list;
    }
}

