/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.hash;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyHashTypeChecker;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyHashUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyRemoveHashKeyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;

public final class RubyDuplicatedKeysInHashInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyDuplicatedKeysInHashInspection.$$$reportNull$$$0(0);
        }
        return new DuplicateKeysInHashVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyDuplicatedKeysInHashInspection", "buildVisitor"));
    }

    private static class DuplicateKeysInHashVisitor
    extends RubyInspectionVisitor {
        DuplicateKeysInHashVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRAssocList(@NotNull RAssocList rAssocList) {
            if (rAssocList == null) {
                DuplicateKeysInHashVisitor.$$$reportNull$$$0(0);
            }
            this.checkAssocList(rAssocList.getElements());
        }

        public void visitRListOfExpressions(@NotNull RListOfExpressions rListOfExpressions) {
            if (rListOfExpressions == null) {
                DuplicateKeysInHashVisitor.$$$reportNull$$$0(1);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)rListOfExpressions, RCall.class, (boolean)true) == null) {
                return;
            }
            HashSet<String> set = new HashSet<String>();
            for (PsiElement child = rListOfExpressions.getLastChild(); child != null; child = child.getPrevSibling()) {
                RPsiElement key;
                if (!(child instanceof RAssoc) || (key = ((RAssoc)child).getKey()) == null || !(key instanceof RSymbol) && !(key instanceof RAssocKey) || set.add(key.getName())) continue;
                this.registerProblemWithFixes((RPsiElement)((RAssoc)child));
            }
        }

        public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
            if (arrayIndexing == null) {
                DuplicateKeysInHashVisitor.$$$reportNull$$$0(2);
            }
            switch (RubyHashUtil.checkSyntax(arrayIndexing)) {
                case ARRAY_TYPE: {
                    this.checkArray(arrayIndexing.getIndexes());
                    break;
                }
                case ASSOC_TYPE: {
                    this.checkAssocList(arrayIndexing.getIndexes());
                    break;
                }
                case LIST_TYPE: {
                    this.checkList(arrayIndexing.getIndexes());
                    break;
                }
            }
        }

        private void checkList(List<RPsiElement> indexes) {
            RPsiElement element;
            int i;
            HashChecker checker = new HashChecker(false);
            for (i = 0; i < indexes.size(); i += 2) {
                element = indexes.get(i);
                checker.acceptElement(element);
            }
            for (i = 0; i < indexes.size(); i += 2) {
                element = indexes.get(i);
                if (!checker.checkElementCount(element)) continue;
                this.registerProblemWithFixes(element);
            }
        }

        private void checkAssocList(List<RPsiElement> list) {
            HashChecker checker = new HashChecker(true);
            for (RPsiElement element : list) {
                if (!(element instanceof RAssoc)) continue;
                checker.acceptElement(((RAssoc)element).getKey());
            }
            for (RPsiElement element : list) {
                RPsiElement key;
                if (!(element instanceof RAssoc) || !checker.checkElementCount(key = ((RAssoc)element).getKey())) continue;
                this.registerProblemWithFixes(key);
            }
        }

        private void checkArray(List<RPsiElement> indexes) {
            HashChecker checker = new HashChecker(false);
            List<RPsiElement> keyList = RubyHashUtil.collectKeysFromArray(indexes, false);
            for (RPsiElement element : keyList) {
                checker.acceptElement(element);
            }
            for (RPsiElement element : keyList) {
                if (!checker.checkElementCount(element)) continue;
                this.registerProblemWithFixes(element);
            }
        }

        private void registerProblemWithFixes(RPsiElement element) {
            this.registerProblem((PsiElement)element, RBundle.message((String)"inspection.duplicated.keys.in.hash.msg"), new RubyRemoveHashKeyFix());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rAssocList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rListOfExpressions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrayIndexing";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyDuplicatedKeysInHashInspection$DuplicateKeysInHashVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRAssocList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRListOfExpressions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRArrayIndexing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class HashChecker {
        private final List<? extends RubyHashTypeChecker> checkerList;

        HashChecker(boolean isAssocChecker) {
            ArrayList<? extends RubyHashTypeChecker> list = new ArrayList<RubyHashTypeChecker>();
            list.add(new RubyHashTypeChecker(){

                @Override
                public boolean isInstance(RPsiElement element) {
                    return element instanceof RLiteral;
                }

                @Override
                public String getElementText(RPsiElement element) {
                    if (element instanceof RStringLiteral) {
                        RStringLiteral string = (RStringLiteral)element;
                        return string.getContentValue();
                    }
                    return ((RLiteral)element).getContent();
                }
            });
            if (isAssocChecker) {
                list.add(new RubyHashTypeChecker(){

                    @Override
                    public boolean isInstance(RPsiElement element) {
                        return element instanceof RSymbol || element instanceof RAssocKey;
                    }

                    @Override
                    public String getElementText(RPsiElement element) {
                        if (element instanceof RSymbol) {
                            return ((RSymbol)element).getContent().getText();
                        }
                        return element.getName();
                    }
                });
            } else {
                list.add(new RubyHashTypeChecker(){

                    @Override
                    public boolean isInstance(RPsiElement element) {
                        return element instanceof RSymbol;
                    }

                    @Override
                    public String getElementText(RPsiElement element) {
                        return ((RSymbol)element).getContent().getText();
                    }
                });
            }
            this.checkerList = list;
        }

        public boolean acceptElement(RPsiElement element) {
            boolean result = false;
            for (RubyHashTypeChecker rubyHashTypeChecker : this.checkerList) {
                if (!rubyHashTypeChecker.isInstance(element)) continue;
                rubyHashTypeChecker.put(element);
                result = true;
            }
            return result;
        }

        public boolean checkElementCount(RPsiElement element) {
            for (RubyHashTypeChecker rubyHashTypeChecker : this.checkerList) {
                if (!rubyHashTypeChecker.isInstance(element)) continue;
                return rubyHashTypeChecker.get(element) > 1;
            }
            return false;
        }
    }
}

