/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.hash;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

public final class RubyConvertAllHashesInFileInspections
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyConvertAllHashesInFileInspections.$$$reportNull$$$0(0);
        }
        return new RubyConvertHashesVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyConvertAllHashesInFileInspections", "buildVisitor"));
    }

    private static class RubyConvertHashesVisitor
    extends RubyInspectionVisitor {
        RubyConvertHashesVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRAssocList(@NotNull RAssocList rAssocList) {
            if (rAssocList == null) {
                RubyConvertHashesVisitor.$$$reportNull$$$0(0);
            }
            if (rAssocList.getLanguageLevel() == LanguageLevel.RUBY18) {
                return;
            }
            for (RAssoc assoc : rAssocList.getAssocElements()) {
                if (!(assoc.getKey() instanceof RSymbol) || assoc.getValue() == null) continue;
                this.registerProblem((PsiElement)assoc, RBundle.message((String)"inspection.hash.convert.in.file"), new ConvertHashToNewStyleFix());
            }
        }

        public void visitRAssoc(@NotNull RAssoc rAssoc) {
            if (rAssoc == null) {
                RubyConvertHashesVisitor.$$$reportNull$$$0(1);
            }
            if (rAssoc.getLanguageLevel() == LanguageLevel.RUBY18) {
                return;
            }
            if (rAssoc.getKey() instanceof RSymbol && rAssoc.getValue() != null) {
                this.registerProblem((PsiElement)rAssoc, RBundle.message((String)"inspection.hash.convert.in.file"), new ConvertHashToNewStyleFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rAssocList";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rAssoc";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyConvertAllHashesInFileInspections$RubyConvertHashesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRAssocList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRAssoc";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConvertHashToNewStyleFix
    extends RubyFix {
        private ConvertHashToNewStyleFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            RAssoc assoc;
            RPsiElement value;
            if (project == null) {
                ConvertHashToNewStyleFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ConvertHashToNewStyleFix.$$$reportNull$$$0(1);
            }
            if ((value = (assoc = (RAssoc)descriptor.getPsiElement()).getValue()) == null) {
                return;
            }
            String text = "{ " + assoc.getKeyText() + ": " + value.getText() + " }";
            LanguageLevel languageLevel = assoc.getLanguageLevel();
            assert (languageLevel != null);
            RPsiElement element = (RPsiElement)ContainerUtil.getFirstItem((List)RubyElementFactoryCore.getNotEmptyTopLevelElements((Project)project, (String)text, (LanguageLevel)languageLevel));
            if (!(element instanceof RAssocList)) {
                return;
            }
            List assocElements = ((RAssocList)element).getAssocElements();
            if (assocElements.isEmpty()) {
                return;
            }
            assoc.replace((PsiElement)assocElements.get(0));
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.hash.convert.in.file.fix");
            if (string == null) {
                ConvertHashToNewStyleFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyConvertAllHashesInFileInspections$ConvertHashToNewStyleFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyConvertAllHashesInFileInspections$ConvertHashToNewStyleFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

