/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.frozenString;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.collections.RCollectionType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.impl.RFrozenType;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelService;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RAssignmentExpressionNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.expressions.RShiftExpressionImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;

final class RubyModifiedFrozenObjectVisitor
extends RubyInspectionVisitor {
    private static final Set<String> SHIFT_MODIFIABLE_TYPES = Set.of("Array", "Set", "String");

    RubyModifiedFrozenObjectVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            RubyModifiedFrozenObjectVisitor.$$$reportNull$$$0(0);
        }
        super(holder);
    }

    public void visitRArrayIndexing(@NotNull RArrayIndexing arrayIndexing) {
        if (arrayIndexing == null) {
            RubyModifiedFrozenObjectVisitor.$$$reportNull$$$0(1);
        }
        RAssignmentExpression assignment = RAssignmentExpressionNavigator.getAssignmentByLeftPart((PsiElement)arrayIndexing);
        RFrozenType receiverType = RubyModifiedFrozenObjectVisitor.getFrozenType(arrayIndexing.getReceiver());
        if (assignment != null && receiverType != null) {
            this.registerFreezeError((PsiElement)ObjectUtils.coalesce((Object)arrayIndexing.getReceiver(), (Object)arrayIndexing), receiverType);
        }
    }

    public void visitRBinaryExpression(@NotNull RBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            RubyModifiedFrozenObjectVisitor.$$$reportNull$$$0(2);
        }
        if (!(binaryExpression instanceof RShiftExpressionImpl) || binaryExpression.getOperationType() != RubyTokenTypes.tLSHFT) {
            return;
        }
        RPsiElement operand = binaryExpression.getLeftOperand();
        RFrozenType receiverType = RubyModifiedFrozenObjectVisitor.getFrozenType(operand);
        if (receiverType != null && RubyModifiedFrozenObjectVisitor.isShiftModifiableType((RType)receiverType)) {
            this.registerFreezeError((PsiElement)operand, receiverType);
        }
    }

    public void visitRDotReference(@NotNull RDotReference reference) {
        RFrozenType receiverType;
        if (reference == null) {
            RubyModifiedFrozenObjectVisitor.$$$reportNull$$$0(3);
        }
        if ((receiverType = RubyModifiedFrozenObjectVisitor.getReceiverFrozenType((RReference)reference)) != null) {
            this.registerFreezeError((PsiElement)ObjectUtils.coalesce((Object)reference.getReceiver(), (Object)reference), receiverType);
        }
    }

    @Nullable
    private static RFrozenType getFrozenType(@Nullable RPsiElement element) {
        RFrozenType frozenType;
        RType rType = RTypeUtil.getCoveringExpressionType((PsiElement)element);
        return rType instanceof RFrozenType ? (frozenType = (RFrozenType)rType) : null;
    }

    @Nullable
    private static RFrozenType getReceiverFrozenType(@NotNull RReference call) {
        RStringLiteral literal;
        RPsiElement receiver;
        if (call == null) {
            RubyModifiedFrozenObjectVisitor.$$$reportNull$$$0(4);
        }
        if ((receiver = call.getReceiver()) == null) {
            return null;
        }
        if (receiver instanceof RStringLiteral && (literal = (RStringLiteral)receiver).hasExpressionSubstitutions() && LanguageLevel.RUBY27.isLessThan(literal.getLanguageLevel())) {
            return null;
        }
        RPsiElement callValue = call.getValue();
        if (callValue == null) {
            return null;
        }
        return callValue.getText().endsWith("!") ? RubyModifiedFrozenObjectVisitor.getFrozenType(receiver) : null;
    }

    private static boolean isShiftModifiableType(@NotNull RType type) {
        RType originalType;
        if (type == null) {
            RubyModifiedFrozenObjectVisitor.$$$reportNull$$$0(5);
        }
        if ((originalType = RFrozenType.clearFrozenStatus(type)) instanceof RSymbolType) {
            RSymbolType symbolType = (RSymbolType)originalType;
            Symbol symbol = symbolType.getSymbol();
            return symbol.getName() != null && SHIFT_MODIFIABLE_TYPES.contains(symbol.getName());
        }
        return originalType instanceof RCollectionType;
    }

    private void registerFreezeError(@NotNull PsiElement element, @NotNull RFrozenType type) {
        if (element == null) {
            RubyModifiedFrozenObjectVisitor.$$$reportNull$$$0(6);
        }
        if (type == null) {
            RubyModifiedFrozenObjectVisitor.$$$reportNull$$$0(7);
        }
        LanguageLevel languageLevel = RubyLanguageLevelService.getLanguageLevelByElement((PsiElement)element);
        if (type.isChilled() && LanguageLevel.RUBY33.isLessThan((LanguageLevel)ObjectUtils.coalesce((Object)languageLevel, (Object)LanguageLevel.latest()))) {
            this.registerProblem(element, RBundle.message((String)"inspection.modified.object.problem.name"), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
        } else {
            this.registerProblem(element, RBundle.message((String)"inspection.modified.object.problem.name"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayIndexing";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/frozenString/RubyModifiedFrozenObjectVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRArrayIndexing";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBinaryExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRDotReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getReceiverFrozenType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isShiftModifiableType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "registerFreezeError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

