/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.deprecatedsyntax;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RColonReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;

public final class RubyDeprecatedSyntaxInspection
extends LocalInspectionTool {
    private static final Map<String, String> DEPRECATED_CALLS = new HashMap<String, String>();
    private static final String RESERVED_RUBY_NAME = "Ruby";

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyDeprecatedSyntaxInspection.$$$reportNull$$$0(0);
        }
        return new RubyDeprecatedSyntaxVisitor(holder);
    }

    static {
        DEPRECATED_CALLS.put("include_class", "java_import");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/deprecatedsyntax/RubyDeprecatedSyntaxInspection", "buildVisitor"));
    }

    private static class RubyDeprecatedSyntaxVisitor
    extends RubyInspectionVisitor {
        RubyDeprecatedSyntaxVisitor(ProblemsHolder holder) {
            super(holder);
        }

        public void visitRModule(@NotNull RModule rModule) {
            if (rModule == null) {
                RubyDeprecatedSyntaxVisitor.$$$reportNull$$$0(0);
            }
            this.checkRubyNameCollision((RElementWithFQN)rModule);
        }

        public void visitRClass(@NotNull RClass rClass) {
            if (rClass == null) {
                RubyDeprecatedSyntaxVisitor.$$$reportNull$$$0(1);
            }
            this.checkRubyNameCollision((RElementWithFQN)rClass);
        }

        public void visitRConstant(@NotNull RConstant rConstant) {
            if (rConstant == null) {
                RubyDeprecatedSyntaxVisitor.$$$reportNull$$$0(2);
            }
            if (rConstant.isDeclaration()) {
                this.checkRubyNameCollision((RElementWithFQN)rConstant);
            }
        }

        public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
            if (rIdentifier == null) {
                RubyDeprecatedSyntaxVisitor.$$$reportNull$$$0(3);
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rIdentifier);
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
            if (!JRubySdkUtil.isJRubySDK(sdk)) {
                return;
            }
            String text = rIdentifier.getText();
            String replace = DEPRECATED_CALLS.get(text);
            if (replace != null) {
                this.registerProblem((PsiElement)rIdentifier, RBundle.message((String)"inspection.deprecated.syntax"), ProblemHighlightType.LIKE_DEPRECATED, new ConvertToRecommendedSymbolFix(replace));
            }
        }

        @Nullable
        private static Pair<PsiElement, String> getNameElementAndType(@NotNull PsiElement element) {
            if (element == null) {
                RubyDeprecatedSyntaxVisitor.$$$reportNull$$$0(4);
            }
            String typeString = null;
            if (element instanceof RClass) {
                RClass rClass = (RClass)element;
                RName name = rClass.getClassName();
                if (name == null) {
                    return null;
                }
                element = name.getFirstChild();
                typeString = RBundle.message((String)"class");
            } else if (element instanceof RModule) {
                RModule rModule = (RModule)element;
                RName name = rModule.getModuleName();
                if (name == null) {
                    return null;
                }
                element = name.getFirstChild();
                typeString = RBundle.message((String)"module");
            } else if (element instanceof RConstant) {
                RConstant rConstant = (RConstant)element;
                RReference reference = RReferenceNavigator.getReferenceByRightPart((PsiElement)rConstant);
                if (reference != null) {
                    element = reference;
                }
                typeString = RBundle.message((String)"constant");
            }
            if (typeString != null) {
                return Pair.create((Object)element, typeString);
            }
            return null;
        }

        private static boolean referencesShadowedRubyClass(@NotNull PsiElement element) {
            if (element == null) {
                RubyDeprecatedSyntaxVisitor.$$$reportNull$$$0(5);
            }
            if (element instanceof RColonReference) {
                RColonReference colonReference = (RColonReference)element;
                RConstant rubyConstant = (RConstant)colonReference.getConstantList().get(0);
                if (!Objects.equals(rubyConstant.getName(), RubyDeprecatedSyntaxInspection.RESERVED_RUBY_NAME)) {
                    return false;
                }
                Symbol rubySymbol = ResolveUtil.resolveToSymbolWithCaching(rubyConstant.getReference());
                if (rubySymbol != null && !((String)rubySymbol.getFQNWithNesting().asList().get(0)).equals(RubyDeprecatedSyntaxInspection.RESERVED_RUBY_NAME)) {
                    return true;
                }
            }
            return false;
        }

        private void checkRubyNameCollision(@NotNull RElementWithFQN element) {
            if (element == null) {
                RubyDeprecatedSyntaxVisitor.$$$reportNull$$$0(6);
            }
            if (!RubyPsiUtilCore.getLanguageLevel((PsiElement)element).equals((Object)LanguageLevel.RUBY34)) {
                return;
            }
            List nestedNamePath = element.getFQNWithNesting().asList();
            if (nestedNamePath.isEmpty()) {
                return;
            }
            Pair<PsiElement, String> nameElementAndType = RubyDeprecatedSyntaxVisitor.getNameElementAndType((PsiElement)element);
            if (nameElementAndType == null) {
                return;
            }
            PsiElement nameElement = (PsiElement)nameElementAndType.getFirst();
            String typeString = (String)nameElementAndType.getSecond();
            if (((String)nestedNamePath.get(0)).equals(RubyDeprecatedSyntaxInspection.RESERVED_RUBY_NAME)) {
                if (nestedNamePath.size() > 1) {
                    this.registerProblem(nameElement, RBundle.message((String)"inspection.deprecated.definition.in.ruby.namespace", (Object[])new Object[]{typeString}), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                    return;
                }
                this.registerProblem(nameElement, RBundle.message((String)"inspection.deprecated.ruby.identifier"), ProblemHighlightType.LIKE_DEPRECATED, new RubyRenameFix());
                return;
            }
            List namePath = element.getFQN().asList();
            if (((String)namePath.get(0)).equals(RubyDeprecatedSyntaxInspection.RESERVED_RUBY_NAME) && namePath.size() > 1 && !RubyDeprecatedSyntaxVisitor.referencesShadowedRubyClass(nameElement)) {
                this.registerProblem(nameElement, RBundle.message((String)"inspection.deprecated.definition.in.ruby.namespace", (Object[])new Object[]{typeString}), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rConstant";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rIdentifier";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/deprecatedsyntax/RubyDeprecatedSyntaxInspection$RubyDeprecatedSyntaxVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRModule";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRConstant";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIdentifier";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getNameElementAndType";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "referencesShadowedRubyClass";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkRubyNameCollision";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ConvertToRecommendedSymbolFix
    extends RubyFix {
        private final String replace;

        ConvertToRecommendedSymbolFix(String replace) {
            this.replace = replace;
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                ConvertToRecommendedSymbolFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                ConvertToRecommendedSymbolFix.$$$reportNull$$$0(1);
            }
            if (!((element = descriptor.getPsiElement()) instanceof RIdentifier)) {
                return;
            }
            RIdentifier symbol = (RIdentifier)element;
            String replace = DEPRECATED_CALLS.get(symbol.getText());
            if (replace != null) {
                RPsiElement generated = RubyElementFactoryCore.createElementFromText((PsiElement)symbol, (String)replace);
                symbol.replace((PsiElement)generated);
            }
        }

        @NotNull
        public String getName() {
            String string = RBundle.message((String)"inspection.deprecated.syntax.fix2", (Object[])new Object[]{this.replace});
            if (string == null) {
                ConvertToRecommendedSymbolFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        @Nls
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.deprecated.syntax.fix2.family.name");
            if (string == null) {
                ConvertToRecommendedSymbolFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/deprecatedsyntax/RubyDeprecatedSyntaxInspection$ConvertToRecommendedSymbolFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/deprecatedsyntax/RubyDeprecatedSyntaxInspection$ConvertToRecommendedSymbolFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

