/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.deadcode;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RControlFlow;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.RElementWithFQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBreakStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RNextStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RReturnStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RNamedArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RGroupedExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RTernaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;

public class RubyDeadCodeVisitor
extends RubyInspectionVisitor {
    public RubyDeadCodeVisitor(ProblemsHolder holder) {
        super(holder);
    }

    private static boolean isStaticMethod(@NotNull RMethod method) {
        Symbol symbol;
        if (method == null) {
            RubyDeadCodeVisitor.$$$reportNull$$$0(0);
        }
        if ((symbol = SymbolUtil.getSymbolByContainer((RElementWithFQN)method)) == null) {
            return false;
        }
        Type type = symbol.getType();
        return type.equals(Type.CLASS_METHOD);
    }

    private static boolean isThereIsAliasBetweenMethods(@NotNull RMethod topElement, @NotNull PsiElement bottomElement) {
        int i;
        if (topElement == null) {
            RubyDeadCodeVisitor.$$$reportNull$$$0(1);
        }
        if (bottomElement == null) {
            RubyDeadCodeVisitor.$$$reportNull$$$0(2);
        }
        PsiElement container = topElement.getParent();
        for (i = 0; i < container.getChildren().length && container.getChildren()[i] != topElement; ++i) {
        }
        if (i >= container.getChildren().length) {
            return false;
        }
        boolean result = false;
        while (i < container.getChildren().length) {
            PsiElement psiElement = container.getChildren()[i];
            if (psiElement instanceof RAliasStatement) {
                String methodName;
                RAliasStatement alias = (RAliasStatement)psiElement;
                oldElement = alias.getPsiOldName();
                if (oldElement != null && (methodName = oldElement.getText()).equals(topElement.getName())) {
                    result = true;
                    break;
                }
            } else {
                oldElement = container.getChildren()[i];
                if (oldElement instanceof RCallImpl) {
                    RPsiElement arg1;
                    String methodName;
                    RCallImpl call = (RCallImpl)oldElement;
                    String name = call.getCommand();
                    if (name.equals("alias_method") && call.getArguments().size() == 2 && (methodName = RubyPsiUtilCore.getElementText((PsiElement)(arg1 = (RPsiElement)call.getArguments().get(1)))) != null && methodName.equals(topElement.getName())) {
                        result = true;
                        break;
                    }
                } else if (container.getChildren()[i] == bottomElement) break;
            }
            ++i;
        }
        return result;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            RubyDeadCodeVisitor.$$$reportNull$$$0(3);
        }
        if (element instanceof ScopeHolder) {
            RControlFlow rControlFlow = ((ScopeHolder)element).getControlFlow();
            Object[] flow = rControlFlow.getInstructions();
            BitSet reachable = new BitSet(flow.length);
            for (Instruction instruction : flow) {
                PsiElement instructionElement = instruction.getElement();
                ArrayList allInstructionsForElement = new ArrayList(ContainerUtil.filter((Object[])flow, it -> {
                    ProgressManager.checkCanceled();
                    return Objects.equals(it.getElement(), instructionElement);
                }));
                if (instructionElement == null || RubyDeadCodeVisitor.isStatementHolder(instructionElement) || allInstructionsForElement.stream().anyMatch(it -> rControlFlow.isReachable(it) || reachable.get(it.num()))) continue;
                if (!RubyDeadCodeVisitor.isTransferControlInstruction(instruction)) {
                    RubyDeadCodeVisitor.markAllReachableInstructions((Instruction[])flow, instruction.num(), reachable);
                }
                this.registerProblem(instructionElement, RBundle.message((String)"inspection.dead.code.unreachable.code"));
            }
        }
        if (element instanceof RMethod) {
            RMethod method = (RMethod)element;
            RContainer container = method.getParentContainer();
            assert (container != null);
            List list = RContainerUtilCore.selectElementsByType((List)container.getStructureElements(), RMethod.class);
            boolean methodFound = false;
            for (int i = list.size() - 1; i >= 0; --i) {
                ProgressManager.checkCanceled();
                RMethod possibleSameMethod = (RMethod)list.get(i);
                if (possibleSameMethod == method) {
                    methodFound = true;
                    continue;
                }
                if (!methodFound) continue;
                boolean bl = RubyDeadCodeVisitor.isStaticMethod(method);
                if (!Objects.equals(method.getName(), possibleSameMethod.getName()) || bl != RubyDeadCodeVisitor.isStaticMethod(possibleSameMethod) || !method.getParent().equals(possibleSameMethod.getParent()) || RubyDeadCodeVisitor.hasDifferentSelectors(method, possibleSameMethod) || bl && !method.getFQN().equals(possibleSameMethod.getFQN()) || RubyDeadCodeVisitor.isThereIsAliasBetweenMethods(possibleSameMethod, (PsiElement)method)) continue;
                this.registerProblem((PsiElement)possibleSameMethod, RBundle.message((String)"inspection.dead.code.unreachable.method"));
                return;
            }
        }
    }

    @Override
    protected void registerProblem(PsiElement element, String message) {
        if (element instanceof RExpression) {
            PsiElement parent = element.getParent();
            if (parent instanceof RListOfExpressions) {
                parent = parent.getParent();
            }
            while (!(!(parent instanceof RExpression) || RubyDeadCodeVisitor.isAuxiliaryStatement(parent) || RubyDeadCodeVisitor.isLeftAssociative(parent) && element != parent.getFirstChild() || RubyDeadCodeVisitor.isRightAssociative(parent) && element != parent.getLastChild())) {
                element = parent;
                if (!((parent = element.getParent()) instanceof RListOfExpressions)) continue;
                parent = parent.getParent();
            }
        }
        super.registerProblem(element, message);
    }

    private static boolean hasDifferentSelectors(RMethod method, RMethod possibleSameMethod) {
        Set<String> otherSelectors;
        Set<String> selectors = RubyDeadCodeVisitor.gatherMacRubySelectors(method);
        return !selectors.equals(otherSelectors = RubyDeadCodeVisitor.gatherMacRubySelectors(possibleSameMethod));
    }

    private static Set<String> gatherMacRubySelectors(RMethod method) {
        TreeSet<String> selectors = new TreeSet<String>();
        for (RArgument argument : method.getArguments()) {
            if (!(argument instanceof RNamedArgument)) continue;
            selectors.add(((RNamedArgument)argument).getNameIdentifier().getName());
        }
        return selectors;
    }

    private static boolean isStatementHolder(@Nullable PsiElement element) {
        return RubyDeadCodeVisitor.isAuxiliaryStatement(element) || RubyDeadCodeVisitor.isLeftAssociative(element) || RubyDeadCodeVisitor.isRightAssociative(element);
    }

    private static boolean isAuxiliaryStatement(@Nullable PsiElement element) {
        return element instanceof RCompoundStatement || element instanceof RBodyStatement || element instanceof RCodeBlock || element instanceof RBlockCall || element instanceof RBlockStatement || element instanceof RGroupedExpression || element instanceof RTernaryExpression;
    }

    private static boolean isLeftAssociative(@Nullable PsiElement element) {
        return element instanceof RBinaryExpression;
    }

    private static boolean isRightAssociative(@Nullable PsiElement element) {
        return element instanceof RAssignmentExpression;
    }

    private static boolean isTransferControlInstruction(@NotNull Instruction currentInstruction) {
        if (currentInstruction == null) {
            RubyDeadCodeVisitor.$$$reportNull$$$0(4);
        }
        return currentInstruction.getElement() instanceof RBreakStatement || currentInstruction.getElement() instanceof RReturnStatement || currentInstruction.getElement() instanceof RNextStatement;
    }

    private static void markAllReachableInstructions(Instruction @NotNull [] flow, int startInstructionNum, @NotNull BitSet reachable) {
        if (reachable == null) {
            RubyDeadCodeVisitor.$$$reportNull$$$0(5);
        }
        if (flow == null) {
            RubyDeadCodeVisitor.$$$reportNull$$$0(6);
        }
        ControlFlowUtil.process((Instruction[])flow, (int)startInstructionNum, instruction -> {
            if (!reachable.get(instruction.num())) {
                reachable.set(instruction.num());
                return true;
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottomElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInstruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reachable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/deadcode/RubyDeadCodeVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isStaticMethod";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isThereIsAliasBetweenMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTransferControlInstruction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "markAllReachableInstructions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

