/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.controlflowconversion;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.controlflowconversion.RubyControlFlowStatementFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RBlockStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCondition;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RConditionalStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RIfStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUnlessStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RUntilStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RWhileStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RIfModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RModifierStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUnlessModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RUntilModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modifierStatements.RWhileModStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;

public final class RubyControlFlowConversionInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyControlFlowConversionInspection.$$$reportNull$$$0(0);
        }
        return new RubyControlFlowStatementVisitor(holder, isOnTheFly);
    }

    static boolean isSingleNegativeCondition(@NotNull RCondition condition) {
        PsiElement psiElement;
        PsiElement[] children;
        if (condition == null) {
            RubyControlFlowConversionInspection.$$$reportNull$$$0(1);
        }
        if ((children = condition.getChildren()).length == 1 && (psiElement = children[0]) instanceof RBoolNegExpression) {
            RBoolNegExpression negExpression = (RBoolNegExpression)psiElement;
            RPsiElement element = negExpression.getElement();
            return !PsiTreeUtil.hasErrorElements((PsiElement)negExpression) && !(element instanceof RAssignmentExpression) && !(element instanceof RBoolNegExpression);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/controlflowconversion/RubyControlFlowConversionInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSingleNegativeCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RubyControlFlowStatementVisitor
    extends RubyInspectionVisitor {
        private final boolean myIsOnTheFly;

        public RubyControlFlowStatementVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            super(holder);
            this.myIsOnTheFly = isOnTheFly;
        }

        public void visitRIfStatement(@NotNull RIfStatement ifStatement) {
            if (ifStatement == null) {
                RubyControlFlowStatementVisitor.$$$reportNull$$$0(0);
            }
            if (ifStatement.getElsifBlocks().isEmpty() && ifStatement.getElseBlock() == null) {
                this.checkStatement((RPsiElement)ifStatement);
            }
        }

        public void visitRUnlessStatement(@NotNull RUnlessStatement rUnlessStatement) {
            if (rUnlessStatement == null) {
                RubyControlFlowStatementVisitor.$$$reportNull$$$0(1);
            }
            this.checkStatement((RPsiElement)rUnlessStatement);
        }

        public void visitRWhileStatement(@NotNull RWhileStatement rWhileStatement) {
            if (rWhileStatement == null) {
                RubyControlFlowStatementVisitor.$$$reportNull$$$0(2);
            }
            this.checkStatement((RPsiElement)rWhileStatement);
        }

        public void visitRUntilStatement(@NotNull RUntilStatement rUntilStatement) {
            if (rUntilStatement == null) {
                RubyControlFlowStatementVisitor.$$$reportNull$$$0(3);
            }
            this.checkStatement((RPsiElement)rUntilStatement);
        }

        public void visitRIfModStatement(@NotNull RIfModStatement rIfModStatement) {
            if (rIfModStatement == null) {
                RubyControlFlowStatementVisitor.$$$reportNull$$$0(4);
            }
            this.checkStatement((RPsiElement)rIfModStatement);
        }

        public void visitRUnlessModStatement(@NotNull RUnlessModStatement rUnlessModStatement) {
            if (rUnlessModStatement == null) {
                RubyControlFlowStatementVisitor.$$$reportNull$$$0(5);
            }
            this.checkStatement((RPsiElement)rUnlessModStatement);
        }

        public void visitRWhileModStatement(@NotNull RWhileModStatement rWhileModStatement) {
            if (rWhileModStatement == null) {
                RubyControlFlowStatementVisitor.$$$reportNull$$$0(6);
            }
            this.checkStatement((RPsiElement)rWhileModStatement);
        }

        public void visitRUntilModStatement(@NotNull RUntilModStatement rUntilModStatement) {
            if (rUntilModStatement == null) {
                RubyControlFlowStatementVisitor.$$$reportNull$$$0(7);
            }
            this.checkStatement((RPsiElement)rUntilModStatement);
        }

        private void checkStatement(RPsiElement statement) {
            RCondition condition;
            if (statement instanceof RConditionalStatement && (condition = ((RConditionalStatement)statement).getCondition()) != null) {
                boolean isWarning = RubyControlFlowConversionInspection.isSingleNegativeCondition(condition);
                if (statement instanceof RBlockStatement) {
                    if (((RBlockStatement)statement).getEndToken() != null) {
                        this.registerProblem((RConditionalStatement)statement, condition, isWarning);
                    }
                } else if (statement instanceof RModifierStatement) {
                    this.registerProblem((RConditionalStatement)statement, condition, isWarning);
                }
            }
        }

        private void registerProblem(RConditionalStatement statement, RCondition condition, boolean isWarning) {
            if (isWarning) {
                this.registerProblem((PsiElement)condition, RBundle.message((String)"inspection.control.flow.conversion"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RubyControlFlowStatementFix(statement));
            }
            if (this.myIsOnTheFly) {
                this.registerProblem(statement instanceof RModifierStatement ? ((RModifierStatement)statement).getModifierKeyword() : statement.getFirstChild(), RBundle.message((String)"inspection.control.flow.conversion"), ProblemHighlightType.INFORMATION, new RubyControlFlowStatementFix(statement));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ifStatement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rUnlessStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rWhileStatement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rUntilStatement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rIfModStatement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rUnlessModStatement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rWhileModStatement";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rUntilModStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/controlflowconversion/RubyControlFlowConversionInspection$RubyControlFlowStatementVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIfStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRUnlessStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRWhileStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRUntilStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRIfModStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRUnlessModStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRWhileModStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRUntilModStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

