/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.caseblock;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RCaseStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RElseBlock;

public final class RubyCaseWithoutElseBlockInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyCaseWithoutElseBlockInspection.$$$reportNull$$$0(0);
        }
        return new RubyCaseWithoutElseBlockVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/caseblock/RubyCaseWithoutElseBlockInspection", "buildVisitor"));
    }

    private static class RubyCaseWithoutElseBlockVisitor
    extends RubyInspectionVisitor {
        RubyCaseWithoutElseBlockVisitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                RubyCaseWithoutElseBlockVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRCaseStatement(@NotNull RCaseStatement rCaseStatement) {
            RElseBlock elseBlock;
            if (rCaseStatement == null) {
                RubyCaseWithoutElseBlockVisitor.$$$reportNull$$$0(1);
            }
            if ((elseBlock = rCaseStatement.getElseCase()) == null) {
                this.registerProblem(rCaseStatement.getFirstChild(), RBundle.message((String)"inspection.case.without.else"), new AddElseBlockFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rCaseStatement";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/caseblock/RubyCaseWithoutElseBlockInspection$RubyCaseWithoutElseBlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRCaseStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddElseBlockFix
    extends RubyFix {
        private AddElseBlockFix() {
        }

        @Override
        protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element;
            if (project == null) {
                AddElseBlockFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                AddElseBlockFix.$$$reportNull$$$0(1);
            }
            if ((element = descriptor.getPsiElement()).getParent() == null) {
                return;
            }
            RCaseStatement rCaseStatement = (RCaseStatement)element.getParent();
            RCaseStatement generatedCaseStatement = (RCaseStatement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)"case\nelse\nend\n");
            PsiComment generatedComment = RubyElementFactoryCore.createPsiComment((Project)project, (String)"# type code here");
            RElseBlock caseStatement = generatedCaseStatement.getElseCase();
            if (caseStatement != null) {
                rCaseStatement.addBefore((PsiElement)caseStatement, rCaseStatement.getLastChild());
                RElseBlock elseStatement = rCaseStatement.getElseCase();
                if (elseStatement != null) {
                    elseStatement.getBody().add((PsiElement)generatedComment);
                }
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.case.without.else.msg");
            if (string == null) {
                AddElseBlockFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/caseblock/RubyCaseWithoutElseBlockInspection$AddElseBlockFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/caseblock/RubyCaseWithoutElseBlockInspection$AddElseBlockFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

