/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference;

import com.intellij.psi.PsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.MethodDescriptor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RBodyStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfo;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;

public final class RubyBlockToMethodReferenceUtil {
    private RubyBlockToMethodReferenceUtil() {
    }

    @Nullable
    public static MethodDescriptor getBlockMethodDescriptor(@NotNull RBlockCall blockCall) {
        RCodeBlock block;
        RPsiElement statement;
        if (blockCall == null) {
            RubyBlockToMethodReferenceUtil.$$$reportNull$$$0(0);
        }
        if ((statement = RubyBlockToMethodReferenceUtil.getBlockStatement(block = blockCall.getBlock())) == null) {
            return null;
        }
        List<String> parameters = RubyBlockToMethodReferenceUtil.getSimpleBlockParameterNames(block);
        if (parameters == null) {
            return null;
        }
        MethodDescriptor descriptor = MethodDescriptor.fromElement((PsiElement)statement);
        if (descriptor == null || !parameters.equals(descriptor.getArguments())) {
            return null;
        }
        return descriptor;
    }

    public static void replaceBlock(@NotNull RBlockCall blockCall, @NotNull String reference) {
        RPossibleCall newCall;
        RPossibleCall possibleCall;
        RListOfExpressions arguments;
        if (blockCall == null) {
            RubyBlockToMethodReferenceUtil.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            RubyBlockToMethodReferenceUtil.$$$reportNull$$$0(2);
        }
        if ((arguments = RubyBlockToMethodReferenceUtil.getListOfExpressions(possibleCall = blockCall.getCall())) != null) {
            newCall = (RPossibleCall)RubyElementFactoryCore.createElementFromText((PsiElement)blockCall, (String)possibleCall.getText());
            RListOfExpressions newArguments = RubyBlockToMethodReferenceUtil.getListOfExpressions(newCall);
            assert (newArguments != null);
            newArguments.add((PsiElement)RubyElementFactory.createArgumentToBlockFromText((PsiElement)blockCall, reference));
        } else {
            newCall = (RPossibleCall)RubyElementFactoryCore.createElementFromText((PsiElement)blockCall, (String)(possibleCall.getText() + "(" + reference + ")"));
        }
        blockCall.replace((PsiElement)newCall);
    }

    @Nullable
    private static RPsiElement getBlockStatement(@NotNull RCodeBlock block) {
        if (block == null) {
            RubyBlockToMethodReferenceUtil.$$$reportNull$$$0(3);
        }
        if (RubyBlockToMethodReferenceUtil.isComplexCodeBlock(block)) {
            return null;
        }
        RCompoundStatement compoundStatement = block.getCompoundStatement();
        List statements = compoundStatement.getStatements();
        if (statements.size() != 1) {
            return null;
        }
        return (RPsiElement)statements.get(0);
    }

    @Nullable
    private static List<String> getSimpleBlockParameterNames(@NotNull RCodeBlock block) {
        RBlockArgumentList arguments;
        if (block == null) {
            RubyBlockToMethodReferenceUtil.$$$reportNull$$$0(4);
        }
        if ((arguments = block.getBlockArguments()) == null) {
            return Collections.emptyList();
        }
        List argumentInfos = arguments.getArgumentInfos();
        if (ContainerUtil.exists((Iterable)argumentInfos, it -> it.getType() != ArgumentInfo.Type.SIMPLE)) {
            return null;
        }
        return ContainerUtil.map((Collection)argumentInfos, ArgumentInfo::getName);
    }

    private static boolean isComplexCodeBlock(@NotNull RCodeBlock block) {
        RBodyStatement statement;
        if (block == null) {
            RubyBlockToMethodReferenceUtil.$$$reportNull$$$0(5);
        }
        if ((statement = block.getBodyStatement()) == null) {
            return false;
        }
        if (!statement.getRescueBlocks().isEmpty() || statement.getEnsureBlock() != null || statement.getElseBlock() != null) {
            return true;
        }
        return Arrays.stream(statement.getCompoundStatement().getChildren()).anyMatch(p -> p instanceof OuterLanguageElement);
    }

    @Nullable
    private static RListOfExpressions getListOfExpressions(@NotNull RPossibleCall possibleCall) {
        if (possibleCall == null) {
            RubyBlockToMethodReferenceUtil.$$$reportNull$$$0(6);
        }
        if (possibleCall instanceof RCall) {
            return ((RCall)possibleCall).getCallArguments();
        }
        if (possibleCall instanceof RLambdaCall) {
            return ((RLambdaCall)possibleCall).getCallArguments();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleCall";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/RubyBlockToMethodReferenceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockMethodDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockStatement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSimpleBlockParameterNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isComplexCodeBlock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getListOfExpressions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

