/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.MethodDescriptor;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.RubyBlockToMethodReferenceFix;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.RubyBlockToMethodReferenceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubyElementVisitor;

public final class RubyBlockToMethodReferenceInspection
extends LocalInspectionTool {
    public boolean myIgnoreMethodReferences = false;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyBlockToMethodReferenceInspection.$$$reportNull$$$0(0);
        }
        return new MyVisitor(holder);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myIgnoreMethodReferences", (String)RBundle.message((String)"inspection.block.replace.with.method.reference.option.name"), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            RubyBlockToMethodReferenceInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/RubyBlockToMethodReferenceInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/RubyBlockToMethodReferenceInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private final class MyVisitor
    extends RubyElementVisitor {
        @NotNull
        private final ProblemsHolder myHolder;

        MyVisitor(ProblemsHolder holder) {
            if (holder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitRBlockCall(@NotNull RBlockCall blockCall) {
            MethodDescriptor descriptor;
            if (blockCall == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            if ((descriptor = RubyBlockToMethodReferenceUtil.getBlockMethodDescriptor(blockCall)) == null) {
                return;
            }
            if (RubyBlockToMethodReferenceInspection.this.myIgnoreMethodReferences && descriptor.getReference().startsWith("&method")) {
                return;
            }
            PsiElement element = descriptor.getElement();
            if (element instanceof RDotReference && ((RDotReference)element).isSafeNavigation()) {
                return;
            }
            this.myHolder.registerProblem(descriptor.getElement(), RBundle.message((String)"inspection.block.replace.with.method.reference"), new LocalQuickFix[]{new RubyBlockToMethodReferenceFix(descriptor.getReference())});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockCall";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/blocktoreference/RubyBlockToMethodReferenceInspection$MyVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRBlockCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

