/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactoryCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlFlow.RControlFlowUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RSelfAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementImpl;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public final class RubyUnnecessaryReturnValueInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyUnnecessaryReturnValueInspection.$$$reportNull$$$0(0);
        }
        return new RubyInspectionVisitor(holder){

            public void visitRMethod(@NotNull RMethod method) {
                if (method == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (PsiElement element : RubyUnnecessaryReturnValueInspection.inspectMethod(method)) {
                    this.registerProblem(element, RBundle.message((String)"inspection.unnecessary.return.value.message"), new MyQuickFix());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/ruby/ruby/inspections/RubyUnnecessaryReturnValueInspection$1", "visitRMethod"));
            }
        };
    }

    @NotNull
    public static List<PsiElement> inspectMethod(@NotNull RMethod method) {
        if (method == null) {
            RubyUnnecessaryReturnValueInspection.$$$reportNull$$$0(1);
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (Instruction instruction : RControlFlowUtil.findExitInstructions((ControlFlow)method.getControlFlow())) {
            RAssignmentExpression assignment;
            RPsiElement rPsiElement;
            RPsiElement previousElement;
            RIdentifier element;
            PsiElement psiElement = instruction.getElement();
            if (!(psiElement instanceof RIdentifier) || RubyPsiUtilCore.getStatement((PsiElement)(element = (RIdentifier)psiElement)) != element || !((previousElement = RubyPsiUtil.getElementToLeftWithSameParent((PsiElement)element, RPsiElement.class)) instanceof RAssignmentExpression) || !((rPsiElement = (assignment = (RAssignmentExpression)previousElement).getObject()) instanceof RIdentifier)) continue;
            RIdentifier identifier = (RIdentifier)rPsiElement;
            if (element.getScopeVariable() != identifier.getScopeVariable()) continue;
            result.add((PsiElement)element);
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            RubyUnnecessaryReturnValueInspection.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyUnnecessaryReturnValueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyUnnecessaryReturnValueInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "inspectMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inspectMethod";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static final class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            PsiElement element = descriptor.getPsiElement();
            RAssignmentExpression previousElement = (RAssignmentExpression)ObjectUtils.tryCast((Object)RubyPsiUtil.getElementToLeftWithSameParent(element, RPsiElement.class), RAssignmentExpression.class);
            RCompoundStatementImpl compoundStatement = (RCompoundStatementImpl)PsiTreeUtil.getParentOfType((PsiElement)element, RCompoundStatementImpl.class);
            if (previousElement == null || previousElement.getValue() == null || compoundStatement == null) {
                return;
            }
            RSelfAssignmentExpression selfAssignmentExpression = (RSelfAssignmentExpression)ObjectUtils.tryCast((Object)previousElement, RSelfAssignmentExpression.class);
            if (selfAssignmentExpression != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(selfAssignmentExpression.getObject().getText());
                PsiElement operation = selfAssignmentExpression.getOperation();
                if (operation == null) {
                    return;
                }
                String operationText = operation.getText();
                sb.append(operationText, 0, operationText.length() - 1);
                RPsiElement value = selfAssignmentExpression.getValue();
                if (value == null) {
                    return;
                }
                sb.append(value.getText());
                selfAssignmentExpression.replace((PsiElement)RubyElementFactoryCore.createElementFromText((PsiElement)element, (String)sb.toString()));
            } else {
                previousElement.replace((PsiElement)previousElement.getValue());
            }
            compoundStatement.removeStatement(element);
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.unnecessary.return.value.remove.fix");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyUnnecessaryReturnValueInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyUnnecessaryReturnValueInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

