/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.support.UIUtil;

public final class RubyInterpreterInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyInterpreterInspection.$$$reportNull$$$0(0);
        }
        return new Visitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/ruby/ruby/inspections/RubyInterpreterInspection", "buildVisitor"));
    }

    private static final class Visitor
    extends RubyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        public void visitRFile(@NotNull RFile rFile) {
            if (rFile == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super.visitRFile(rFile);
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)rFile);
            if (rFile.getViewProvider() instanceof TemplateLanguageFileViewProvider && rFile.getLanguage() == rFile.getViewProvider().getBaseLanguage()) {
                return;
            }
            if (module != null) {
                Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module);
                if (sdk == null) {
                    this.registerProblem((PsiElement)rFile, RBundle.message((String)"inspection.invalid.interpreter.not.configured"), new ConfigureInterpreterFix());
                } else {
                    SdkTypeId sdkType = sdk.getSdkType();
                    if (!(sdkType instanceof RubySdkType) || !((RubySdkType)sdkType).sdkHasValidPath(sdk)) {
                        this.registerProblem((PsiElement)rFile, RBundle.message((String)"inspection.invalid.interpreter.configured"), new ConfigureInterpreterFix());
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rFile";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyInterpreterInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ConfigureInterpreterFix
    implements LocalQuickFix {
        private ConfigureInterpreterFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = RBundle.message((String)"inspection.invalid.interpreter.quick.fix.name");
            if (string == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(1);
            }
            if (previewDescriptor == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(2);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(3);
            }
            return intentionPreviewInfo;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                ConfigureInterpreterFix.$$$reportNull$$$0(5);
            }
            UIUtil.openRubyProjectSettings(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyInterpreterInspection$ConfigureInterpreterFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

