/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections;

import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyBaseInspection;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RName;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.visitors.RubySystemCallVisitor;

public class RubyInspectionVisitor
extends RubySystemCallVisitor {
    protected ProblemsHolder myHolder;
    protected boolean myOnTheFly;
    private RubyBaseInspection inspection;

    public RubyInspectionVisitor() {
        this.myOnTheFly = false;
        this.inspection = null;
    }

    public RubyInspectionVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(0);
        }
        this.myOnTheFly = false;
        this.inspection = null;
        this.myHolder = holder;
    }

    public RubyInspectionVisitor(@NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(1);
        }
        this.myOnTheFly = false;
        this.inspection = null;
        this.myHolder = holder;
        this.myOnTheFly = onTheFly;
    }

    public void setInspection(RubyBaseInspection inspection) {
        this.inspection = inspection;
    }

    public void setOnTheFly(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    protected void registerVariableError(RIdentifier variable, Object ... args) {
        if (variable == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes((PsiElement)variable);
        String description = this.inspection.buildErrorString(args);
        this.registerError((PsiElement)variable, description, fix);
    }

    protected void registerGlobalVariableError(@NotNull RGlobalVariable variable, @NotNull String name) {
        if (variable == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (name == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(3);
        }
        LocalQuickFix[] fix = this.createFixes((PsiElement)variable);
        String description = this.inspection.buildErrorString(name);
        this.myHolder.registerProblem((PsiElement)variable, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, TextRange.from((int)1, (int)name.length()), fix);
    }

    protected void registerConstantError(RConstant constant, Object ... args) {
        if (constant == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes((PsiElement)constant);
        String description = this.inspection.buildErrorString(args);
        this.registerError((PsiElement)constant, description, fix);
    }

    protected void registerFieldError(RField variable, Object ... args) {
        if (variable == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes((PsiElement)variable);
        String description = this.inspection.buildErrorString(args);
        this.registerError((PsiElement)variable, description, fix);
    }

    protected void registerMethodError(RMethod method, Object ... args) {
        if (method == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes((PsiElement)method);
        String description = this.inspection.buildErrorString(args);
        RName nameElement = method.getMethodName();
        if (nameElement == null || nameElement.getTextRange().isEmpty()) {
            return;
        }
        this.registerError((PsiElement)nameElement, description, fix);
    }

    protected void registerContainerError(RContainer container, Object ... args) {
        if (container == null) {
            return;
        }
        LocalQuickFix[] fix = this.createFixes((PsiElement)container);
        String description = this.inspection.buildErrorString(args);
        Object nameElement = container instanceof RClass ? ((RClass)container).getClassName() : (container instanceof RModule ? ((RModule)container).getModuleName() : container);
        if (nameElement == null) {
            return;
        }
        this.registerError((PsiElement)nameElement, description, fix);
    }

    private void registerError(@NotNull PsiElement location, @InspectionMessage String description, LocalQuickFix[] fixes) {
        if (location == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(4);
        }
        this.myHolder.registerProblem(location, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    private @NotNull LocalQuickFix @Nullable [] createFixes(PsiElement location) {
        if (!this.myOnTheFly && this.inspection.buildQuickFixesOnlyForOnTheFlyErrors()) {
            return null;
        }
        LocalQuickFix fix = this.inspection.buildFix(location);
        if (fix == null) {
            return null;
        }
        return new LocalQuickFix[]{fix};
    }

    protected void registerProblem(PsiElement element, @InspectionMessage String message) {
        if (element == null || element.getTextLength() == 0 && !(element instanceof RFile)) {
            return;
        }
        this.myHolder.registerProblem(element, message, new LocalQuickFix[0]);
    }

    protected void registerProblem(@Nullable PsiElement element, @Nullable TextRange rangeInParent, @NotNull @InspectionMessage String message, LocalQuickFix ... fixes) {
        if (message == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(5);
        }
        if (fixes == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(6);
        }
        if (element == null || element.getTextLength() == 0 && !(element instanceof RFile)) {
            return;
        }
        this.myHolder.registerProblem(element, rangeInParent, message, fixes);
    }

    protected final void registerProblem(@Nullable PsiElement firstElement, @Nullable PsiElement lastElement, @NotNull @InspectionMessage String message, @NotNull ProblemHighlightType type, LocalQuickFix ... fixes) {
        if (message == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(7);
        }
        if (type == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(8);
        }
        if (fixes == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(9);
        }
        if (firstElement == null || lastElement == null) {
            return;
        }
        Project project = firstElement.getProject();
        ProblemDescriptor descriptor = InspectionManager.getInstance((Project)project).createProblemDescriptor(firstElement, lastElement, message, type, this.myHolder.isOnTheFly(), fixes);
        this.myHolder.registerProblem(descriptor);
    }

    public final void registerProblem(@Nullable PsiElement element, @NotNull @InspectionMessage String message, LocalQuickFix ... quickFixes) {
        if (message == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(10);
        }
        if (quickFixes == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(11);
        }
        if (element == null || element.getTextLength() == 0 && !(element instanceof RFile)) {
            return;
        }
        this.myHolder.registerProblem(element, message, quickFixes);
    }

    protected final void registerProblem(PsiElement element, @InspectionMessage String message, ProblemHighlightType type, @Nullable HintAction action) {
        if (element == null || element.getTextLength() == 0 && !(element instanceof RFile)) {
            return;
        }
        this.myHolder.registerProblem(((InspectionManagerEx)this.myHolder.getManager()).createProblemDescriptor(element, message, type, action, this.myHolder.isOnTheFly(), new LocalQuickFix[0]));
    }

    public final void registerProblem(PsiElement element, @InspectionMessage String message, ProblemHighlightType type, LocalQuickFix ... quickFixes) {
        if (quickFixes == null) {
            RubyInspectionVisitor.$$$reportNull$$$0(12);
        }
        if (element == null || element.getTextLength() == 0 && !(element instanceof RFile)) {
            return;
        }
        this.myHolder.registerProblem(element, message, type, quickFixes);
    }

    public void setProblemsHolder(ProblemsHolder problemsHolder) {
        this.myHolder = problemsHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/RubyInspectionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerGlobalVariableError";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

