/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.values;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XStringValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.run.filters.RStackTraceFilter;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyStackFrame;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValue;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyPrimitiveValue;
import org.rubyforge.debugcommons.model.RubyValue;

public class RubyStringValue
extends RubyPrimitiveValue {
    public RubyStringValue(Project project, XSourcePosition position, RubyStackFrame frame, @Nullable RubyDebugValue parentDebugValue, @NotNull String name, @NotNull RubyValue value) {
        if (name == null) {
            RubyStringValue.$$$reportNull$$$0(0);
        }
        if (value == null) {
            RubyStringValue.$$$reportNull$$$0(1);
        }
        super(project, frame, parentDebugValue, position, name, value);
    }

    @Override
    @NotNull
    protected XValuePresentation getPresentation(@NotNull XValuePlace place) {
        if (place == null) {
            RubyStringValue.$$$reportNull$$$0(2);
        }
        String valueString = RubyDebuggerSupportUtils.getRubyValuePresentationString(this.myValue);
        String fullValue = RubyDebuggerSupportUtils.convertToIdeEncoding(valueString);
        return new XStringValuePresentation(fullValue);
    }

    @Override
    public void computeTypeSourcePosition(@NotNull XNavigatable navigatable) {
        OpenFileDescriptor descriptor;
        String valueString;
        Filter.Result result;
        if (navigatable == null) {
            RubyStringValue.$$$reportNull$$$0(3);
        }
        if ((result = new RStackTraceFilter(this.myProject).applyFilter(valueString = RubyDebuggerSupportUtils.getRubyValuePresentationString(this.myValue), valueString.length())) == null) {
            return;
        }
        FileHyperlinkInfo info = (FileHyperlinkInfo)result.getFirstHyperlinkInfo();
        OpenFileDescriptor openFileDescriptor = descriptor = info != null ? info.getDescriptor() : null;
        if (descriptor == null) {
            return;
        }
        navigatable.setSourcePosition(XDebuggerUtil.getInstance().createPositionByOffset(descriptor.getFile(), descriptor.getOffset()));
    }

    @Override
    @NotNull
    protected String getValueString() {
        String string = "'" + this.myValue.getValueString() + "'";
        if (string == null) {
            RubyStringValue.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyStringValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/values/RubyStringValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeTypeSourcePosition";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

